/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import net.jsdai.ida_step.Activator;
import net.jsdai.ida_step.Application;
import net.jsdai.ida_step.ApplicationActionBarAdvisor;
import net.jsdai.ida_step.ControlPipe;
import net.jsdai.ida_step.actions.RegisterAndInstallAction;
import net.jsdai.ida_step.installation.LicenseProperties;
import net.jsdai.ida_step.installation.NewsJob;
import net.jsdai.ida_step.installation.RegistrationStatus;
import net.jsdai.ida_step.l10n.CommonStringsMessages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final String APPLICATION_TITLE = Platform.getProduct().getName();
    private final IPerspectiveListener perspectiveListener = new IPerspectiveListener(){
        private final Map<IWorkbenchPage, String> lastPerspectivePerPageMap = new HashMap<IWorkbenchPage, String>();

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            if ("editorAreaShow".equals(changeId)) {
                page.setEditorAreaVisible(false);
            }
            if (this.isUpdateToolbarNeeded(page, perspective)) {
                this.updateToolbar(page);
            }
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (this.isUpdateToolbarNeeded(page, perspective)) {
                this.updateToolbar(page);
            }
        }

        private boolean isUpdateToolbarNeeded(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (perspective == null) {
                return false;
            }
            String lastPerspective = this.lastPerspectivePerPageMap.put(page, perspective.getId());
            return !perspective.getId().equals(lastPerspective);
        }

        private void updateToolbar(IWorkbenchPage page) {
            if (page.getWorkbenchWindow() instanceof ApplicationWindow) {
                ((ApplicationWindow)page.getWorkbenchWindow()).getCoolBarManager().resetItemOrder();
            }
        }
    };
    private final IPartListener2 partListener = new IPartListener2(){
        IPropertyListener propertyListener = new IPropertyListener(){
            int prevDirtyFlagValue = -1;

            public void propertyChanged(Object source, int propId) {
                if (source instanceof IEditorPart && (propId == 257 || propId == 258 || propId == 1)) {
                    IEditorPart editorPart = (IEditorPart)source;
                    boolean dirtyFlag = editorPart.isDirty();
                    if (propId != 257) {
                        this.prevDirtyFlagValue = -1;
                    }
                    if (dirtyFlag) {
                        if (this.prevDirtyFlagValue != 1) {
                            editorPart.getSite().getShell().setText(ApplicationWorkbenchWindowAdvisor.getWindowTitle(editorPart, true));
                        }
                    } else if (this.prevDirtyFlagValue != 0) {
                        editorPart.getSite().getShell().setText(ApplicationWorkbenchWindowAdvisor.getWindowTitle(editorPart, false));
                    }
                    this.prevDirtyFlagValue = dirtyFlag ? 1 : 0;
                }
            }
        };

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                partRef.addPropertyListener(this.propertyListener);
                IEditorPart editor = (IEditorPart)partRef.getPart(false);
                if (editor != null) {
                    IEditorInput input = editor.getEditorInput();
                    IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                    IEditorDescriptor descriptor = registry.findEditor(editor.getEditorSite().getId());
                    if (input != null && descriptor != null) {
                        Activator.getDefault().getEditorHistory().add(input, descriptor);
                    }
                }
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            IEditorReference editorRef;
            IWorkbenchPart editorPart;
            if (partRef instanceof IEditorReference && (editorPart = (editorRef = (IEditorReference)partRef).getPart(false)) != null) {
                this.propertyListener.propertyChanged((Object)editorPart, 258);
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                IEditorReference editorRef = (IEditorReference)partRef;
                editorRef.removePropertyListener(this.propertyListener);
                partRef.getPage().getWorkbenchWindow().getShell().setText(ApplicationWorkbenchWindowAdvisor.getApplicationTitle());
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
            IEditorReference editorRef;
            IWorkbenchPart editorPart;
            if (partRef instanceof IEditorReference && (editorPart = (editorRef = (IEditorReference)partRef).getPart(false)) != null) {
                this.propertyListener.propertyChanged((Object)editorPart, 1);
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }
    };
    private final IPageListener pageListener = new IPageListener(){

        public void pageOpened(IWorkbenchPage page) {
            page.addPartListener(ApplicationWorkbenchWindowAdvisor.this.partListener);
        }

        public void pageClosed(IWorkbenchPage page) {
            page.removePartListener(ApplicationWorkbenchWindowAdvisor.this.partListener);
        }

        public void pageActivated(IWorkbenchPage page) {
        }
    };

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setTitle(ApplicationWorkbenchWindowAdvisor.getApplicationTitle());
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowFastViewBars(false);
        configurer.setShowMenuBar(true);
        configurer.setShowProgressIndicator(true);
        IPerspectiveDescriptor[] perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        configurer.setShowPerspectiveBar(perspectives.length > 0);
        IWorkbenchWindow window = configurer.getWindow();
        window.addPerspectiveListener(this.perspectiveListener);
        window.addPageListener(this.pageListener);
    }

    public void postWindowOpen() {
        IPerspectiveDescriptor[] perspectives;
        if (this.getWindowConfigurer().getWindow().getActivePage() == null && (perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives()).length > 0) {
            try {
                this.getWindowConfigurer().getWindow().openPage(perspectives[0].getId(), null);
            }
            catch (WorkbenchException e) {
                e.printStackTrace();
            }
        }
        if (Application.getInstance().startingOnce()) {
            try {
                ActionFactory.IWorkbenchAction newAction;
                final IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
                RegistrationStatus registrationStatus = new RegistrationStatus();
                registrationStatus.updateStatus();
                if (registrationStatus.isNewsPossible()) {
                    NewsJob job = new NewsJob(NLS.bind((String)CommonStringsMessages.news, (Object)"..."), window);
                    job.setSystem(true);
                    job.schedule();
                }
                if (registrationStatus.isShowRegistrationDialog()) {
                    window.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            new RegisterAndInstallAction(window).run();
                        }
                    });
                }
                if (!ControlPipe.getInstance().processAppArgs(window) && (newAction = ApplicationActionBarAdvisor.getWeightedAction(window, "net.jsdai.product.newAction")) != null) {
                    newAction.run();
                }
                ControlPipe.getInstance().start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String getApplicationTitle() {
        return ApplicationWorkbenchWindowAdvisor.getWindowTitle(null, false);
    }

    private static String getWindowTitle(IEditorPart editorPart, boolean markDirty) {
        String additionalMessage;
        String editorString;
        if (editorPart != null) {
            editorString = markDirty ? " - *" : " - ";
            editorString = String.valueOf(editorString) + editorPart.getTitle();
        } else {
            editorString = "";
        }
        try {
            additionalMessage = LicenseProperties.load().getTitleBarMessage();
        }
        catch (Exception e) {
            Activator.logError("", e);
            additionalMessage = null;
        }
        String format = additionalMessage != null ? "{0}{1} (" + additionalMessage + ")" : "{0}{1}";
        return NLS.bind((String)format, (Object)APPLICATION_TITLE, (Object)editorString);
    }
}

