/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class IdaStepProtocolHandler
extends AbstractURLStreamHandlerService {
    public static final String PROTOCOL = "ida-step";

    public URLConnection openConnection(URL url) throws IOException {
        return new IdaStepConnection(url);
    }

    private static class IdaStepConnection
    extends URLConnection {
        private static final int TYPE_UPDATE_POLICY = 1;
        private static final byte[] UPDATE_POLICY_HEAD_BYTES;
        private static final byte[] UPDATE_POLICY_TAIL_BYTES;
        private int type;

        static {
            try {
                UPDATE_POLICY_HEAD_BYTES = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<update-policy>\n\t<url-map pattern=\"*\"\n\t\turl=\"https://services.ida-step.net/update/".getBytes("UTF-8");
                UPDATE_POLICY_TAIL_BYTES = "\"/>\n</update-policy>".getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private IdaStepConnection(URL url) {
            super(url);
        }

        public void connect() throws IOException {
            if (this.connected) {
                return;
            }
            String path = this.url.getPath();
            if ("update-policy.xml".equals(path) && this.url.getRef() != null) {
                this.type = 1;
            }
            if (this.type == 0) {
                throw new MalformedURLException("Unrecognized url: " + this.url);
            }
            this.connected = true;
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            switch (this.type) {
                case 1: {
                    return this.getUpdatePolicyInputStream();
                }
            }
            return super.getInputStream();
        }

        private InputStream getUpdatePolicyInputStream() throws IOException {
            byte[] reference = this.url.getRef().getBytes("UTF-8");
            byte[] updatePoliceBytes = new byte[UPDATE_POLICY_HEAD_BYTES.length + reference.length + UPDATE_POLICY_TAIL_BYTES.length];
            System.arraycopy(UPDATE_POLICY_HEAD_BYTES, 0, updatePoliceBytes, 0, UPDATE_POLICY_HEAD_BYTES.length);
            System.arraycopy(reference, 0, updatePoliceBytes, UPDATE_POLICY_HEAD_BYTES.length, reference.length);
            System.arraycopy(UPDATE_POLICY_TAIL_BYTES, 0, updatePoliceBytes, UPDATE_POLICY_HEAD_BYTES.length + reference.length, UPDATE_POLICY_TAIL_BYTES.length);
            return new ByteArrayInputStream(updatePoliceBytes);
        }
    }
}

