/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jsdai.ida_step.Activator;
import net.jsdai.repo_edit.services.LicensingService;
import org.eclipse.osgi.util.NLS;

public class LicenseProperties {
    private static final boolean DEBUG = false;
    private final Properties properties;

    public static LicenseProperties load() throws IOException, GeneralSecurityException {
        Properties licenseProperties = LicensingService.getInstance().loadLicenseProperties();
        return new LicenseProperties(licenseProperties);
    }

    private LicenseProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public String getLicenseNumber() {
        return this.properties.getProperty("license-num");
    }

    public String getHostId() {
        return this.properties.getProperty("host-id");
    }

    public String getAccessPassword() {
        return this.properties.getProperty("access-password");
    }

    public String getRelease() {
        return this.properties.getProperty("release");
    }

    public String getLicenseeName() {
        return this.properties.getProperty("licensee-name");
    }

    public String getLicenseeOrganization() {
        return this.properties.getProperty("licensee-organization");
    }

    public String getLicenseExpireDate() {
        return this.properties.getProperty("license-expire-date");
    }

    public Date getIssuedAtDate() {
        String dateString = this.properties.getProperty("issued-at-date");
        if (dateString != null) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd").parse(dateString);
            }
            catch (ParseException e) {
                Activator.logError("Failed to parse issued date: " + dateString, e);
            }
        }
        return null;
    }

    public String getHdd0() {
        return this.properties.getProperty("hdd0");
    }

    public String getVolumeIds() {
        return this.properties.getProperty("volume-ids");
    }

    public boolean isNewsPossible() {
        return this.getHostId() != null && this.getAccessPassword() != null;
    }

    public String getTitleBarMessage() {
        return this.properties.getProperty("title-bar-message");
    }

    public boolean isAdvertiseShop() {
        return this.properties.containsKey("advertise-shop");
    }

    public URL getAdvertiseUrl() {
        String iconProperty = this.properties.getProperty("advertise-url");
        if (iconProperty != null) {
            return this.getUrl(iconProperty);
        }
        return null;
    }

    public String getAdvertiseGenericUrl() {
        return this.properties.getProperty("advertise-generic-url");
    }

    public URL getAdvertiseButtonIconUrl() {
        String iconProperty = this.properties.getProperty("advertise-button-icon");
        if (iconProperty != null) {
            return this.getUrl(iconProperty);
        }
        return null;
    }

    private URL getUrl(String urlString) {
        String formattedUrlString = urlString;
        Pattern variablePattern = Pattern.compile("\\$\\{([^}]+)\\}");
        Matcher matcher = variablePattern.matcher(formattedUrlString);
        while (matcher.find()) {
            String variableProperty = matcher.group(1);
            String variableValue = this.properties.getProperty(variableProperty);
            if (variableValue == null) {
                Activator.logError(NLS.bind((String)"Unable to obtain license property {0} to format URL {1}", (Object)variableProperty, (Object)urlString), null);
                variableValue = "";
            }
            formattedUrlString = formattedUrlString.replace(matcher.group(), variableValue);
            matcher.reset(formattedUrlString);
        }
        try {
            return new URL(formattedUrlString);
        }
        catch (MalformedURLException e) {
            Activator.logError(String.valueOf(urlString) + " -> " + formattedUrlString, e);
            return null;
        }
    }
}

