/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import net.jsdai.ida_step.actions.ShopToolbarContributionItem;
import net.jsdai.ida_step.installation.LicenseProperties;
import net.jsdai.ida_step.installation.RegistrationStatus;
import net.jsdai.ida_step.installation.RegistrationUtils;
import net.jsdai.ida_step.installation.RegistrationWizard;
import net.jsdai.ida_step.l10n.CommonStringsMessages;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.services.LicensedFeatureData;
import net.jsdai.repo_edit.services.LicensingService;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationPage
extends WizardPage {
    private static final String REGISTRATION_PAGE_CONTEXT_ID = "net.jsdai.ida_step.registration_page_context";
    private static final Pattern LICENSE_PATTERN = Pattern.compile("[\u0000- ]*[0-9a-zA-Z]{5}-[0-9a-zA-Z]{5}-[0-9a-zA-Z]{5}-[0-9a-zA-Z]{5}-[0-9a-zA-Z]{5}[\u0000- ]*");
    private Button freeLicenseButton;
    private Button licenseIdButton;
    private Button currentLicenseButton;
    private Text licenseText;
    private String currentLicenseNum;
    private RegistrationStatus registrationStatus;

    public RegistrationPage() {
        super("registrationPage");
        this.setTitle(IdaStepMessages.RegistrationPage_title);
        this.setDescription(IdaStepMessages.RegistrationPage_description);
        this.registrationStatus = null;
        this.currentLicenseNum = null;
    }

    public void createControl(Composite parent) {
        try {
            this.registrationStatus = ((RegistrationWizard)this.getWizard()).registrationStatus;
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            LicenseProperties licenseProperties = LicenseProperties.load();
            this.createLicenseGroup(composite, licenseProperties);
            this.createFeatureGroup(composite, licenseProperties);
            this.createStatusGroup(composite, licenseProperties, this.registrationStatus.getLicenseStatus().getMessage());
            this.createShopButton(composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, REGISTRATION_PAGE_CONTEXT_ID);
            LicensingService licensingService = LicensingService.getInstance();
            String offlineLicenseNum = licensingService.loadOfflineLicense();
            if (offlineLicenseNum != null && !offlineLicenseNum.equals(this.currentLicenseNum)) {
                this.freeLicenseButton.setSelection(false);
                this.licenseIdButton.setSelection(true);
                this.currentLicenseButton.setSelection(false);
                this.licenseText.setText(offlineLicenseNum);
                this.licenseText.setEnabled(true);
                this.licenseText.setFocus();
                this.updateStatus();
            }
            this.setControl((Control)composite);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private void createShopButton(Composite composite) {
        Group shopGroup = new Group(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        shopGroup.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        shopGroup.setLayout((Layout)layout);
        Button shopButton = new Button((Composite)shopGroup, 8);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        shopButton.setLayoutData((Object)gridData);
        shopButton.setText(IdaStepMessages.RegistrationPage_shopButton_text);
        shopButton.setAlignment(0x1000000);
        shopButton.setVisible(true);
        shopButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ShopToolbarContributionItem.openShop(event.widget.getDisplay().getActiveShell());
            }
        });
    }

    private void createLicenseGroup(Composite composite, LicenseProperties licenseProperties) {
        Group licenseGroup = new Group(composite, 0);
        licenseGroup.setText(CommonStringsMessages.license);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        licenseGroup.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        licenseGroup.setLayout((Layout)layout);
        this.freeLicenseButton = new Button((Composite)licenseGroup, 16);
        this.freeLicenseButton.setText(IdaStepMessages.RegistrationPage_freeLicenseButton_text);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = 2;
        this.freeLicenseButton.setLayoutData((Object)gridData);
        this.licenseIdButton = new Button((Composite)licenseGroup, 16);
        this.licenseIdButton.setText(IdaStepMessages.RegistrationPage_licenseIdButton_text);
        gridData = new GridData();
        this.licenseIdButton.setLayoutData((Object)gridData);
        this.licenseText = new Text((Composite)licenseGroup, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.licenseText.setLayoutData((Object)gridData);
        this.licenseText.setMessage(IdaStepMessages.RegistrationPage_licenseText_message);
        this.licenseText.setTextLimit(29);
        this.licenseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegistrationPage.this.updateStatus();
            }
        });
        this.licenseText.addVerifyListener(new VerifyListener(){
            boolean ignore;
            int caretPos = 0;

            public void verifyText(VerifyEvent e) {
                int i;
                if (this.ignore) {
                    return;
                }
                e.doit = false;
                if (e.keyCode != 8 && e.keyCode != 127 && !e.text.matches("[\\w[-][\\s]]+")) {
                    return;
                }
                if (e.text.contains("-")) {
                    e.text = e.text.replaceAll("-", "");
                }
                e.text = e.text.trim();
                e.text = e.text.toUpperCase();
                if (e.text.contains("O")) {
                    e.text = e.text.replace('O', '0');
                }
                StringBuffer text = new StringBuffer(RegistrationPage.this.licenseText.getText());
                int lengthBefore = text.length();
                text.replace(e.start, e.end, e.text);
                if (text.toString().contains("-")) {
                    i = 0;
                    while (i < text.length()) {
                        if (text.charAt(i) == '-') {
                            text.deleteCharAt(i);
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < text.length()) {
                    switch (i + 1) {
                        case 5: 
                        case 11: 
                        case 17: 
                        case 23: {
                            text.insert(i + 1, '-');
                        }
                    }
                    ++i;
                }
                if (text.length() > 29) {
                    return;
                }
                int lengthAfter = text.length();
                int def = lengthAfter - lengthBefore - e.text.length() + RegistrationPage.this.licenseText.getSelectionCount();
                this.caretPos = e.start + e.text.length();
                if (e.text.length() == 1) {
                    if ((this.caretPos + def) % 6 == 0) {
                        ++this.caretPos;
                    }
                } else if (e.text.length() > 1) {
                    this.caretPos = def > 0 ? (this.caretPos += def) : ++this.caretPos;
                }
                this.ignore = true;
                RegistrationPage.this.licenseText.setText(text.toString());
                RegistrationPage.this.licenseText.setSelection(this.caretPos);
                this.ignore = false;
            }
        });
        this.currentLicenseButton = new Button((Composite)licenseGroup, 16);
        this.currentLicenseButton.setText(IdaStepMessages.RegistrationPage_currentLicenseButton_text);
        gridData = new GridData();
        this.currentLicenseButton.setLayoutData((Object)gridData);
        Group currentLicenseGroup = new Group((Composite)licenseGroup, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        currentLicenseGroup.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.numColumns = 2;
        currentLicenseGroup.setLayout((Layout)layout);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegistrationPage.this.licenseText.setEnabled(RegistrationPage.this.licenseIdButton.getSelection());
                RegistrationPage.this.licenseText.setFocus();
                RegistrationPage.this.updateStatus();
            }
        };
        this.freeLicenseButton.addSelectionListener((SelectionListener)buttonListener);
        this.licenseIdButton.addSelectionListener((SelectionListener)buttonListener);
        this.currentLicenseButton.addSelectionListener((SelectionListener)buttonListener);
        if (!licenseProperties.isEmpty()) {
            String licenseNum;
            this.currentLicenseButton.setSelection(true);
            this.currentLicenseButton.setFocus();
            this.currentLicenseNum = licenseNum = licenseProperties.getLicenseNumber();
            if (licenseNum != null) {
                String release = licenseProperties.getRelease();
                if (release != null) {
                    licenseNum = String.valueOf(licenseNum) + " (" + release + ')';
                }
            } else {
                licenseNum = "FREE LICENSE";
            }
            RegistrationPage.showLicenseProperty((Composite)currentLicenseGroup, licenseNum, null);
            RegistrationPage.showLicenseProperty((Composite)currentLicenseGroup, licenseProperties.getLicenseeName(), "Name");
            RegistrationPage.showLicenseProperty((Composite)currentLicenseGroup, licenseProperties.getLicenseeOrganization(), "Organization");
            RegistrationPage.showLicenseProperty((Composite)currentLicenseGroup, licenseProperties.getLicenseExpireDate(), "Expiration date");
        } else {
            this.freeLicenseButton.setSelection(true);
            this.freeLicenseButton.setFocus();
            this.currentLicenseButton.setEnabled(false);
            Text noRegistrationLabel = new Text((Composite)currentLicenseGroup, 8);
            noRegistrationLabel.setText(IdaStepMessages.RegistrationPage_noRegistrationLabel_text);
            noRegistrationLabel.setBackground(currentLicenseGroup.getBackground());
            noRegistrationLabel.setEnabled(false);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            noRegistrationLabel.setLayoutData((Object)gridData);
        }
        buttonListener.widgetSelected(null);
    }

    private void createFeatureGroup(Composite composite, LicenseProperties licenseProperties) throws IOException, GeneralSecurityException {
        Group featureGroup = new Group(composite, 0);
        featureGroup.setText(IdaStepMessages.RegistrationPage_featureGroup_text);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        featureGroup.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        featureGroup.setLayout((Layout)layout);
        Collection<FeatureTableItemData> featureDataCollection = this.createFeatureData(licenseProperties);
        this.createFeatureTable((Composite)featureGroup, featureDataCollection);
    }

    private void createStatusGroup(Composite composite, LicenseProperties licenseProperties, String wizardMessage) {
        Group statusGroup = new Group(composite, 0);
        statusGroup.setText(CommonStringsMessages.status);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        statusGroup.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        statusGroup.setLayout((Layout)layout);
        if (wizardMessage != null) {
            Composite messageComposite = new Composite((Composite)statusGroup, 0);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = 2;
            messageComposite.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            messageComposite.setLayoutData((Object)gridData);
            Label messageImage = new Label(messageComposite, 0);
            messageImage.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
            gridData = new GridData();
            messageImage.setLayoutData((Object)gridData);
            Label messageLabel = new Label(messageComposite, 64);
            messageLabel.setText(wizardMessage);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = this.convertHorizontalDLUsToPixels(315);
            messageLabel.setLayoutData((Object)gridData);
        }
        final Button showRegistrationWarningsButton = new Button((Composite)statusGroup, 32);
        showRegistrationWarningsButton.setText(IdaStepMessages.RegistrationPage_showRegistrationWarningsButton_text);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        showRegistrationWarningsButton.setLayoutData((Object)gridData);
        showRegistrationWarningsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                showRegistrationWarningsButton.setSelection(!showRegistrationWarningsButton.getSelection());
                boolean showRegistrationWarnings = RegistrationPage.this.registrationStatus.isShowRegistrationWarnings();
                boolean confirm = MessageDialog.openQuestion((Shell)RegistrationPage.this.getShell(), (String)IdaStepMessages.RegistrationPage_msgDialog_title, (String)(showRegistrationWarnings ? IdaStepMessages.RegistrationPage_msgDialog_enableActivation_message : IdaStepMessages.RegistrationPage_msgDialog_diableActivation_message));
                if (confirm) {
                    showRegistrationWarnings = !showRegistrationWarnings;
                    RegistrationPage.this.registrationStatus.setShowRegistrationWarnings(showRegistrationWarnings);
                    showRegistrationWarningsButton.setSelection(showRegistrationWarnings);
                }
            }
        });
        showRegistrationWarningsButton.setSelection(this.registrationStatus.isShowRegistrationWarnings());
    }

    public String getLicenseNum() {
        return this.freeLicenseButton.getSelection() ? null : this.licenseText.getText().trim().toUpperCase();
    }

    public String getCurrentLicenseNum() {
        return this.currentLicenseNum;
    }

    public boolean isNewLicense() {
        return this.freeLicenseButton.getSelection() || this.licenseIdButton.getSelection();
    }

    public boolean canFlipToNextPage() {
        boolean canFlipToNextPage = super.canFlipToNextPage();
        if (canFlipToNextPage) {
            canFlipToNextPage = this.isNewLicense() ? this.getLicenseNum() != null : this.getCurrentLicenseNum() != null;
        }
        return canFlipToNextPage;
    }

    private Collection<FeatureTableItemData> createFeatureData(LicenseProperties licenseProperties) throws IOException, GeneralSecurityException {
        ArrayList<FeatureTableItemData> featureData = new ArrayList<FeatureTableItemData>();
        Collection licensedFeatures = LicensingService.getInstance().loadLicensedFeatures();
        Map<String, IBundleGroup> installedFeatures = RegistrationUtils.getInstalledFeatures();
        for (LicensedFeatureData licFeatureData : licensedFeatures) {
            String featureId = licFeatureData.getFeatureId();
            IBundleGroup bundleGroup = installedFeatures.get(featureId);
            featureData.add(new FeatureTableItemData(bundleGroup != null ? bundleGroup.getName() : featureId, licFeatureData.getExpireDate(), licFeatureData.isExpired() ? CommonStringsMessages.expired : (bundleGroup == null ? IdaStepMessages.RegistrationPage_notInstalledMessage : CommonStringsMessages.ok)));
        }
        Collections.sort(featureData, new Comparator<FeatureTableItemData>(){

            @Override
            public int compare(FeatureTableItemData d1, FeatureTableItemData d2) {
                String name1 = d1.getFeatureName();
                String name2 = d2.getFeatureName();
                if (name1 != null) {
                    if (name2 != null) {
                        return name1.compareTo(name2);
                    }
                    return 1;
                }
                return name2 != null ? -1 : 0;
            }
        });
        return featureData;
    }

    private void createFeatureTable(Composite parent, Collection<FeatureTableItemData> featureDataCollection) {
        Table table = new Table(parent, 68356);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertVerticalDLUsToPixels(55);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(this.convertHorizontalDLUsToPixels(180));
        tableColumn.setText(IdaStepMessages.RegistrationPage_featureNameColumn_text);
        tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(this.convertHorizontalDLUsToPixels(70));
        tableColumn.setText(IdaStepMessages.RegistrationPage_expirationDateColumn_text);
        tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(this.convertHorizontalDLUsToPixels(65));
        tableColumn.setText(CommonStringsMessages.status);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (FeatureTableItemData featureData : featureDataCollection) {
            Date expireDate = featureData.getExpireDate();
            String dateString = expireDate != null ? dateFormat.format(expireDate) : IdaStepMessages.RegistrationPage_dateString;
            TableItem item = new TableItem(table, 0);
            item.setText(new String[]{featureData.getFeatureName(), dateString, featureData.getStatus()});
        }
    }

    private static void showLicenseProperty(Composite composite, String propertyValue, String displayName) {
        if (propertyValue != null) {
            if (displayName != null) {
                Label propLabel = new Label(composite, 1);
                propLabel.setText(displayName);
                Text propValue = new Text(composite, 8);
                propValue.setText(propertyValue);
                propValue.setBackground(composite.getBackground());
            } else {
                Text propValue = new Text(composite, 8);
                propValue.setText(propertyValue);
                propValue.setBackground(composite.getBackground());
                GridData gridData = new GridData();
                gridData.horizontalSpan = 2;
                propValue.setLayoutData((Object)gridData);
            }
        }
    }

    private void updateStatus() {
        String licenseTextText;
        if (this.licenseIdButton.getSelection() && !LICENSE_PATTERN.matcher(licenseTextText = this.licenseText.getText()).matches()) {
            this.setMessage(licenseTextText.length() == 0 ? IdaStepMessages.RegistrationPage_messageTitle_licenseNotYetEntered : IdaStepMessages.RegistrationPage_message_enteredLicenseInvalid, 3);
            this.setPageComplete(false);
        } else {
            this.setMessage(null);
            this.setPageComplete(true);
        }
    }

    private static final class FeatureTableItemData {
        private final String featureName;
        private final Date expireDate;
        private final String status;

        public FeatureTableItemData(String featureName, Date expireDate, String status) {
            this.featureName = featureName;
            this.expireDate = expireDate;
            this.status = status;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public Date getExpireDate() {
            return this.expireDate;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

