/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import net.jsdai.ida_step.Activator;
import net.jsdai.ida_step.installation.LicenseProperties;
import net.jsdai.ida_step.installation.RegistrationUtils;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.services.LicensedFeatureData;
import net.jsdai.repo_edit.services.LicensingService;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegistrationStatus {
    private static final String SHOW_REGISTRATION_WARNINGS_PREFERENCE = "net.jsdai.ida_step.registration_page.show_registration_warnings";
    private LicenseStatus licenseStatus = LicenseStatus.UNKNOWN;
    private boolean showRegistrationDialog;
    private boolean showRegistrationWarnings;
    private boolean newsPossible;

    public void updateStatus() throws IOException, GeneralSecurityException {
        LicensingService licensingService = LicensingService.getInstance();
        LicenseProperties licenseProperties = LicenseProperties.load();
        Collection licensedFeatures = licensingService.loadLicensedFeatures();
        boolean someFeaturesExpired = false;
        boolean someFeaturesWillExpire = false;
        Calendar currentCalendar = Calendar.getInstance();
        Calendar willExpireCalendar = Calendar.getInstance();
        Date issuedAtDateProp = licenseProperties.getIssuedAtDate();
        long issuedAtDate = issuedAtDateProp != null ? issuedAtDateProp.getTime() : 0L;
        for (LicensedFeatureData licensedFeatureData : licensedFeatures) {
            Date featureExpireDate;
            if (licensedFeatureData.isExpired()) {
                someFeaturesExpired = true;
            }
            if ((featureExpireDate = licensedFeatureData.getExpireDate()) == null) continue;
            long warnDays = (featureExpireDate.getTime() - issuedAtDate) / 86400000L / 2L;
            if (warnDays <= 0L || warnDays > 30L) {
                warnDays = 30L;
            }
            willExpireCalendar.setTime(featureExpireDate);
            willExpireCalendar.add(5, (int)(-warnDays));
            if (someFeaturesWillExpire || willExpireCalendar.compareTo(currentCalendar) > 0) continue;
            someFeaturesWillExpire = true;
        }
        String release = licenseProperties.getRelease();
        if (release != null) {
            System.setProperty("ida-step.license.release", release);
        }
        Properties licenseInfo = licensingService.getLicenseeInfoBytes("", "").getInfoProperties();
        String licenseProp = licenseProperties.getHdd0();
        String licenseInfoProp = licenseInfo.getProperty("hdd0");
        if (licenseProp != null && licenseInfoProp != null && !licenseProp.equals(licenseInfoProp)) {
            this.licenseStatus = LicenseStatus.INVALID;
        } else {
            licenseProp = licenseProperties.getVolumeIds();
            licenseInfoProp = licenseInfo.getProperty("volume-ids");
            if (licenseProp != null && licenseInfoProp != null && !licenseProp.equals(licenseInfoProp)) {
                this.licenseStatus = LicenseStatus.INVALID;
            }
            this.licenseStatus = licenseProperties.isEmpty() ? LicenseStatus.MISSING : (licensedFeatures.isEmpty() ? LicenseStatus.NO_FEATURES : (someFeaturesExpired ? LicenseStatus.EXPIRED : (!RegistrationStatus.areAllFeaturesInstalled(licensedFeatures) ? LicenseStatus.SOME_FEATURES_MISSING : (someFeaturesWillExpire ? LicenseStatus.WILL_EXPIRE : LicenseStatus.OK))));
        }
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        prefs.setDefault(SHOW_REGISTRATION_WARNINGS_PREFERENCE, true);
        this.showRegistrationWarnings = prefs.getBoolean(SHOW_REGISTRATION_WARNINGS_PREFERENCE);
        this.showRegistrationDialog = this.licenseStatus != LicenseStatus.OK && this.showRegistrationWarnings;
        this.newsPossible = licenseProperties.isNewsPossible();
    }

    private static boolean areAllFeaturesInstalled(Collection<LicensedFeatureData> licensedFeaturesData) {
        Map<String, IBundleGroup> installedFeatures = RegistrationUtils.getInstalledFeatures();
        for (LicensedFeatureData data : licensedFeaturesData) {
            if (installedFeatures.containsKey(data.getFeatureId())) continue;
            return false;
        }
        return true;
    }

    public LicenseStatus getLicenseStatus() {
        return this.licenseStatus;
    }

    public boolean isLicenseValid() {
        return this.licenseStatus == LicenseStatus.OK || this.licenseStatus == LicenseStatus.WILL_EXPIRE;
    }

    public boolean isShowRegistrationDialog() {
        return this.showRegistrationDialog;
    }

    public boolean isShowRegistrationWarnings() {
        return this.showRegistrationWarnings;
    }

    public void setShowRegistrationWarnings(boolean showRegistrationWarnings) {
        this.showRegistrationWarnings = showRegistrationWarnings;
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        prefs.setValue(SHOW_REGISTRATION_WARNINGS_PREFERENCE, showRegistrationWarnings);
    }

    public boolean isNewsPossible() {
        return this.newsPossible;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LicenseStatus {
        UNKNOWN(IdaStepMessages.RegistrationStatus_LicenseStatus_UNKNOWN),
        OK(IdaStepMessages.RegistrationStatus_LicenseStatus_OK),
        MISSING(IdaStepMessages.RegistrationStatus_LicenseStatus_Missing),
        NO_FEATURES(IdaStepMessages.RegistrationStatus_LicenseStatus_NO_FEATURES),
        INVALID(IdaStepMessages.RegistrationStatus_LicenseStatus_Invalid),
        EXPIRED(IdaStepMessages.RegistrationStatus_LicenseStatus_Expired),
        WILL_EXPIRE(IdaStepMessages.RegistrationStatus_LicenseStatus_WillExpire),
        SOME_FEATURES_MISSING(IdaStepMessages.RegistrationStatus_LicenseStatus_SOME_FEATURES_MISSING);

        private final String message;

        private LicenseStatus(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

