/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.repo_edit.jface.viewers.CellSelectionPainter;
import net.jsdai.repo_edit.jface.viewers.ICellBoundsCalculator;
import net.jsdai.repo_edit.jface.viewers.ICellSelectionManager;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;

class CellSelectionPainterDefault
implements Listener {
    private ICellSelectionManager selectionProvider;
    private Listener paintListener;
    private ICellBoundsCalculator boundsCalculator;

    CellSelectionPainterDefault(ICellSelectionManager selectionProvider, ICellBoundsCalculator boundsCalculator, Listener paintListener) {
        if (selectionProvider == null || paintListener == null || boundsCalculator == null) {
            throw new IllegalArgumentException();
        }
        this.selectionProvider = selectionProvider;
        this.paintListener = paintListener;
        this.boundsCalculator = boundsCalculator;
    }

    public void handleEvent(Event event) {
        GC gc = event.gc;
        Item widget = (Item)event.item;
        int column = event.index;
        Rectangle rect = this.boundsCalculator.calculateBounds(event);
        if (event.type == 40) {
            CellSelectionPainter.Style.NORMAL.applay(gc);
            CellSelectionPainter.paintBackground(gc, gc.getClipping(), false);
            this.paintListener.handleEvent(event);
            event.detail &= 0xFFFFFFFD;
        } else if (event.type == 42) {
            if (this.selectionProvider.isSelected(widget)) {
                CellSelectionPainter.Style style = this.selectionProvider.getCellStyle(widget, column);
                style.applay(gc);
                CellSelectionPainter.paintBackground(gc, rect, false);
            }
            this.paintListener.handleEvent(event);
            if (this.selectionProvider.isFocused(widget, column)) {
                gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

