/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.repo_edit.jface.viewers.CellSelectionPainterDefault;
import net.jsdai.repo_edit.jface.viewers.CellSelectionPainterGtk;
import net.jsdai.repo_edit.jface.viewers.ICellBoundsCalculator;
import net.jsdai.repo_edit.jface.viewers.ICellSelectionManager;
import net.jsdai.repo_edit.jface.viewers.TableTextEllipsis;
import net.jsdai.repo_edit.jface.viewers.TreeTextEllipsis;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class CustomDrawingFactory {
    private static CustomDrawingFactory factory = null;

    private CustomDrawingFactory() {
    }

    public static CustomDrawingFactory getInstance() {
        if (factory == null) {
            factory = new CustomDrawingFactory();
        }
        return factory;
    }

    public Listener getTableSelectionPainter(ICellSelectionManager manager, Listener foregroundPainter) {
        String platform = SWT.getPlatform();
        if ("gtk".equals(platform)) {
            CellSelectionPainterGtk painter = new CellSelectionPainterGtk(manager, new TableCellBoundsCalculatorGtk(), foregroundPainter);
            return painter;
        }
        CellSelectionPainterDefault painter = new CellSelectionPainterDefault(manager, new TableCellBoundsCalculator(), foregroundPainter);
        return painter;
    }

    public Listener getTreeSelectionPainter(ICellSelectionManager manager, Listener foregroundPainter) {
        String platform = SWT.getPlatform();
        if ("gtk".equals(platform)) {
            CellSelectionPainterGtk painter = new CellSelectionPainterGtk(manager, new TreeCellBoundsCalculatorGtk(), foregroundPainter);
            return painter;
        }
        CellSelectionPainterDefault painter = new CellSelectionPainterDefault(manager, new TreeCellBoundsCalculator(), foregroundPainter);
        return painter;
    }

    public Listener getTableForegroundPainter() {
        ICellBoundsCalculator boundsCalaculator = null;
        String platform = SWT.getPlatform();
        boundsCalaculator = "gtk".equals(platform) ? new TableCellBoundsCalculatorGtk() : new TableCellBoundsCalculator();
        return new TableTextEllipsis(boundsCalaculator);
    }

    public Listener getTreeForegroundPainter() {
        ICellBoundsCalculator boundsCalaculator = null;
        String platform = SWT.getPlatform();
        boundsCalaculator = "gtk".equals(platform) ? new TreeCellBoundsCalculatorGtk() : new TreeCellBoundsCalculator();
        return new TreeTextEllipsis(boundsCalaculator);
    }

    class TableCellBoundsCalculator
    implements ICellBoundsCalculator {
        TableCellBoundsCalculator() {
        }

        public Rectangle calculateBounds(Event event) {
            int column = event.index;
            TableItem tableItem = (TableItem)event.item;
            Rectangle rect = tableItem.getBounds(column);
            if (column == 0) {
                --rect.x;
                ++rect.width;
            }
            return rect;
        }
    }

    class TableCellBoundsCalculatorGtk
    implements ICellBoundsCalculator {
        TableCellBoundsCalculatorGtk() {
        }

        public Rectangle calculateBounds(Event event) {
            int column = event.index;
            TableItem tableItem = (TableItem)event.item;
            Rectangle rect = tableItem.getBounds(column);
            --rect.x;
            ++rect.width;
            return rect;
        }
    }

    class TreeCellBoundsCalculator
    implements ICellBoundsCalculator {
        TreeCellBoundsCalculator() {
        }

        public Rectangle calculateBounds(Event event) {
            int column = event.index;
            TreeItem treeItem = (TreeItem)event.item;
            Rectangle rect = treeItem.getBounds(column);
            return rect;
        }
    }

    class TreeCellBoundsCalculatorGtk
    implements ICellBoundsCalculator {
        TreeCellBoundsCalculatorGtk() {
        }

        public Rectangle calculateBounds(Event event) {
            int column = event.index;
            TreeItem treeItem = (TreeItem)event.item;
            Rectangle rect = treeItem.getBounds(column);
            --rect.x;
            rect.width = column == 0 ? --rect.width : ++rect.width;
            return rect;
        }
    }
}

