/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.part;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import net.jsdai.l10n.CommonStringsMessages;
import net.jsdai.l10n.RepoEditBaseMessages;
import net.jsdai.repo_edit.part.AbstractInputField;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class DirectoryInputField
extends AbstractInputField {
    private final Collection<IDirectoryInputFieldListener> listeners = new ArrayList<IDirectoryInputFieldListener>();

    public DirectoryInputField(String text, int dialogStyle) {
        super(text, dialogStyle, RepoEditBaseMessages.DirectoryInputField_Directory);
    }

    public DirectoryInputField(String text, int dialogStyle, String label) {
        super(text, dialogStyle, label);
    }

    public String getDirectory() {
        return super.getInputValue();
    }

    public void setDirectory(String text) {
        super.setInputValue(text);
    }

    protected Control createButton(final Composite fileBrowseComposite) {
        Button browseButton = new Button(fileBrowseComposite, 8);
        browseButton.setText(String.format("%s...", CommonStringsMessages.browse));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(fileBrowseComposite.getParent().getShell(), DirectoryInputField.this.dialogStyle);
                dialog.setText(DirectoryInputField.this.text);
                dialog.setFilterPath(DirectoryInputField.this.getInputValue());
                String inputValue = DirectoryInputField.this.getInputValue();
                if (inputValue.length() == 0 && DirectoryInputField.this.getInitialBrowseFolder() != null) {
                    dialog.setFilterPath(DirectoryInputField.this.getInitialBrowseFolder());
                } else {
                    dialog.setText(inputValue);
                }
                String exportFileName = dialog.open();
                if (exportFileName != null) {
                    DirectoryInputField.this.inputText.setText(exportFileName);
                }
            }
        });
        return browseButton;
    }

    public String getFullDirectoryPath() {
        String dirPath = this.getDirectory();
        File file = new File(dirPath);
        if (!file.exists() || !file.isDirectory()) {
            MessageDialog.openError((Shell)this.inputText.getShell(), (String)RepoEditBaseMessages.DirectoryInputField_SuchDirDNExists, (String)(String.valueOf(file.getAbsolutePath()) + RepoEditBaseMessages.DirectoryInputField_DoNotExists));
            return null;
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IDirectoryInputFieldListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Collection<IDirectoryInputFieldListener> collection = this.listeners;
        synchronized (collection) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IDirectoryInputFieldListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Collection<IDirectoryInputFieldListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    protected void fireValueChanged() {
        for (IDirectoryInputFieldListener l : this.listeners) {
            l.valueChanged(this);
        }
    }

    public static interface IDirectoryInputFieldListener {
        public void valueChanged(DirectoryInputField var1);
    }
}

