/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public final class CryptRSA {
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    public static final String VERSION_FORMAT_PATTERN = "[0-9*]{1}(.[0-9*]){0,}?";
    public static final String TRANSFORMATION = "RSA/ECB/PKCS1Padding";
    public static final String DS_FILE_DIR = ".lksoft";
    private Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");

    private CryptRSA() throws NoSuchAlgorithmException, NoSuchPaddingException {
    }

    public static CryptRSA getInstance() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return new CryptRSA();
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public void encodeRSA(InputStream inSource, OutputStream outTarget, byte[] keyData, boolean isKeyPrivate) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CryptRSA.copyInputToOutput(inSource, out);
        byte[] plainText = out.toByteArray();
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Key key = null;
        try {
            EncodedKeySpec keySpec;
            if (isKeyPrivate) {
                keySpec = new PKCS8EncodedKeySpec(keyData);
                key = keyFactory.generatePrivate(keySpec);
            } else {
                keySpec = new X509EncodedKeySpec(keyData);
                key = keyFactory.generatePublic(keySpec);
            }
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        Cipher cp = null;
        cp = this.getCipher();
        byte[] cipherText = null;
        int blockSize = 64;
        try {
            ByteArrayOutputStream encOut = new ByteArrayOutputStream();
            int i = 0;
            while (i < plainText.length) {
                cp.init(1, key);
                int currentBlockSize = Math.min(blockSize, plainText.length - i);
                cipherText = cp.doFinal(plainText, i, currentBlockSize);
                int currentBlockSizeToStore = cipherText.length & 0xFFFF;
                byte blk1 = (byte)(currentBlockSizeToStore >> 8);
                byte blk2 = (byte)(currentBlockSizeToStore & 0xFF);
                encOut.write(blk1);
                encOut.write(blk2);
                encOut.write(cipherText);
                i += blockSize;
            }
            outTarget.write(encOut.toByteArray());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public void decodeRSA(InputStream inSource, OutputStream outTarget, byte[] keyData, boolean isKeyPrivate) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CryptRSA.copyInputToOutput(inSource, out);
        byte[] cipherText = out.toByteArray();
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Key key = null;
        try {
            EncodedKeySpec keySpec;
            if (isKeyPrivate) {
                keySpec = new PKCS8EncodedKeySpec(keyData);
                key = keyFactory.generatePrivate(keySpec);
            } else {
                keySpec = new X509EncodedKeySpec(keyData);
                key = keyFactory.generatePublic(keySpec);
            }
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        Cipher cp = null;
        cp = this.getCipher();
        byte[] plainText = null;
        ByteArrayOutputStream decOut = new ByteArrayOutputStream();
        try {
            cp.init(2, key);
            int i = 0;
            int blk1 = 0;
            byte blk2 = 0;
            while (i < cipherText.length) {
                if (i < cipherText.length) {
                    blk1 = cipherText[i++];
                    if (i < cipherText.length) {
                        blk2 = cipherText[i++];
                        int blockSize = blk1;
                        blockSize <<= 8;
                        blockSize |= blk2;
                        if (i + (blockSize = Math.abs(blockSize)) <= cipherText.length) {
                            plainText = cp.doFinal(cipherText, i, blockSize);
                            decOut.write(plainText);
                            i += blockSize;
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        outTarget.write(decOut.toByteArray());
    }

    public static void copyInputToOutput(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            out.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }
}

