/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.services;

import net.jsdai.repo_edit.services.IDrawable;
import net.jsdai.repo_edit.services.IPrintService;
import net.jsdai.repo_edit.services.IPrintable;
import net.jsdai.repo_edit.services.WeightedObjectsRegistryService;
import org.eclipse.swt.widgets.Control;

public class PrintService
implements IPrintService {
    private static final PrintService INSTANCE = new PrintService();
    private final IPrintService delegate = (IPrintService)WeightedObjectsRegistryService.getInstance().getObject("net.jsdai.print");

    public static PrintService getInstance() {
        return INSTANCE;
    }

    private PrintService() {
    }

    public void print(Control control, boolean preview) {
        if (this.delegate != null) {
            this.delegate.print(control, preview);
        }
    }

    public void print(IDrawable drawable, boolean preview) {
        if (this.delegate != null) {
            this.delegate.print(drawable, preview);
        }
    }

    public boolean canPrint() {
        return this.delegate != null;
    }

    public void print(IPrintable[] printables, boolean preview) {
        if (this.delegate != null) {
            this.delegate.print(printables, preview);
        }
    }
}

