/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.services;

import java.util.ArrayList;
import java.util.Collection;
import net.jsdai.repo_edit.internal.util.Utils;
import net.jsdai.repo_edit.part.IViewDecorator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewDecoratorsRegistryService {
    private ViewDecoratorsRegistryService() {
    }

    public static Collection<ViewDecoratorInfo> getViewDecorators(String viewId) {
        IConfigurationElement[] viewDecoratorElems;
        if (viewId == null) {
            throw new NullPointerException();
        }
        ArrayList<ViewDecoratorInfo> res = new ArrayList<ViewDecoratorInfo>();
        IConfigurationElement[] iConfigurationElementArray = viewDecoratorElems = Platform.getExtensionRegistry().getConfigurationElementsFor("net.jsdai.repo_edit", "viewDecorators");
        int n = viewDecoratorElems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (configElement.getName().equals("viewDecorator")) {
                try {
                    ViewDecoratorInfo info = new ViewDecoratorInfo(configElement);
                    if (info.getViewId().equals(viewId)) {
                        res.add(info);
                    }
                }
                catch (InvalidRegistryObjectException e) {
                    Utils.logWarning("View Decorator (id=" + configElement.getAttribute("id") + ") could not be instantiated.", e);
                }
            }
            ++n2;
        }
        return res;
    }

    public static class ViewDecoratorInfo {
        private final IConfigurationElement configElement;
        private final String id;
        private final String viewId;

        ViewDecoratorInfo(IConfigurationElement configElem) {
            this.configElement = configElem;
            this.id = this.configElement.getAttribute("id");
            this.viewId = this.configElement.getAttribute("viewId");
        }

        public String getId() {
            return this.id;
        }

        public String getViewId() {
            return this.viewId;
        }

        public IViewDecorator getViewDecorator() {
            IViewDecorator obj = null;
            try {
                obj = (IViewDecorator)this.configElement.createExecutableExtension("class");
            }
            catch (ClassCastException e) {
                Utils.logWarning("View Decorator (id=" + this.id + ") could not be instantiated.", e);
            }
            catch (CoreException e) {
                Utils.logWarning("View Decorator (id=" + this.id + ") could not be instantiated.", e);
            }
            return obj;
        }
    }
}

