/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.util;

import java.util.ArrayList;
import java.util.Collection;
import net.jsdai.repo_edit.util.XmlExternalizable;
import net.jsdai.repo_edit.util.XmlExternalizableAdapter;
import net.jsdai.repo_edit.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayXmlExternalizer
implements XmlExternalizableAdapter {
    private static final String TAG_NAME = "array";
    private static final String VERSION_ATTR = "version";
    private static final int VERSION_ID = 1;
    private final XmlExternalizable[] array;

    public ArrayXmlExternalizer(XmlExternalizable[] array) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        this.array = (XmlExternalizable[])array.clone();
        ArrayXmlExternalizer.assertNoNulls(this.array);
    }

    public ArrayXmlExternalizer(Collection<? extends XmlExternalizable> collection) {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        this.array = collection.toArray(new XmlExternalizable[collection.size()]);
        ArrayXmlExternalizer.assertNoNulls(this.array);
    }

    private static void assertNoNulls(Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
    }

    public XmlExternalizable[] getAdaptedObject() {
        return this.array;
    }

    @Override
    public Element externalize(Document doc) {
        Element element = doc.createElement(TAG_NAME);
        element.setAttribute(VERSION_ATTR, String.valueOf(1));
        XmlExternalizable[] xmlExternalizableArray = this.array;
        int n = this.array.length;
        int n2 = 0;
        while (n2 < n) {
            XmlExternalizable object = xmlExternalizableArray[n2];
            element.appendChild(XmlUtils.encode(doc, object));
            ++n2;
        }
        return element;
    }

    public static ArrayXmlExternalizer valueOf(Element elem, ClassLoader classLoader) {
        if (elem == null) {
            throw new IllegalArgumentException();
        }
        if (!elem.getTagName().equals(TAG_NAME)) {
            throw new IllegalArgumentException();
        }
        ArrayList<XmlExternalizable> objects = new ArrayList<XmlExternalizable>();
        NodeList childNodes = elem.getChildNodes();
        int i = 0;
        int n = childNodes.getLength();
        while (i < n) {
            Object object;
            Node child = childNodes.item(i);
            if (child instanceof Element && (object = XmlUtils.decode((Element)child, classLoader)) instanceof XmlExternalizable) {
                objects.add((XmlExternalizable)object);
            }
            ++i;
        }
        return new ArrayXmlExternalizer(objects);
    }
}

