/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.jsdai.repo_edit.internal.util.Utils;
import net.jsdai.repo_edit.util.XmlExternalizable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static String TAG_NAME = "external";
    private static String CLASS_ATTR_NAME = "class";
    private static String VERSION_ATTR_NAME = "version";
    private static int VERSION_ID = 1;

    private XmlUtils() {
    }

    public static Element encode(Document doc, XmlExternalizable externalizable) {
        if (externalizable == null) {
            throw new NullPointerException();
        }
        Element elem = doc.createElement(TAG_NAME);
        elem.setAttribute(VERSION_ATTR_NAME, String.valueOf(VERSION_ID));
        elem.setAttribute(CLASS_ATTR_NAME, externalizable.getClass().getName());
        Element childElem = externalizable.externalize(doc);
        elem.appendChild(childElem);
        return elem;
    }

    public static Object decode(Element elem, ClassLoader classLoader) {
        if (elem == null) {
            throw new NullPointerException();
        }
        if (!elem.getTagName().equals(TAG_NAME)) {
            return null;
        }
        try {
            String className = elem.getAttribute(CLASS_ATTR_NAME);
            Class<?> clazz = Class.forName(className, true, classLoader);
            boolean withClassLoader = true;
            Method method = null;
            try {
                method = clazz.getMethod("valueOf", Element.class, ClassLoader.class);
            }
            catch (NoSuchMethodException ex) {
                method = clazz.getMethod("valueOf", Element.class);
                withClassLoader = false;
            }
            NodeList childNodes = elem.getChildNodes();
            int i = 0;
            int n = childNodes.getLength();
            while (i < n) {
                Node child = childNodes.item(i);
                if (child instanceof Element) {
                    if (withClassLoader) {
                        return method.invoke(null, child, classLoader);
                    }
                    return method.invoke(null, child);
                }
                ++i;
            }
            return null;
        }
        catch (Exception e) {
            Utils.logError("Failed to decode", e);
            return null;
        }
    }

    public static String encode(XmlExternalizable elem) {
        String value;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            doc.appendChild(XmlUtils.encode(doc, elem));
            value = XmlUtils.toString(doc);
            if (value == null) {
                return null;
            }
        }
        catch (ParserConfigurationException e) {
            Utils.logError("Failed to encode", e);
            return null;
        }
        return value;
    }

    public static Object decode(String value, ClassLoader classLoader) {
        Document doc = XmlUtils.parse(value);
        if (doc == null) {
            return null;
        }
        return XmlUtils.decode(doc.getDocumentElement(), classLoader);
    }

    public static String toString(Node node) {
        String value;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            value = writer.toString();
        }
        catch (TransformerConfigurationException e) {
            Utils.logError("", e);
            return null;
        }
        catch (TransformerFactoryConfigurationError e) {
            Utils.logError("", e);
            return null;
        }
        catch (TransformerException e) {
            Utils.logError("", e);
            return null;
        }
        return value;
    }

    public static Document parse(String value) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(value)));
        }
        catch (SAXException e) {
            Utils.logError("", e);
            return null;
        }
        catch (IOException e) {
            Utils.logError("", e);
            return null;
        }
        catch (ParserConfigurationException e) {
            Utils.logError("", e);
            return null;
        }
    }
}

