/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.FeatureReferenceAdapter;
import org.eclipse.update.internal.ui.model.IFeatureAdapter;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.model.UIModelObject;

public class SiteCategory
extends UIModelObject {
    Vector children;
    private ICategory category;
    private String name;
    private boolean touched;
    private int featureCount;
    private boolean canceled;
    private SiteBookmark bookmark;

    public SiteCategory(SiteBookmark bookmark, String name, ICategory category) {
        this.bookmark = bookmark;
        if (category == null) {
            this.name = Messages.SiteCategory_other_label;
            this.category = new OtherCategory();
        } else {
            this.name = name;
            this.category = category;
        }
        this.children = new Vector();
    }

    public SiteBookmark getBookmark() {
        return this.bookmark;
    }

    public boolean isOtherCategory() {
        return this.category instanceof OtherCategory;
    }

    public Object[] getChildren() {
        return this.canceled ? new Object[]{} : this.children.toArray();
    }

    public int getChildCount() {
        return this.canceled ? 0 : this.children.size();
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.category.getName();
    }

    public String toString() {
        return this.category.getLabel();
    }

    public ICategory getCategory() {
        return this.category;
    }

    void add(Object child) {
        if (child instanceof IFeatureAdapter) {
            ++this.featureCount;
        }
        this.children.add(child);
    }

    public void touchFeatures(IRunnableContext context) {
        if (this.children.size() == 0 || this.touched || this.featureCount == 0) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(UpdateUIMessages.SiteBookmark_downloading, SiteCategory.this.featureCount);
                int i = 0;
                while (i < SiteCategory.this.children.size()) {
                    Object child = SiteCategory.this.children.get(i);
                    if (monitor.isCanceled()) break;
                    if (child instanceof IFeatureAdapter) {
                        IFeatureAdapter adapter = (IFeatureAdapter)child;
                        monitor.subTask(adapter.getFastLabel());
                        try {
                            adapter.getFeature((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                monitor.done();
            }
        };
        try {
            context.run(true, true, op);
            this.touched = true;
        }
        catch (InterruptedException e) {
            this.canceled = true;
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void addFeaturesTo(Vector flatList) {
        int i = 0;
        while (i < this.children.size()) {
            Object child = this.children.get(i);
            if (child instanceof FeatureReferenceAdapter) {
                FeatureReferenceAdapter cfeature = (FeatureReferenceAdapter)child;
                if (this.findFeature(flatList, cfeature.getFeatureReference()) == null) {
                    flatList.add(child);
                }
            } else if (child instanceof SiteCategory) {
                ((SiteCategory)((Object)child)).addFeaturesTo(flatList);
            }
            ++i;
        }
    }

    private FeatureReferenceAdapter findFeature(Vector flatList, IFeatureReference featureRef) {
        int i = 0;
        while (i < flatList.size()) {
            FeatureReferenceAdapter cfeature = (FeatureReferenceAdapter)flatList.get(i);
            if (cfeature.getFeatureReference().equals(featureRef)) {
                return cfeature;
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SiteCategory)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.getName().equals(((SiteCategory)((Object)object)).getName()) && this.bookmark.equals(((SiteCategory)((Object)object)).getBookmark());
    }

    public int hashCode() {
        return this.getName().hashCode() * (this.bookmark == null ? 1 : this.bookmark.hashCode());
    }

    class OtherCategory
    implements ICategory {
        IURLEntry entry = new IURLEntry(this){
            final /* synthetic */ OtherCategory this$1;
            {
                this.this$1 = otherCategory;
            }

            public String getAnnotation() {
                return Messages.SiteCategory_other_description;
            }

            public URL getURL() {
                return null;
            }

            public Object getAdapter(Class clazz) {
                return null;
            }

            public int getType() {
                return 0;
            }
        };

        public String getName() {
            return SiteCategory.this.getName();
        }

        public String getLabel() {
            return SiteCategory.this.getName();
        }

        public IURLEntry getDescription() {
            return this.entry;
        }

        public Object getAdapter(Class clazz) {
            return null;
        }
    }
}

