/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.ui.RestartDialog;
import org.eclipse.update.internal.ui.URLCoder;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UpdateUI
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.update.ui";
    public static final String WEB_APP_ID = "org.eclipse.update";
    public static final String P_DISCOVERY_SITES_ENABLED = "discoverySitesEnabled";
    private static UpdateUI plugin;
    private UpdateModel model;
    private String appServerHost;
    private int appServerPort;
    private UpdateLabelProvider labelProvider;

    public UpdateUI() {
        plugin = this;
    }

    public static UpdateUI getDefault() {
        return plugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = UpdateUI.getActiveWorkbenchWindow();
        return window != null ? window.getShell() : UpdateUI.getStandardDisplay().getActiveShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UpdateUI.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static String getPluginId() {
        return UpdateUI.getDefault().getBundle().getSymbolicName();
    }

    public UpdateLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new UpdateLabelProvider();
        }
        return this.labelProvider;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.model = new UpdateModel();
        int historyPref = this.getPluginPreferences().getInt("org.eclipse.update.core.historySize");
        if (historyPref > 0) {
            UpdateCore.DEFAULT_HISTORY = historyPref;
        }
    }

    public String getAppServerHost() {
        return this.appServerHost;
    }

    public int getAppServerPort() {
        return this.appServerPort;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.model != null) {
            this.model.shutdown();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        super.stop(context);
    }

    public UpdateModel getUpdateModel() {
        return this.model;
    }

    public static void logException(Throwable e) {
        UpdateUI.logException(e, true);
    }

    public static void logException(Throwable e, boolean showErrorDialog) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, UpdateUI.getPluginId(), 0, message, e);
        }
        UpdateUI.log(status, showErrorDialog);
    }

    public static void log(IStatus status, boolean showErrorDialog) {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        Platform.getLog((Bundle)bundle).log(status);
        if (Display.getCurrent() == null || !showErrorDialog) {
            return;
        }
        if (status.getSeverity() != 1) {
            ErrorDialog.openError((Shell)UpdateUI.getActiveWorkbenchShell(), null, null, (IStatus)status);
        } else {
            MessageDialog.openInformation((Shell)UpdateUI.getActiveWorkbenchShell(), null, (String)status.getMessage());
        }
    }

    public static URL getOriginatingURL(String id) {
        IDialogSettings section = UpdateUI.getOriginatingURLSection();
        String value = section.get(id);
        if (value != null) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setOriginatingURL(String id, URL url) {
        IDialogSettings section = UpdateUI.getOriginatingURLSection();
        section.put(id, url.toString());
    }

    private static IDialogSettings getOriginatingURLSection() {
        IDialogSettings settings = UpdateUI.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection("originatingURLs");
        if (section == null) {
            section = settings.addNewSection("originatingURLs");
        }
        return section;
    }

    public static boolean requestRestart(boolean restartIsReallyNeeded) {
        boolean restart = RestartDialog.openQuestion(UpdateUI.getActiveWorkbenchShell(), restartIsReallyNeeded);
        if (restart) {
            return PlatformUI.getWorkbench().restart();
        }
        return false;
    }

    public static void showURL(String url) {
        UpdateUI.showURL(url, false);
    }

    public static void showURL(String url, boolean encodeHostAndPort) {
        if (encodeHostAndPort) {
            url = UpdateUI.encodeHostAndPort(url);
        }
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = support.getExternalBrowser();
            browser.openURL(new URL(url));
        }
        catch (MalformedURLException e) {
            UpdateUI.logException(e);
        }
        catch (PartInitException e) {
            UpdateUI.logException(e);
        }
    }

    private static String encodeHostAndPort(String urlName) {
        String callbackURL = UpdateUI.getCallbackURLAsString();
        if (callbackURL == null) {
            return urlName;
        }
        String callbackParameter = "updateURL=" + callbackURL;
        if (urlName.indexOf(63) != -1) {
            return String.valueOf(urlName) + "&" + callbackParameter;
        }
        return String.valueOf(urlName) + "?" + callbackParameter;
    }

    private static String getCallbackURLAsString() {
        String host = UpdateUI.getDefault().getAppServerHost();
        int port = UpdateUI.getDefault().getAppServerPort();
        if (host == null || port == 0) {
            return null;
        }
        String value = "http://" + host + ":" + port + "/" + WEB_APP_ID + "/install";
        try {
            value = URLCoder.encode(value);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return value;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected void initializeDefaultPluginPreferences() {
        Preferences store = this.getPluginPreferences();
        store.setDefault(P_DISCOVERY_SITES_ENABLED, true);
    }
}

