/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;

public class MainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text historySizeText;
    private Button checkSignatureCheckbox;
    private Button automaticallyChooseMirrorCheckbox;
    private Button equivalentButton;
    private Button compatibleButton;
    private Text updatePolicyText;
    public static final String EQUIVALENT_VALUE = "equivalent";
    public static final String COMPATIBLE_VALUE = "compatible";

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.update.ui.MainPreferencePage");
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        mainComposite.setLayout((Layout)layout);
        Label historySizeLabel = new Label(mainComposite, 0);
        historySizeLabel.setText(UpdateUIMessages.MainPreferencePage_historySize);
        this.historySizeText = new Text(mainComposite, 2052);
        this.historySizeText.setLayoutData((Object)new GridData(768));
        this.historySizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainPreferencePage.this.historySizeChanged();
            }
        });
        this.checkSignatureCheckbox = new Button(mainComposite, 16416);
        this.checkSignatureCheckbox.setText(UpdateUIMessages.MainPreferencePage_checkSignature);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.checkSignatureCheckbox.setLayoutData((Object)gd);
        this.checkSignatureCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MainPreferencePage.this.checkSignatureCheckbox.getSelection()) {
                    MainPreferencePage.this.warnSignatureCheck(MainPreferencePage.this.getShell());
                }
            }
        });
        this.automaticallyChooseMirrorCheckbox = new Button(mainComposite, 16416);
        this.automaticallyChooseMirrorCheckbox.setText(UpdateUIMessages.MainPreferencePage_automaticallyChooseMirror);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.automaticallyChooseMirrorCheckbox.setLayoutData((Object)gd);
        this.createSpacer(mainComposite, 2);
        Group group = new Group(mainComposite, 0);
        group.setText(UpdateUIMessages.MainPreferencePage_updateVersions);
        group.setLayout((Layout)new GridLayout());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        this.equivalentButton = new Button((Composite)group, 16);
        this.equivalentButton.setText(UpdateUIMessages.MainPreferencePage_updateVersions_equivalent);
        this.compatibleButton = new Button((Composite)group, 16);
        this.compatibleButton.setText(UpdateUIMessages.MainPreferencePage_updateVersions_compatible);
        this.createSpacer(mainComposite, 2);
        group = new Group(mainComposite, 0);
        group.setText(UpdateUIMessages.MainPreferencePage_updatePolicy);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Label label = new Label((Composite)group, 0);
        label.setText(UpdateUIMessages.MainPreferencePage_updatePolicyURL);
        this.updatePolicyText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.updatePolicyText.setLayoutData((Object)gd);
        this.initialize();
        this.updatePolicyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainPreferencePage.this.textChanged();
            }
        });
        return mainComposite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Dialog.applyDialogFont((Control)this.getControl());
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    protected void createHttpProxy(Composite composite, int columnSpan) {
        Group group = new Group(composite, 0);
        group.setText(UpdateUIMessages.MainPreferencePage_proxyGroup);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = columnSpan;
        group.setLayoutData((Object)gd);
    }

    private int getHistoryCount() {
        try {
            Integer count = new Integer(this.historySizeText.getText());
            return count;
        }
        catch (NumberFormatException numberFormatException) {
            return UpdateCore.getPlugin().getPluginPreferences().getDefaultInt("org.eclipse.update.core.historySize");
        }
    }

    private void historySizeChanged() {
        try {
            int historySize = Integer.parseInt(this.historySizeText.getText());
            if (historySize < 0) {
                this.setValid(false);
                this.setErrorMessage(UpdateUIMessages.MainPreferencePage_invalidHistorySize);
                return;
            }
        }
        catch (NumberFormatException e) {
            this.setValid(false);
            this.setErrorMessage(UpdateUIMessages.MainPreferencePage_invalidHistorySize);
            return;
        }
        this.setValid(true);
        this.setErrorMessage(null);
    }

    public boolean performOk() {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    SiteManager.getLocalSite().setMaximumHistoryCount(MainPreferencePage.this.getHistoryCount());
                }
                catch (CoreException e) {
                    UpdateUI.logException(e);
                }
            }
        });
        Preferences prefs = UpdateCore.getPlugin().getPluginPreferences();
        prefs.setValue("org.eclipse.update.core.checkSignature", this.checkSignatureCheckbox.getSelection());
        prefs.setValue("org.eclipse.update.core.automaticallyChooseMirror", this.automaticallyChooseMirrorCheckbox.getSelection());
        prefs.setValue("org.eclipse.update.core.historySize", this.historySizeText.getText());
        prefs.setValue("org.eclipse.update.core.updateVersions", this.equivalentButton.getSelection() ? EQUIVALENT_VALUE : COMPATIBLE_VALUE);
        prefs.setValue("updatePolicyURL", this.updatePolicyText.getText());
        UpdateCore.getPlugin().savePluginPreferences();
        return super.performOk();
    }

    private void initialize() {
        Preferences prefs = UpdateCore.getPlugin().getPluginPreferences();
        this.checkSignatureCheckbox.setSelection(prefs.getBoolean("org.eclipse.update.core.checkSignature"));
        this.automaticallyChooseMirrorCheckbox.setSelection(prefs.getBoolean("org.eclipse.update.core.automaticallyChooseMirror"));
        this.historySizeText.setText(prefs.getString("org.eclipse.update.core.historySize"));
        boolean isCompatible = COMPATIBLE_VALUE.equals(prefs.getString("org.eclipse.update.core.updateVersions"));
        this.equivalentButton.setSelection(!isCompatible);
        this.compatibleButton.setSelection(isCompatible);
        String text = prefs.getString("updatePolicyURL");
        this.updatePolicyText.setText(text);
    }

    private void textChanged() {
        String text = this.updatePolicyText.getText();
        if (text.length() > 0) {
            try {
                new URL(text);
            }
            catch (MalformedURLException e) {
                this.setValid(false);
                this.setErrorMessage(UpdateUIMessages.UpdateSettingsPreferencePage_invalid);
                return;
            }
        }
        this.setValid(true);
        this.setErrorMessage(null);
    }

    public void performDefaults() {
        super.performDefaults();
        Preferences prefs = UpdateCore.getPlugin().getPluginPreferences();
        this.updatePolicyText.setText("");
        this.checkSignatureCheckbox.setSelection(true);
        this.automaticallyChooseMirrorCheckbox.setSelection(false);
        this.historySizeText.setText(prefs.getDefaultString("org.eclipse.update.core.historySize"));
        this.equivalentButton.setSelection(true);
        this.compatibleButton.setSelection(false);
    }

    private void warnSignatureCheck(Shell shell) {
        MessageDialog.openWarning((Shell)shell, (String)UpdateUIMessages.MainPreferencePage_digitalSignature_title, (String)UpdateUIMessages.MainPreferencePage_digitalSignature_message);
    }
}

