/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.repo_edit.jface.viewers.Cell;
import net.jsdai.repo_edit.jface.viewers.IFocusFeedbackProvider;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

abstract class CellDropAdapter
implements DropTargetListener {
    private static final int HSCROLL_DELAY = 500;
    public static final int LOCATION_BEFORE = 1;
    public static final int LOCATION_AFTER = 2;
    public static final int LOCATION_ON = 3;
    public static final int LOCATION_NONE = 4;
    protected Control control;
    private int currentOperation = 0;
    private int lastValidOperation = 0;
    private Cell currentTarget;
    private int currentLocation;
    private boolean feedbackEnabled = true;
    private boolean scrollExpandEnabled = true;
    private boolean selectFeedbackEnabled = true;
    private IFocusFeedbackProvider cellFocusFeedback;
    private long hFeedbackTimestamp = 0L;

    public CellDropAdapter(Control control, IFocusFeedbackProvider cellFocusFeedback) {
        this.control = control;
        this.cellFocusFeedback = cellFocusFeedback;
    }

    public void dragEnter(DropTargetEvent event) {
        this.currentTarget = this.determineDropTarget(event);
        this.doDropValidation(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.currentTarget = this.determineDropTarget(event);
        this.doDropValidation(event);
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 0;
        Cell target = this.determineDropTarget(event);
        if (target != null) {
            this.setScrollExpandFeedback(event, target);
        }
        int oldLocation = this.currentLocation;
        this.currentLocation = this.determineLocation(event, target);
        this.setLocationFeedback(event, this.currentLocation);
        if (target != null && !target.equals(this.currentTarget) || this.currentLocation != oldLocation) {
            this.currentTarget = target;
            this.setSelectionFeedback(target, this.currentLocation);
            this.doDropValidation(event);
        }
    }

    public void drop(DropTargetEvent event) {
        Cell target = this.determineDropTarget(event);
        this.currentLocation = this.determineLocation(event, target);
        this.cellFocusFeedback.unsetFocus();
        if (!this.performDrop(event)) {
            event.detail = 0;
        }
        this.currentOperation = event.detail;
    }

    public void dragLeave(DropTargetEvent event) {
        this.cellFocusFeedback.unsetFocus();
    }

    public void dropAccept(DropTargetEvent event) {
        if (!this.validateDrop(event)) {
            event.detail = 0;
        }
    }

    public abstract boolean performDrop(DropTargetEvent var1);

    protected abstract boolean validateDrop(DropTargetEvent var1);

    public void setFeedbackEnabled(boolean value) {
        this.feedbackEnabled = value;
    }

    public boolean getFeedbackEnabled() {
        return this.feedbackEnabled;
    }

    public void setSelectionFeedbackEnabled(boolean value) {
        this.selectFeedbackEnabled = value;
    }

    public boolean getSelectionFeedbackEnabled() {
        return this.selectFeedbackEnabled;
    }

    public void setScrollExpandEnabled(boolean value) {
        this.scrollExpandEnabled = value;
        if (!value) {
            this.cellFocusFeedback.unsetFocus();
        }
    }

    public boolean getScrollExpandEnabled() {
        return this.scrollExpandEnabled;
    }

    protected int getCurrentLocation() {
        return this.currentLocation;
    }

    protected void setCurrentOperation(int currentOperation) {
        this.currentOperation = currentOperation;
    }

    protected int getCurrentOperation() {
        return this.currentOperation;
    }

    protected Cell getCurrentTarget() {
        return this.currentTarget;
    }

    protected void setLastValidOperation(int lastValidOperation) {
        this.lastValidOperation = lastValidOperation;
    }

    private void doDropValidation(DropTargetEvent event) {
        if (event.detail != 0) {
            this.lastValidOperation = event.detail;
        }
        this.currentOperation = this.validateDrop(event) ? this.lastValidOperation : 0;
        event.detail = this.currentOperation;
    }

    private void setLocationFeedback(DropTargetEvent event, int location) {
        if (this.feedbackEnabled) {
            switch (location) {
                case 1: {
                    event.feedback |= 2;
                    break;
                }
                case 2: {
                    event.feedback |= 4;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    event.feedback |= 4;
                }
            }
        }
    }

    private void setScrollExpandFeedback(DropTargetEvent event, Cell cell) {
        if (this.scrollExpandEnabled) {
            event.feedback |= 0x18;
            int horizontalLocation = this.determineHorizontalLocation(event, cell);
            int columnIndex = cell.cellIndex;
            int[] order = this.getColumnOrder();
            if (horizontalLocation == 1) {
                columnIndex = order[columnIndex] - 1;
            } else if (horizontalLocation == 2) {
                columnIndex = order[columnIndex] + 1;
            }
            if (columnIndex >= 0 && columnIndex < this.getColumncount() && System.currentTimeMillis() - this.hFeedbackTimestamp > 500L) {
                this.showColumn(columnIndex);
                this.hFeedbackTimestamp = System.currentTimeMillis();
            }
        }
    }

    private void setSelectionFeedback(Cell target, int location) {
        if (this.selectFeedbackEnabled) {
            if (target == null || location != 3) {
                this.cellFocusFeedback.unsetFocus();
            } else {
                this.cellFocusFeedback.setFocusTo(target.item, target.cellIndex);
            }
        }
    }

    protected int determineLocation(DropTargetEvent event, Cell cell) {
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.control.toControl(coordinates);
        if (cell == null) {
            return 4;
        }
        Rectangle bounds = cell.getBounds();
        if (bounds == null) {
            return 4;
        }
        if (cell.cellIndex == 0) {
            if (coordinates.y - bounds.y < 5 && bounds.contains(coordinates.x, bounds.y)) {
                return 1;
            }
            if (bounds.y + bounds.height - coordinates.y < 5 && bounds.contains(coordinates.x, bounds.y)) {
                return 2;
            }
        }
        return 3;
    }

    protected int determineHorizontalLocation(DropTargetEvent event, Cell cell) {
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.control.toControl(coordinates);
        if (cell == null) {
            return 4;
        }
        Rectangle bounds = cell.getBounds();
        if (bounds == null) {
            return 4;
        }
        if (coordinates.x - bounds.x < 15 && bounds.contains(coordinates.x, coordinates.y)) {
            return 1;
        }
        if (bounds.x + bounds.width - coordinates.x < 15 && bounds.contains(coordinates.x, coordinates.y)) {
            return 2;
        }
        return 3;
    }

    abstract Cell determineDropTarget(DropTargetEvent var1);

    abstract void showColumn(int var1);

    abstract int getColumncount();

    abstract int[] getColumnOrder();

    public static boolean contains(Rectangle rectangle, Point point) {
        return point.x >= rectangle.x && point.y >= rectangle.y && point.x - rectangle.x <= rectangle.width && point.y - rectangle.y <= rectangle.height;
    }
}

