/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

class CellSelectionPainter {
    private static final int BACKGROUND = 25;
    private static final int FOREGROUND = 24;
    private static final int INACTIVE_BACKGROUND = 22;
    private static final int INACTIVE_FOREGROUND = 21;
    private static final int SELECTION_BACKGROUND = 26;
    private static final int SELECTION_FOREGROUND = 27;
    private static final int UNFOCUSED_SELECTION_BACKGROUND = 26;
    private static final int UNFOCUSED_SELECTION_FOREGROUND = 27;

    CellSelectionPainter() {
    }

    static void prepareNormalColors(GC gc) {
        Color background = gc.getDevice().getSystemColor(25);
        Color foreground = gc.getDevice().getSystemColor(24);
        gc.setBackground(background);
        gc.setForeground(foreground);
    }

    static void prepareIncactiveColors(GC gc) {
        Color background = gc.getDevice().getSystemColor(22);
        Color foreground = gc.getDevice().getSystemColor(21);
        gc.setBackground(background);
        gc.setForeground(foreground);
    }

    static void prepareSelectionColors(GC gc) {
        Color background = gc.getDevice().getSystemColor(26);
        Color foreground = gc.getDevice().getSystemColor(27);
        gc.setBackground(background);
        gc.setForeground(foreground);
    }

    static void prepareUnfocsedSelectionColors(GC gc) {
        Color background = gc.getDevice().getSystemColor(26);
        Color foreground = gc.getDevice().getSystemColor(27);
        gc.setBackground(background);
        gc.setForeground(foreground);
    }

    static void paintBackground(GC gc, Rectangle rect, boolean drawFocus) {
        gc.fillRectangle(rect);
        if (drawFocus) {
            gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Style {
        NORMAL(25, 24),
        INCATIVE(22, 21),
        SELECTED(26, 27),
        UNFOCUSED_SELECTION(26, 27);

        private final int backgroundColor;
        private final int forregroundColor;

        private Style(int backgroundColor, int forregroundColor) {
            this.backgroundColor = backgroundColor;
            this.forregroundColor = forregroundColor;
        }

        public void applay(GC gc) {
            Color background = gc.getDevice().getSystemColor(this.backgroundColor);
            Color foreground = gc.getDevice().getSystemColor(this.forregroundColor);
            gc.setBackground(background);
            gc.setForeground(foreground);
        }
    }
}

