/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jsdai.repo_edit.jface.viewers.IAutorow;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public abstract class ColumnViewerSorter {
    private final ColumnViewer viewer;
    private Sorter sorter;

    public ColumnViewerSorter(ColumnViewer viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        this.viewer = viewer;
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public abstract void addColumn(int var1);

    protected void setSorterColumn(int index) {
        if (this.sorter == null) {
            this.sorter = new Sorter(index);
            this.viewer.setSorter((ViewerSorter)this.sorter);
        } else {
            this.sorter.setColumn(index);
            this.viewer.refresh();
        }
    }

    protected int getSortDirection() {
        if (this.sorter == null) {
            throw new IllegalStateException();
        }
        return this.sorter.getDirection();
    }

    private String getColumnText(int columnIndex, Object element) {
        CellLabelProvider labelProvider = this.getViewer().getLabelProvider(columnIndex);
        if (labelProvider instanceof ILabelProvider) {
            ILabelProvider colLabelProvider = (ILabelProvider)labelProvider;
            return colLabelProvider.getText(element);
        }
        return null;
    }

    private class Sorter
    extends ViewerSorter {
        private static final int ASCENDING = 1024;
        private static final int DESCENDING = 128;
        private int propertyIndex;
        private int direction;

        public Sorter(int column) {
            this.setColumn(column);
        }

        public int getDirection() {
            return this.direction;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = this.direction == 1024 ? 128 : 1024;
            } else {
                this.propertyIndex = column;
                this.direction = 1024;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (viewer == null) {
                return 0;
            }
            if (this.isAutorow(e1)) {
                if (this.isAutorow(e2)) {
                    return 0;
                }
                return 1;
            }
            if (this.isAutorow(e2)) {
                return -1;
            }
            return this.compareColumn(viewer, e1, e2);
        }

        private boolean isAutorow(Object element) {
            if (element instanceof IAutorow) {
                return true;
            }
            if (element instanceof IAdaptable) {
                return ((IAdaptable)element).getAdapter(IAutorow.class) != null;
            }
            return false;
        }

        private int compareColumn(Viewer viewer, Object e1, Object e2) {
            String text1 = ColumnViewerSorter.this.getColumnText(this.propertyIndex, e1);
            String text2 = ColumnViewerSorter.this.getColumnText(this.propertyIndex, e2);
            if (text1 == null) {
                text1 = "";
            }
            if (text2 == null) {
                text2 = "";
            }
            int i = this.compareText(text1, text2);
            if (this.direction == 128) {
                i = -i;
            }
            return i;
        }

        private int compareText(String text1, String text2) {
            int result = this.getComparator().compare(text1, text2);
            if (result == 0) {
                return result;
            }
            Pattern p = Pattern.compile("\\d+");
            Matcher m1 = p.matcher(text1);
            Matcher m2 = p.matcher(text2);
            while (m1.find()) {
                int digitValue2;
                if (!m2.find()) {
                    return result;
                }
                String beforeDigit1 = text1.substring(0, m1.start());
                String beforeDigit2 = text2.substring(0, m2.start());
                if (this.getComparator().compare(beforeDigit1, beforeDigit2) != 0) {
                    return result;
                }
                int digitValue1 = Integer.parseInt(m1.group());
                if (digitValue1 == (digitValue2 = Integer.parseInt(m2.group()))) continue;
                result = digitValue1 > digitValue2 ? 1 : -1;
                return result;
            }
            return result;
        }
    }
}

