/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import net.jsdai.repo_edit.base.Activator;
import net.jsdai.repo_edit.jface.viewers.ITextCellEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.CellEditorActionHandler;

public class SdaiCellEditorActionHandler {
    private final UndoActionHandler undoAction;
    private final RedoActionHandler redoAction;
    private final CellEditorActionHandler handler;
    private final List<ITextCellEditor> textCellEditors = new ArrayList<ITextCellEditor>();
    private final FocusListener listener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            if (SdaiCellEditorActionHandler.this.undoAction != null) {
                SdaiCellEditorActionHandler.this.undoAction.setEnabled(false);
            }
            if (SdaiCellEditorActionHandler.this.redoAction != null) {
                SdaiCellEditorActionHandler.this.redoAction.setEnabled(false);
            }
        }

        public void focusLost(FocusEvent e) {
            if (SdaiCellEditorActionHandler.this.undoAction != null) {
                SdaiCellEditorActionHandler.this.undoAction.update();
            }
            if (SdaiCellEditorActionHandler.this.redoAction != null) {
                SdaiCellEditorActionHandler.this.redoAction.update();
            }
        }
    };

    public SdaiCellEditorActionHandler(IActionBars actionBars) {
        this.undoAction = (UndoActionHandler)actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        if (this.undoAction == null) {
            Activator.logError("Unable to get undo action", new IllegalStateException());
        }
        this.redoAction = (RedoActionHandler)actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
        if (this.redoAction == null) {
            Activator.logError("Unable to get redo action", new IllegalStateException());
        }
        this.handler = new CellEditorActionHandler(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        actionBars.updateActionBars();
    }

    public void setCopyAction(IAction action) {
        this.handler.setCopyAction(action);
    }

    public void setCutAction(IAction action) {
        this.handler.setCutAction(action);
    }

    public void setPasteAction(IAction action) {
        this.handler.setPasteAction(action);
    }

    public void setDeleteAction(IAction action) {
        this.handler.setDeleteAction(action);
    }

    public void setFindAction(IAction action) {
        this.handler.setFindAction(action);
    }

    public void addCellEditor(CellEditor editor) {
        if (editor instanceof ITextCellEditor) {
            ((ITextCellEditor)editor).addFocusListener(this.listener);
            this.textCellEditors.add((ITextCellEditor)editor);
        }
        this.handler.addCellEditor(editor);
    }

    public void removeCellEditor(CellEditor editor) {
        if (editor instanceof ITextCellEditor) {
            ((ITextCellEditor)editor).removeFocusListener(this.listener);
            this.textCellEditors.remove(editor);
        }
        this.handler.removeCellEditor(editor);
    }

    public void dispose() {
        for (ITextCellEditor editor : this.textCellEditors) {
            if (editor.getControl() == null || editor.getControl().isDisposed()) continue;
            editor.removeFocusListener(this.listener);
        }
        this.textCellEditors.clear();
        this.handler.dispose();
    }
}

