/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.repo_edit.jface.viewers.CellSelection;
import net.jsdai.repo_edit.jface.viewers.RowSelection;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.events.MouseEvent;

public final class Utils {
    private Utils() {
    }

    public static RowSelection createRowSelection(Object element, int column) {
        RowSelection newSelection = new RowSelection();
        newSelection.addRow(new CellSelection(element, new int[]{column}));
        return newSelection;
    }

    public static void setViewerEditor(TableViewer viewer) {
        if (viewer == null) {
            throw new NullPointerException();
        }
        TableViewerEditor.create((TableViewer)viewer, null, (ColumnViewerEditorActivationStrategy)new Strategy((ColumnViewer)viewer), (int)1);
    }

    public static void setViewerEditor(TreeViewer viewer) {
        if (viewer == null) {
            throw new NullPointerException();
        }
        TreeViewerEditor.create((TreeViewer)viewer, null, (ColumnViewerEditorActivationStrategy)new Strategy((ColumnViewer)viewer), (int)1);
    }

    private static class Strategy
    extends ColumnViewerEditorActivationStrategy {
        public Strategy(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            boolean activate = true;
            if (event.sourceEvent instanceof MouseEvent) {
                MouseEvent sourceEvent = (MouseEvent)event.sourceEvent;
                boolean bl = activate = sourceEvent.button == 1;
            }
            return activate && super.isEditorActivationEvent(event);
        }
    }
}

