/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import net.jsdai.repo_edit.jface.viewers.SdaiCellEditorActionHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionBars;

public class ViewerActionHandler {
    private final SdaiCellEditorActionHandler cellEditorActionHandler;
    private ActionHandler copyActionHandler;
    private ActionHandler cutActionHandler;
    private ActionHandler pasteActionHandler;
    private ActionHandler deleteActionHandler;
    private ActionHandler findActionHandler;

    public ViewerActionHandler(IActionBars actionBars) {
        this.cellEditorActionHandler = new SdaiCellEditorActionHandler(actionBars);
    }

    public void addCellEditor(CellEditor editor) {
        this.cellEditorActionHandler.addCellEditor(editor);
    }

    public void removeCellEditor(CellEditor editor) {
        this.cellEditorActionHandler.removeCellEditor(editor);
    }

    public void addCopyAction(IAction action) {
        if (this.copyActionHandler == null) {
            this.copyActionHandler = new ActionHandler("CopyActionHandler");
            this.cellEditorActionHandler.setCopyAction((IAction)this.copyActionHandler);
        }
        this.copyActionHandler.addAction(action);
    }

    public void addCutAction(IAction action) {
        if (this.cutActionHandler == null) {
            this.cutActionHandler = new ActionHandler("CutActionHandler");
            this.cellEditorActionHandler.setCutAction((IAction)this.cutActionHandler);
        }
        this.cutActionHandler.addAction(action);
    }

    public void addPasteAction(IAction action) {
        if (this.pasteActionHandler == null) {
            this.pasteActionHandler = new ActionHandler("PasteActionHandler");
            this.cellEditorActionHandler.setPasteAction((IAction)this.pasteActionHandler);
        }
        this.pasteActionHandler.addAction(action);
    }

    public void addDeleteAction(IAction action) {
        if (this.deleteActionHandler == null) {
            this.deleteActionHandler = new ActionHandler("DeleteActionHandler");
            this.cellEditorActionHandler.setDeleteAction((IAction)this.deleteActionHandler);
        }
        this.deleteActionHandler.addAction(action);
    }

    public void addFindAction(IAction action) {
        if (this.findActionHandler == null) {
            this.findActionHandler = new ActionHandler("FindActionHandler");
            this.cellEditorActionHandler.setFindAction((IAction)this.findActionHandler);
        }
        this.findActionHandler.addAction(action);
    }

    public void dispose() {
        if (this.copyActionHandler != null) {
            this.copyActionHandler.dispose();
            this.copyActionHandler = null;
        }
        if (this.cutActionHandler != null) {
            this.cutActionHandler.dispose();
            this.cutActionHandler = null;
        }
        if (this.pasteActionHandler != null) {
            this.pasteActionHandler.dispose();
            this.pasteActionHandler = null;
        }
        if (this.deleteActionHandler != null) {
            this.deleteActionHandler.dispose();
            this.deleteActionHandler = null;
        }
        if (this.findActionHandler != null) {
            this.findActionHandler.dispose();
            this.findActionHandler = null;
        }
        this.cellEditorActionHandler.dispose();
    }

    private static class ActionHandler
    extends Action {
        private IAction activeAction;
        private final List<IAction> actions = new ArrayList<IAction>();
        private final IPropertyChangeListener actionListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("enabled")) {
                    IAction sourceAction = (IAction)event.getSource();
                    if (sourceAction == ActionHandler.this.activeAction) {
                        ActionHandler.this.updateEnabledState();
                    } else {
                        Boolean bool = (Boolean)event.getNewValue();
                        if (bool.booleanValue()) {
                            ActionHandler.this.setActiveAction(sourceAction);
                        }
                    }
                }
            }
        };

        ActionHandler(String id) {
            this.setId(id);
            this.setEnabled(false);
        }

        public void addAction(IAction action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (!this.actions.contains(action)) {
                if (this.activeAction == null) {
                    this.setActiveAction(action);
                }
                this.actions.add(action);
                action.addPropertyChangeListener(this.actionListener);
            }
        }

        private void setActiveAction(IAction action) {
            this.activeAction = action;
            this.updateEnabledState();
        }

        public void runWithEvent(Event event) {
            if (this.activeAction != null) {
                this.activeAction.runWithEvent(event);
            }
        }

        public void updateEnabledState() {
            if (this.activeAction != null) {
                this.setEnabled(this.activeAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }

        public void dispose() {
            this.activeAction = null;
            for (IAction action : this.actions) {
                action.removePropertyChangeListener(this.actionListener);
            }
            this.actions.clear();
        }
    }
}

