/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.networkinfo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jsdai.repo_edit.networkinfo.NetworkInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxNetworkInfo
extends NetworkInfo {
    public static final String IPCONFIG_COMMAND = "ifconfig";
    protected static final String[] COMMAND_LOCATIONS = new String[]{"", "/sbin/", "/usr/sbin/", "/bin/", "/usr/bin/"};
    private static final Pattern INTERFACE_START_PATTERN = Pattern.compile("^([^ \t]+)");
    private static final Pattern HWADDR_PATTERN = Pattern.compile("HWaddr +([0-9A-Fa-f:-]+)");
    private static final Pattern ETHER_PATTERN = Pattern.compile("ether +([0-9A-Fa-f:-]+)");
    private static final Pattern MAC_PATTERN = Pattern.compile("(?:[0-9A-Fa-f]{2}[:-])+[0-9A-Fa-f]{2}");
    private static final MacAdder<String> STRING_ADDER = new MacAdder<String>(){

        @Override
        void add(Collection<String> macs, String macAddressCandidate, String interfaceName) {
            macs.add(LinuxNetworkInfo.cleanMacString(macAddressCandidate));
        }
    };
    private static final MacAdder<NetworkInfo.MacInfo> MAC_INFO_ADDER = new MacAdder<NetworkInfo.MacInfo>(){

        @Override
        void add(Collection<NetworkInfo.MacInfo> macs, String macAddressCandidate, String interfaceName) {
            macs.add(new NetworkInfo.MacInfo(LinuxNetworkInfo.cleanMacString(macAddressCandidate), String.valueOf(interfaceName) + " (" + macAddressCandidate + ")", 6));
        }
    };

    @Override
    public List<String> parseAllMacAddresses() {
        ArrayList<String> macs = new ArrayList<String>();
        this.parseMacAddresses(macs, STRING_ADDER);
        return macs;
    }

    @Override
    public NetworkInfo.MacInfo parsePrimaryAddress() {
        ArrayList macs = new ArrayList();
        this.parseMacAddresses(macs, MAC_INFO_ADDER);
        return !macs.isEmpty() ? (NetworkInfo.MacInfo)macs.get(0) : null;
    }

    @Override
    public List<NetworkInfo.MacInfo> parseMacAdressInfo() {
        ArrayList<NetworkInfo.MacInfo> macs = new ArrayList<NetworkInfo.MacInfo>();
        this.parseMacAddresses(macs, MAC_INFO_ADDER);
        return macs;
    }

    private <T> String parseMacAddresses(Collection<T> macs, MacAdder<T> macAdder) {
        Matcher interfaceStartMatcher = INTERFACE_START_PATTERN.matcher("");
        Matcher hwaddrMatcher = HWADDR_PATTERN.matcher("");
        Matcher etherMatcher = ETHER_PATTERN.matcher("");
        String ipConfigResponse = null;
        String command = null;
        int i = 0;
        while (i < COMMAND_LOCATIONS.length) {
            block9: {
                command = String.valueOf(COMMAND_LOCATIONS[i]) + IPCONFIG_COMMAND;
                try {
                    ipConfigResponse = this.runConsoleCommand(command);
                }
                catch (IOException e) {
                    break block9;
                }
                if (ipConfigResponse != null) {
                    StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
                    String interfaceName = "";
                    while (tokenizer.hasMoreTokens()) {
                        String line = tokenizer.nextToken();
                        interfaceStartMatcher.reset(line);
                        if (interfaceStartMatcher.lookingAt() && (interfaceName = interfaceStartMatcher.group(1)).endsWith(":")) {
                            interfaceName = interfaceName.substring(0, interfaceName.length() - 1);
                        }
                        String macAddressCandidate = null;
                        hwaddrMatcher.reset(line);
                        if (hwaddrMatcher.find()) {
                            macAddressCandidate = hwaddrMatcher.group(1);
                        } else {
                            etherMatcher.reset(line);
                            if (etherMatcher.find()) {
                                macAddressCandidate = etherMatcher.group(1);
                            }
                        }
                        if (macAddressCandidate == null || !LinuxNetworkInfo.isMacAddress(macAddressCandidate)) continue;
                        macAdder.add(macs, macAddressCandidate, interfaceName);
                    }
                    break;
                }
            }
            ++i;
        }
        return ipConfigResponse;
    }

    private static boolean isMacAddress(String macAddressCandidate) {
        return MAC_PATTERN.matcher(macAddressCandidate).matches();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MacAdder<T> {
        private MacAdder() {
        }

        abstract void add(Collection<T> var1, String var2, String var3);
    }
}

