/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.networkinfo;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.jsdai.repo_edit.networkinfo.AixNetworkInfo;
import net.jsdai.repo_edit.networkinfo.LinuxNetworkInfo;
import net.jsdai.repo_edit.networkinfo.WindowsNetworkInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NetworkInfo {
    public static Map<Integer, String> NETWORK_IF_TYPES = new HashMap<Integer, String>();
    private static final Pattern MAC_GROUP_SEPARATORS;

    static {
        NETWORK_IF_TYPES.put(new Integer(1), "OTHER");
        NETWORK_IF_TYPES.put(new Integer(6), "ETHERNET");
        NETWORK_IF_TYPES.put(new Integer(9), "TOKENRING");
        NETWORK_IF_TYPES.put(new Integer(15), "FDDI");
        NETWORK_IF_TYPES.put(new Integer(23), "PPP");
        NETWORK_IF_TYPES.put(new Integer(24), "LOOPBACK");
        NETWORK_IF_TYPES.put(new Integer(28), "SLIP");
        MAC_GROUP_SEPARATORS = Pattern.compile("-|:");
    }

    public abstract List<String> parseAllMacAddresses();

    public abstract MacInfo parsePrimaryAddress();

    public abstract List<MacInfo> parseMacAdressInfo();

    public static final List<String> getAllMacAddresses() throws IOException {
        NetworkInfo info = NetworkInfo.getNetworkInfo();
        List<String> macs = info.parseAllMacAddresses();
        return macs;
    }

    public static final List<MacInfo> getMacAdressInfo() throws IOException {
        NetworkInfo info = NetworkInfo.getNetworkInfo();
        List<MacInfo> macs = info.parseMacAdressInfo();
        return macs;
    }

    public static final MacInfo getPrimaryMacAdress() throws IOException {
        NetworkInfo info = NetworkInfo.getNetworkInfo();
        MacInfo macInfo = info.parsePrimaryAddress();
        return macInfo;
    }

    protected String runConsoleCommand(String command) throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec(command);
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    protected String runConsoleCommand(String[] command) throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec(command);
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    protected static String cleanMacString(String mac) {
        return MAC_GROUP_SEPARATORS.matcher(mac).replaceAll("").toLowerCase();
    }

    private static NetworkInfo getNetworkInfo() throws IOException {
        String os = System.getProperty("os.name");
        if ((os = os.toLowerCase()).indexOf("windows") > -1) {
            return new WindowsNetworkInfo();
        }
        if (os.indexOf("aix") > -1) {
            return new AixNetworkInfo();
        }
        if (System.getProperty("path.separator").equals(":") && os.indexOf("openvms") < 0 && (os.indexOf("mac") < 0 || os.endsWith("x"))) {
            return new LinuxNetworkInfo();
        }
        throw new IOException("unknown operating system: " + os);
    }

    public static class MacInfo {
        public String mac;
        public String description;
        public int type;

        public MacInfo(String mac, String description, int type) {
            this.mac = mac;
            this.description = description;
            this.type = type;
        }

        public String toString() {
            return this.description;
        }
    }
}

