/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.networkinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jsdai.repo_edit.networkinfo.MacRetrieverBridge;
import net.jsdai.repo_edit.networkinfo.NetworkInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsNetworkInfo
extends NetworkInfo {
    @Override
    public List<String> parseAllMacAddresses() {
        String[] macs = new String[16];
        String[] names = new String[16];
        String[] descriptions = new String[16];
        int[] types = new int[16];
        int macCount = 0;
        try {
            macCount = MacRetrieverBridge.getLocalEthernetProperties(macs, names, descriptions, types);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        if (macCount > 0) {
            ArrayList<String> macList = new ArrayList<String>();
            int i = 0;
            while (i < macCount) {
                macList.add(WindowsNetworkInfo.cleanMacString(macs[i]));
                ++i;
            }
            return macList;
        }
        return Collections.emptyList();
    }

    @Override
    public NetworkInfo.MacInfo parsePrimaryAddress() {
        List<NetworkInfo.MacInfo> macList = this.parseMacAdressInfo();
        return macList.isEmpty() ? macList.get(0) : null;
    }

    @Override
    public List<NetworkInfo.MacInfo> parseMacAdressInfo() {
        String[] macs = new String[16];
        String[] names = new String[16];
        String[] descriptions = new String[16];
        int[] types = new int[16];
        int macCount = 0;
        try {
            macCount = MacRetrieverBridge.getLocalEthernetProperties(macs, names, descriptions, types);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        if (macCount > 0) {
            ArrayList<NetworkInfo.MacInfo> macList = new ArrayList<NetworkInfo.MacInfo>();
            int i = 0;
            while (i < macCount) {
                macList.add(new NetworkInfo.MacInfo(WindowsNetworkInfo.cleanMacString(macs[i]), descriptions[i], types[i]));
                ++i;
            }
            return macList;
        }
        return Collections.emptyList();
    }
}

