/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.part;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractInputField {
    protected final String text;
    protected final int dialogStyle;
    private Control control;
    private String labelValue;
    protected Text inputText;
    private String initialBrowseFolder;

    public AbstractInputField(String text, int dialogStyle, String label) {
        if (text == null || label == null) {
            throw new NullPointerException();
        }
        this.labelValue = label;
        this.text = text;
        this.dialogStyle = dialogStyle;
    }

    public String getInitialBrowseFolder() {
        return this.initialBrowseFolder;
    }

    public void setInitialBrowseFolder(String initialBrowseFolder) {
        this.initialBrowseFolder = initialBrowseFolder;
    }

    public String getInputValue() {
        if (this.inputText == null) {
            throw new IllegalStateException();
        }
        return this.inputText.getText();
    }

    public void setInputValue(String text) {
        if (text == null) {
            throw new IllegalStateException();
        }
        this.inputText.setText(text);
    }

    public void setFocus() {
        if (this.inputText != null) {
            this.inputText.setFocus();
        }
    }

    public void createControl(Composite parent) {
        Composite fileBrowseComposite = new Composite(parent, 0);
        boolean labelProvided = this.labelValue != null && this.labelValue.length() > 0;
        GridLayout gridLayout = new GridLayout(labelProvided ? 3 : 2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        fileBrowseComposite.setLayout((Layout)gridLayout);
        fileBrowseComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.control = fileBrowseComposite;
        if (labelProvided) {
            Label fileLabel = new Label(fileBrowseComposite, 0);
            fileLabel.setText(this.labelValue);
            fileLabel.setLayoutData((Object)new GridData(1));
        }
        this.inputText = new Text(fileBrowseComposite, 2052);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 200;
        this.inputText.setLayoutData((Object)gd);
        this.inputText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AbstractInputField.this.fireValueChanged();
            }
        });
        Control button = this.createButton(fileBrowseComposite);
        button.setLayoutData((Object)new GridData(1040));
    }

    protected abstract Control createButton(Composite var1);

    public Control getControl() {
        return this.control;
    }

    protected abstract void fireValueChanged();
}

