/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.part;

import net.jsdai.l10n.CommonStringsMessages;
import net.jsdai.l10n.RepoEditBaseMessages;
import net.jsdai.repo_edit.part.FileInputField;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.FieldAssistColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FileListEditor {
    String[] files;
    String[] names;
    private Control control;
    Table confFilesTable;
    FileInputField newFileText;
    Text newNameText;

    public FileListEditor(String[] files, String[] names) {
        if (files == null || names == null) {
            throw new NullPointerException();
        }
        if (files.length != names.length) {
            throw new IllegalArgumentException();
        }
        this.files = files;
        this.names = names;
    }

    public Control getControl() {
        return this.control;
    }

    public void createControl(Composite parent) {
        Composite entryTable = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        entryTable.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        entryTable.setLayout((Layout)layout);
        new Label(entryTable, 0);
        this.createTable(entryTable);
        this.createMainComposite(entryTable);
        this.control = entryTable;
    }

    private void createMainComposite(Composite entryTable) {
        Composite mainComposite = new Composite(entryTable, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        mainComposite.setLayout((Layout)buttonLayout);
        GridData data = new GridData(1810);
        mainComposite.setLayoutData((Object)data);
        this.createInputFields(mainComposite);
        this.createButtonsComposite(mainComposite);
    }

    private void createButtonsComposite(Composite mainComposite) {
        final Composite buttonsComposite = new Composite(mainComposite, 0);
        GridData data = new GridData(0x1000008, 0x1000000, true, false);
        buttonsComposite.setLayoutData((Object)data);
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 8;
        buttonsComposite.setLayout((Layout)rowLayout);
        Button addButton = new Button(buttonsComposite, 0x1000008);
        addButton.setText(CommonStringsMessages.add);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (FileListEditor.this.newFileText.getFile() != "" && FileListEditor.this.newNameText.getText() != "") {
                    TableItem item = new TableItem(FileListEditor.this.confFilesTable, 0);
                    item.setText(0, FileListEditor.this.newNameText.getText());
                    item.setText(1, FileListEditor.this.newFileText.getFile());
                } else {
                    MessageDialog dlg = new MessageDialog(buttonsComposite.getShell(), RepoEditBaseMessages.FileListEditor_YouHaveToEnterAll, null, RepoEditBaseMessages.FileListEditor_EnterBothFields, 0, new String[]{CommonStringsMessages.ok}, 0);
                    dlg.open();
                }
            }
        });
        Button removeButton = new Button(buttonsComposite, 0x1000008);
        removeButton.setText(RepoEditBaseMessages.FileListEditor_RemoveSelected);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (FileListEditor.this.confFilesTable.getSelectionIndex() != -1) {
                    FileListEditor.this.confFilesTable.remove(FileListEditor.this.confFilesTable.getSelectionIndex());
                }
            }
        });
    }

    private void createInputFields(Composite mainComposite) {
        this.newFileText = new FileInputField(RepoEditBaseMessages.FileListEditor_SelectXMLConfig, 4096, new String[]{"*.xml"}, new String[]{RepoEditBaseMessages.FileListEditor_XMLFile}, RepoEditBaseMessages.FileListEditor_ConfigFile);
        this.newFileText.createControl(mainComposite);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.newFileText.getControl().setLayoutData((Object)data);
        Composite newNameComposite = new Composite(mainComposite, 0);
        GridLayout newNameLayout = new GridLayout();
        newNameLayout.numColumns = 2;
        newNameComposite.setLayout((Layout)newNameLayout);
        newNameComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        Label fileLabel = new Label(newNameComposite, 0);
        fileLabel.setText(RepoEditBaseMessages.FileListEditor_DisplayName);
        fileLabel.setAlignment(131072);
        data = new GridData(80, 25);
        fileLabel.setLayoutData((Object)data);
        this.newNameText = new Text(newNameComposite, 2052);
        this.newNameText.setBackground(FieldAssistColors.getRequiredFieldBackgroundColor((Control)this.newNameText));
        data = new GridData(4, 0x1000000, true, false);
        this.newNameText.setLayoutData((Object)data);
    }

    private void createTable(Composite entryTable) {
        this.confFilesTable = new Table(entryTable, 67584);
        this.confFilesTable.setLinesVisible(true);
        this.confFilesTable.setHeaderVisible(true);
        String[] titles = new String[]{CommonStringsMessages.name, CommonStringsMessages.location};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.confFilesTable, 0);
            column.setText(titles[i]);
            column.setWidth(200);
            ++i;
        }
        String[] filesLocal = this.files;
        String[] namesLocal = this.names;
        int i2 = 0;
        while (i2 < filesLocal.length) {
            TableItem item = new TableItem(this.confFilesTable, 0);
            item.setText(0, namesLocal[i2]);
            item.setText(1, filesLocal[i2]);
            ++i2;
        }
        GridData data = new GridData(1808);
        this.confFilesTable.setLayoutData((Object)data);
    }

    public Table getConfFilesTable() {
        return this.confFilesTable;
    }

    public void clearConfFilesTable() {
        this.confFilesTable.removeAll();
    }

    public void addRow(String file, String name) {
        TableItem item = new TableItem(this.confFilesTable, 0);
        item.setText(0, name);
        item.setText(1, file);
    }

    public int getFilesCount() {
        return this.confFilesTable.getItemCount();
    }

    public String getFileNameById(int id) {
        return this.confFilesTable.getItem(id).getText(0);
    }

    public String getFileById(int id) {
        return this.confFilesTable.getItem(id).getText(1);
    }
}

