/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.part;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.PageBookView;

public abstract class InputAwarePageBookView
extends PageBookView {
    private final Collection<IWorkbenchPart> listenedParts = new HashSet<IWorkbenchPart>();
    private final IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 258) {
                InputAwarePageBookView.this.partActivated((IWorkbenchPart)source);
            }
        }
    };

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IEditorPart && part.getSite().getPage().getEditorReferences().length == 1) {
            this.partActivated(part);
        } else {
            super.partOpened(part);
            this.addListener(part);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        this.removeListener(part);
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        this.addListener(part);
    }

    protected void partHidden(final IWorkbenchPart part) {
        part.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                InputAwarePageBookView.this.partHiddenLocal(part);
            }
        });
    }

    private void partHiddenLocal(IWorkbenchPart part) {
        if (!(part instanceof IEditorPart) || part.getSite().getPage().isEditorAreaVisible()) {
            super.partHidden(part);
        }
    }

    private void addListener(IWorkbenchPart part) {
        if (!this.listenedParts.contains(part)) {
            part.addPropertyListener(this.propertyListener);
            this.listenedParts.add(part);
        }
    }

    private void removeListener(IWorkbenchPart part) {
        this.listenedParts.remove(part);
        part.removePropertyListener(this.propertyListener);
    }

    public void dispose() {
        super.dispose();
        for (IWorkbenchPart part : this.listenedParts) {
            part.removePropertyListener(this.propertyListener);
        }
    }
}

