/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.part;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class StatusLineTextContribution
extends ControlContribution {
    private final String refString;
    private Label label;
    private String text;
    private String toolTip;
    private boolean isDirty = false;

    public StatusLineTextContribution(String id, String refString) {
        super(id);
        this.refString = refString;
    }

    public void setText(String text) {
        this.text = text;
        if (this.label != null && !this.label.isDisposed()) {
            if (text != null) {
                this.label.setText(text);
            } else {
                this.label.setText("");
            }
            this.isDirty = true;
        }
    }

    public String getText() {
        return this.text;
    }

    public void setToolTipText(String toolTip) {
        this.toolTip = toolTip;
        if (this.label != null && !this.label.isDisposed()) {
            if (toolTip != null) {
                this.label.setToolTipText(toolTip);
            } else {
                this.label.setToolTipText("");
            }
            this.isDirty = true;
        }
    }

    public String getToolTipText() {
        return this.toolTip;
    }

    public boolean isDynamic() {
        return this.refString == null;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected Control createControl(Composite parent) {
        Composite parentComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        parentComp.setLayout((Layout)layout);
        this.label = new Label(parentComp, 0x1000000);
        GridData labelLayoutData = new GridData(0x1000000, 0x1000000, true, true);
        this.label.setLayoutData((Object)labelLayoutData);
        if (this.toolTip != null) {
            this.label.setToolTipText(this.toolTip);
        }
        if (this.text != null) {
            this.label.setText(this.text);
        }
        int[] hints = this.getHints((Control)this.label);
        StatusLineLayoutData layoutData = new StatusLineLayoutData();
        if (hints[1] != 0) {
            layoutData.heightHint = hints[1];
            labelLayoutData.heightHint = hints[1];
        }
        if (hints[0] != 0) {
            layoutData.widthHint = hints[0] + layout.marginWidth * 2;
            labelLayoutData.widthHint = hints[0];
        }
        parentComp.setLayoutData((Object)layoutData);
        this.isDirty = false;
        return parentComp;
    }

    private int[] getHints(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fm = gc.getFontMetrics();
        int heightHint = fm.getHeight();
        int widthHint = 0;
        if (this.refString != null) {
            int i = 0;
            int n = this.refString.length();
            while (i < n) {
                widthHint += gc.getAdvanceWidth(this.refString.charAt(i));
                ++i;
            }
        }
        gc.dispose();
        return new int[]{widthHint, heightHint};
    }
}

