/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.services;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import net.jsdai.repo_edit.base.Activator;
import net.jsdai.repo_edit.networkinfo.MacRetrieverBridge;
import net.jsdai.repo_edit.networkinfo.NetworkInfo;
import net.jsdai.repo_edit.services.CryptRSA;
import net.jsdai.repo_edit.services.LicensedFeatureData;
import net.jsdai.repo_edit.services.LicenseeInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LicensingService {
    private static final boolean LICENSING = true;
    private static volatile LicensingService instance = null;
    private volatile byte[] keyData;

    private LicensingService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LicensingService getInstance() {
        if (instance != null) return instance;
        Class<LicensingService> clazz = LicensingService.class;
        synchronized (LicensingService.class) {
            if (instance != null) return instance;
            instance = new LicensingService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean configureFeatures(String baseFeatureStr, byte[] keyData) throws IOException, GeneralSecurityException {
        this.keyData = keyData;
        HashSet<String> licensedFeatures = new HashSet<String>(Arrays.asList(baseFeatureStr.split("[ \n\r\t]+")));
        Collection<LicensedFeatureData> allLicensedFeatures = this.loadLicensedFeatures();
        for (LicensedFeatureData featureData : allLicensedFeatures) {
            if (featureData.isExpired()) continue;
            licensedFeatures.add(featureData.getFeatureId());
        }
        Set<String> confFeatures = LicensingService.getAllPlatformFeatures();
        confFeatures.retainAll(licensedFeatures);
        Set<String> actualFeatures = LicensingService.getConfiguredFeatures();
        boolean sitesManagedOnly = LicensingService.areSitesManagedOnly();
        if (!sitesManagedOnly || !confFeatures.containsAll(actualFeatures) || confFeatures.size() != actualFeatures.size()) {
            LicensingService.resetSites();
            LicensingService.enableFeatures(licensedFeatures);
            Set<String> newFeatures = LicensingService.getConfiguredFeatures();
            if (!sitesManagedOnly || !actualFeatures.containsAll(newFeatures) || actualFeatures.size() != newFeatures.size()) {
                ConfiguratorUtils.getCurrentPlatformConfiguration().save();
                return true;
            }
            return false;
        }
        return false;
    }

    public void checkLicense(Class<?> caller) throws SecurityException {
        if (this.keyData == null) {
            throw LicensingService.hideException(new SecurityException());
        }
        try {
            String callerName = caller.getName();
            IBundleGroupProvider[] bundleGroupProviders = Platform.getBundleGroupProviders();
            int i = 0;
            while (i < bundleGroupProviders.length) {
                IBundleGroupProvider bundleGroupProvider = bundleGroupProviders[i];
                IBundleGroup[] bundleGroups = bundleGroupProvider.getBundleGroups();
                int j = 0;
                while (j < bundleGroups.length) {
                    IBundleGroup bundleGroup = bundleGroups[j];
                    Bundle[] bundles = bundleGroup.getBundles();
                    int k = 0;
                    while (k < bundles.length) {
                        Bundle bundle = bundles[k];
                        if (bundle.getBundleId() > 0L && (bundle.getState() == 32 || bundle.getState() == 8)) {
                            try {
                                if (bundle.loadClass(callerName) == caller) {
                                    this.checkLicense(bundle.getSymbolicName());
                                    return;
                                }
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                // empty catch block
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw LicensingService.hideException(new SecurityException());
    }

    private void checkLicense(String bundleName) throws SecurityException, IOException, GeneralSecurityException {
        Properties licenseProps = LicensingService.loadLicenseProperties(this.keyData);
        String licPluginStr = licenseProps.getProperty("licensed-plugins");
        if (LicensingService.checkHostId(licenseProps) && licPluginStr != null) {
            String[] licPluginItems = licPluginStr.split("[ \n\r\t]+");
            int l = 0;
            while (l < licPluginItems.length) {
                String licPluginItem = licPluginItems[l];
                String[] licPluginItemParts = licPluginItem.split("@");
                if (licPluginItemParts[0].equals(bundleName)) {
                    if (licPluginItemParts.length > 1) {
                        try {
                            Calendar expireCalendar = Calendar.getInstance();
                            SimpleDateFormat dateInputFormat = new SimpleDateFormat("yyyy-MM-dd");
                            expireCalendar.setTime(dateInputFormat.parse(licPluginItemParts[1]));
                            expireCalendar.add(5, 1);
                            Calendar currentCalendar = Calendar.getInstance();
                            if (expireCalendar.compareTo(currentCalendar) <= 0) {
                                break;
                            }
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    return;
                }
                ++l;
            }
        }
        throw LicensingService.hideException(new SecurityException());
    }

    public LicenseeInfo getLicenseeInfoBytes(String productVersion, String licenseNum) throws IOException {
        String sysProperty;
        Properties licenseeInfoProps = new Properties();
        boolean[] wasCreated = new boolean[1];
        UUID hostId = LicensingService.getHostId(wasCreated);
        if (wasCreated[0]) {
            licenseeInfoProps.setProperty("validate-host-id", "");
        }
        if (productVersion != null) {
            licenseeInfoProps.setProperty("product-version", productVersion);
        }
        if (licenseNum != null) {
            licenseeInfoProps.setProperty("license-num", licenseNum);
        }
        if ((sysProperty = System.getProperty("os.name")) != null) {
            licenseeInfoProps.setProperty("os-name", sysProperty);
        }
        if ((sysProperty = System.getProperty("os.arch")) != null) {
            licenseeInfoProps.setProperty("os-arch", sysProperty);
        }
        if ((sysProperty = System.getProperty("os.version")) != null) {
            licenseeInfoProps.setProperty("os-version", sysProperty);
        }
        if ((sysProperty = System.getProperty("user.name")) != null) {
            licenseeInfoProps.setProperty("user-name", sysProperty);
        }
        LicensingService.loadFeatureInfo(licenseeInfoProps);
        List<NetworkInfo.MacInfo> macAdressInfo = NetworkInfo.getMacAdressInfo();
        for (NetworkInfo.MacInfo macInfo : macAdressInfo) {
            licenseeInfoProps.setProperty("network-" + macInfo.mac, macInfo.description);
        }
        LicensingService.loadLicenseeHddAndVolInfo(licenseeInfoProps);
        ByteArrayOutputStream licenseeInfoOut = new ByteArrayOutputStream();
        PropertyDoctypeRemoverStream licenseeInfoStore = new PropertyDoctypeRemoverStream(licenseeInfoOut);
        licenseeInfoProps.storeToXML(licenseeInfoStore, null);
        licenseeInfoStore.close();
        return new LicenseeInfo(licenseeInfoProps, licenseeInfoOut.toByteArray(), hostId);
    }

    private static void loadLicenseeHddAndVolInfo(Properties licenseeInfoProps) {
        if ("win32".equals(Platform.getOS())) {
            String drive = System.getenv("SystemDrive");
            if (drive == null) {
                drive = "C:";
            }
            MacRetrieverBridge.HDDInfo hddInfo = new MacRetrieverBridge.HDDInfo();
            MacRetrieverBridge.readLetterHddInfoAndGeometryWithZeroRights(drive, true, hddInfo);
            licenseeInfoProps.setProperty("hdd0", String.valueOf('[') + hddInfo.serial + "][" + hddInfo.model + "][" + hddInfo.revision + "][" + (hddInfo.geometryAvailable ? hddInfo.size : 0L) + ']');
            MacRetrieverBridge.VolInfo volInfo = new MacRetrieverBridge.VolInfo();
            MacRetrieverBridge.readVolumeInfo(drive, volInfo);
            licenseeInfoProps.setProperty("volume-ids", String.valueOf(Integer.toHexString(volInfo.serialNumberHi).toUpperCase()) + '-' + Integer.toHexString(volInfo.serialNumberLo).toUpperCase() + ' ' + volInfo.filesystemName);
        }
    }

    private static void loadFeatureInfo(Properties licenseeInfoProps) {
        IPlatformConfiguration platformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        StringBuilder featureVersionProp = new StringBuilder("feature-version-");
        int featureVersionPropLen = featureVersionProp.length();
        IPlatformConfiguration.IFeatureEntry[] featureEntries = platformConfiguration.getConfiguredFeatureEntries();
        int i = 0;
        while (i < featureEntries.length) {
            IPlatformConfiguration.IFeatureEntry featureEntry = featureEntries[i];
            featureVersionProp.setLength(featureVersionPropLen);
            featureVersionProp.append(featureEntry.getFeatureIdentifier());
            licenseeInfoProps.setProperty(featureVersionProp.toString(), featureEntry.getFeatureVersion());
            ++i;
        }
    }

    public void storeLicenseProperties(InputStream licensePropertiesIn) throws IOException {
        URL configUrl = Platform.getConfigurationLocation().getURL();
        if (configUrl.getProtocol().equalsIgnoreCase("file")) {
            File configDir = new File(configUrl.getPath());
            File licenseDir = new File(configDir, "net.jsdai.repo_edit.base");
            licenseDir.mkdirs();
            File licensePropFile = new File(licenseDir, "license.lic");
            if (licensePropFile.exists()) {
                File bakLicensePropFile = new File(licenseDir, "license.lic.bak");
                bakLicensePropFile.delete();
                licensePropFile.renameTo(bakLicensePropFile);
            }
            FileOutputStream licensePropOut = new FileOutputStream(licensePropFile);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                ((OutputStream)licensePropOut).write(buffer, 0, count);
            } while ((count = licensePropertiesIn.read(buffer, 0, buffer.length)) != -1);
            ((OutputStream)licensePropOut).close();
        }
    }

    public Properties loadLicenseProperties() throws IOException, GeneralSecurityException {
        return LicensingService.loadLicenseProperties(this.keyData);
    }

    public boolean revertLicenseProperties() {
        File configDir;
        File licenseDir;
        File bakLicensePropFile;
        URL configUrl = Platform.getConfigurationLocation().getURL();
        if (configUrl.getProtocol().equalsIgnoreCase("file") && (bakLicensePropFile = new File(licenseDir = new File(configDir = new File(configUrl.getPath()), "net.jsdai.repo_edit.base"), "license.lic.bak")).canRead() && bakLicensePropFile.isFile()) {
            File licensePropFile = new File(licenseDir, "license.lic");
            licensePropFile.delete();
            return bakLicensePropFile.renameTo(licensePropFile);
        }
        return false;
    }

    public void storeOfflineLicense(String licenseNum) throws IOException {
        URL configUrl = Platform.getConfigurationLocation().getURL();
        if (configUrl.getProtocol().equalsIgnoreCase("file")) {
            File configDir = new File(configUrl.getPath());
            File licenseDir = new File(configDir, "net.jsdai.repo_edit.base");
            licenseDir.mkdirs();
            File offlineLicenseFile = new File(licenseDir, "license.offline");
            FileOutputStream offlineLicenseOut = new FileOutputStream(offlineLicenseFile);
            try {
                ((OutputStream)offlineLicenseOut).write(licenseNum.getBytes("UTF-8"));
            }
            finally {
                ((OutputStream)offlineLicenseOut).close();
            }
        }
    }

    public String loadOfflineLicense() throws IOException {
        File configDir;
        File licenseDir;
        File offlineLicenseFile;
        URL configUrl = Platform.getConfigurationLocation().getURL();
        if (configUrl.getProtocol().equalsIgnoreCase("file") && (offlineLicenseFile = new File(licenseDir = new File(configDir = new File(configUrl.getPath()), "net.jsdai.repo_edit.base"), "license.offline")).canRead()) {
            FileInputStream offlineLicenseIn = new FileInputStream(offlineLicenseFile);
            ByteArrayOutputStream offlineLicenseOut = new ByteArrayOutputStream();
            try {
                byte[] buffer = new byte[512];
                int count = 0;
                do {
                    offlineLicenseOut.write(buffer, 0, count);
                } while ((count = ((InputStream)offlineLicenseIn).read(buffer, 0, buffer.length)) != -1);
                String string = offlineLicenseOut.toString("UTF-8");
                return string;
            }
            finally {
                ((InputStream)offlineLicenseIn).close();
                offlineLicenseOut.close();
            }
        }
        return null;
    }

    public void deleteLicense() {
        URL configUrl = Platform.getConfigurationLocation().getURL();
        if (configUrl.getProtocol().equalsIgnoreCase("file")) {
            File configDir = new File(configUrl.getPath());
            File licenseDir = new File(configDir, "net.jsdai.repo_edit.base");
            File offlineLicenseFile = new File(licenseDir, "license.lic");
            offlineLicenseFile.delete();
        }
    }

    public void deleteOfflineLicense() {
        URL configUrl = Platform.getConfigurationLocation().getURL();
        if (configUrl.getProtocol().equalsIgnoreCase("file")) {
            File configDir = new File(configUrl.getPath());
            File licenseDir = new File(configDir, "net.jsdai.repo_edit.base");
            File offlineLicenseFile = new File(licenseDir, "license.offline");
            offlineLicenseFile.delete();
        }
    }

    public Collection<LicensedFeatureData> loadLicensedFeatures() throws IOException, GeneralSecurityException {
        ArrayList<LicensedFeatureData> licensedFeatures = new ArrayList<LicensedFeatureData>();
        Properties licenseProps = LicensingService.loadLicenseProperties(this.keyData);
        String licFeatureStr = licenseProps.getProperty("licensed-features");
        if (LicensingService.checkHostId(licenseProps) && licFeatureStr != null) {
            Calendar currentCalendar = Calendar.getInstance();
            Calendar expireCalendar = Calendar.getInstance();
            SimpleDateFormat dateInputFormat = new SimpleDateFormat("yyyy-MM-dd");
            String[] licFeatureItems = licFeatureStr.split("[ \n\r\t]+");
            int i = 0;
            while (i < licFeatureItems.length) {
                String licFeatureItem = licFeatureItems[i];
                if (licFeatureItem.length() > 0) {
                    String[] licFeatureItemParts = licFeatureItem.split("@");
                    Date featureExpireDate = null;
                    boolean expired = false;
                    if (licFeatureItemParts.length > 1) {
                        try {
                            featureExpireDate = dateInputFormat.parse(licFeatureItemParts[1]);
                            expireCalendar.setTime(featureExpireDate);
                            expireCalendar.add(5, 1);
                            expired = expireCalendar.compareTo(currentCalendar) <= 0;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    licensedFeatures.add(new LicensedFeatureData(licFeatureItemParts[0], featureExpireDate, expired));
                }
                ++i;
            }
        }
        return licensedFeatures;
    }

    public void listSites() {
        IPlatformConfiguration platformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        IPlatformConfiguration.ISiteEntry[] sites = platformConfiguration.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IPlatformConfiguration.ISiteEntry site = sites[i];
            String[] features = site.getFeatures();
            int j = 0;
            while (j < features.length) {
                String feature = features[j];
                System.out.println(feature);
                ++j;
            }
            ++i;
        }
    }

    public void listFeatures() throws CoreException {
        IPlatformConfiguration platformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        IPlatformConfiguration.IFeatureEntry[] featureEntries = platformConfiguration.getConfiguredFeatureEntries();
        System.out.println(featureEntries[0].getFeatureIdentifier());
        int i = 0;
        while (i < featureEntries.length) {
            IPlatformConfiguration.IFeatureEntry featureEntry = featureEntries[i];
            System.out.println(featureEntry.getFeatureIdentifier());
            URL[] rootURLs = featureEntry.getFeatureRootURLs();
            System.out.println(rootURLs.length);
            int j = 0;
            while (j < rootURLs.length) {
                System.out.println("  => " + rootURLs[j]);
                ++j;
            }
            ++i;
        }
    }

    public boolean disableFeature(String featureId) throws IOException {
        IPlatformConfiguration platformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        boolean saveNeeded = false;
        IPlatformConfiguration.ISiteEntry[] sites = platformConfiguration.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IPlatformConfiguration.ISiteEntry site = sites[i];
            IPlatformConfiguration.ISitePolicy policy = site.getSitePolicy();
            if (policy.getType() != 2) {
                policy = platformConfiguration.createSitePolicy(2, new String[0]);
                site.setSitePolicy(policy);
                saveNeeded = true;
            }
            ++i;
        }
        IPlatformConfiguration.IFeatureEntry featureEntry = platformConfiguration.findConfiguredFeatureEntry(featureId);
        if (featureEntry != null) {
            platformConfiguration.unconfigureFeatureEntry(featureEntry);
            saveNeeded = true;
        }
        if (saveNeeded) {
            platformConfiguration.save();
            return true;
        }
        return false;
    }

    private static Properties loadLicenseProperties(byte[] keyData) throws IOException, GeneralSecurityException {
        Properties licenseProps = new Properties();
        URL configUrl = Platform.getConfigurationLocation().getURL();
        if (configUrl.getProtocol().equalsIgnoreCase("file")) {
            File configDir = new File(configUrl.getPath());
            File licenseDir = new File(configDir, "net.jsdai.repo_edit.base");
            licenseDir.mkdirs();
            File licensePropFile = new File(licenseDir, "license.lic");
            if (licensePropFile.exists()) {
                ByteArrayOutputStream licensePropOut = new ByteArrayOutputStream();
                InputStream licensePropStream = new BufferedInputStream(new FileInputStream(licensePropFile));
                try {
                    CryptRSA.getInstance().decodeRSA(licensePropStream, licensePropOut, keyData, false);
                }
                finally {
                    licensePropStream.close();
                }
                licensePropStream = new ByteArrayInputStream(licensePropOut.toByteArray());
                try {
                    licenseProps.loadFromXML(new PropertyDoctypeInserterStream(licensePropStream));
                }
                finally {
                    licensePropStream.close();
                }
            }
        }
        return licenseProps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkHostId(Properties licenseProps) throws IOException {
        try {
            Map.Entry<Object, Object> licenseeInfo;
            String licenseProp;
            UUID hostId = LicensingService.getHostId(null);
            if (hostId == null) return false;
            if (!hostId.equals(UUID.fromString(licenseProps.getProperty("host-id", "00000000-0000-0000-0000-000000000000")))) return false;
            boolean bl = true;
            boolean status = bl;
            if (!status) return status;
            Properties licenseeInfoProps = new Properties();
            LicensingService.loadLicenseeHddAndVolInfo(licenseeInfoProps);
            Iterator<Map.Entry<Object, Object>> iterator = licenseeInfoProps.entrySet().iterator();
            do {
                if (!iterator.hasNext()) return status;
            } while ((licenseProp = licenseProps.getProperty((String)(licenseeInfo = iterator.next()).getKey())) == null || licenseProp.equals(licenseeInfo.getValue()));
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static String getHostIdName() {
        char[] nameChars = new char[17];
        nameChars[7] = 48;
        nameChars[5] = 49;
        nameChars[0] = 46;
        nameChars[6] = 54;
        nameChars[14] = 50;
        nameChars[9] = 51;
        nameChars[10] = 49;
        nameChars[11] = 54;
        nameChars[15] = 51;
        nameChars[3] = 56;
        nameChars[4] = 54;
        nameChars[2] = 52;
        nameChars[16] = 52;
        nameChars[8] = 56;
        nameChars[1] = 55;
        nameChars[12] = 56;
        nameChars[13] = 48;
        return new String(nameChars);
    }

    private static UUID getHostId(boolean[] wasCreated) throws IOException {
        UUID hostId;
        String allUsersDir;
        if (wasCreated != null && wasCreated.length > 0) {
            wasCreated[0] = false;
        } else {
            wasCreated = null;
        }
        File userHostIdFile = new File(System.getProperty("user.home"), LicensingService.getHostIdName());
        if ("win32".equals(Platform.getOS()) && (allUsersDir = MacRetrieverBridge.getCommonAppdataDir()) != null) {
            File sharedHostIdFile = new File(allUsersDir, LicensingService.getHostIdName());
            UUID hostId2 = LicensingService.readHostId(sharedHostIdFile);
            if (hostId2 == null) {
                hostId2 = LicensingService.conditionalCreateHostId(sharedHostIdFile, LicensingService.readHostId(userHostIdFile), wasCreated);
            }
            if (hostId2 != null) {
                return hostId2;
            }
        }
        if ((hostId = LicensingService.readHostId(userHostIdFile)) == null) {
            hostId = LicensingService.conditionalCreateHostId(userHostIdFile, null, wasCreated);
        }
        return hostId;
    }

    private static UUID readHostId(File hostIdFile) throws IOException {
        UUID hostId;
        block5: {
            hostId = null;
            try {
                if (!hostIdFile.exists()) break block5;
                DataInputStream hostIdIn = new DataInputStream(new FileInputStream(hostIdFile));
                try {
                    long hostIdMsb = hostIdIn.readLong();
                    long hostIdLsb = hostIdIn.readLong();
                    hostId = new UUID(hostIdMsb, hostIdLsb);
                }
                finally {
                    hostIdIn.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hostId;
    }

    private static UUID conditionalCreateHostId(File hostIdFile, UUID newHostId, boolean[] wasCreated) throws IOException {
        UUID hostId = null;
        if (wasCreated != null || newHostId != null) {
            try {
                if (newHostId == null) {
                    newHostId = UUID.randomUUID();
                }
                DataOutputStream hostIdOut = new DataOutputStream(new FileOutputStream(hostIdFile));
                try {
                    hostIdOut.writeLong(newHostId.getMostSignificantBits());
                    hostIdOut.writeLong(newHostId.getLeastSignificantBits());
                }
                finally {
                    hostIdOut.close();
                }
                hostId = newHostId;
                if (wasCreated != null) {
                    wasCreated[0] = true;
                }
            }
            catch (IOException e) {
                Activator.logError("Failed to create a new host-id file.", e);
            }
        }
        return hostId;
    }

    private static void resetSites() {
        IPlatformConfiguration platformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        IPlatformConfiguration.ISitePolicy sitePolicy = platformConfiguration.createSitePolicy(1, new String[0]);
        IPlatformConfiguration.ISiteEntry[] sites = platformConfiguration.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IPlatformConfiguration.ISiteEntry oldSite = sites[i];
            IPlatformConfiguration.ISiteEntry newSite = platformConfiguration.createSiteEntry(oldSite.getURL(), sitePolicy);
            platformConfiguration.unconfigureSite(oldSite);
            platformConfiguration.configureSite(newSite);
            ++i;
        }
    }

    private static Set<String> getAllPlatformFeatures() throws IOException {
        IPlatformConfiguration platformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        IPlatformConfiguration tempConfiguration = ConfiguratorUtils.getPlatformConfiguration(null);
        IPlatformConfiguration.ISitePolicy sitePolicy = platformConfiguration.createSitePolicy(1, new String[0]);
        IPlatformConfiguration.ISiteEntry[] sites = platformConfiguration.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IPlatformConfiguration.ISiteEntry tempSite = platformConfiguration.createSiteEntry(sites[i].getURL(), sitePolicy);
            tempConfiguration.configureSite(tempSite);
            ++i;
        }
        HashSet<String> allFeatures = new HashSet<String>();
        IPlatformConfiguration.IFeatureEntry[] featureEntries = tempConfiguration.getConfiguredFeatureEntries();
        int i2 = 0;
        while (i2 < featureEntries.length) {
            IPlatformConfiguration.IFeatureEntry featureEntry = featureEntries[i2];
            allFeatures.add(featureEntry.getFeatureIdentifier());
            ++i2;
        }
        return allFeatures;
    }

    private static Set<String> getConfiguredFeatures() {
        IPlatformConfiguration platformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        HashSet<String> confFeatures = new HashSet<String>();
        IPlatformConfiguration.IFeatureEntry[] featureEntries = platformConfiguration.getConfiguredFeatureEntries();
        int i = 0;
        while (i < featureEntries.length) {
            IPlatformConfiguration.IFeatureEntry featureEntry = featureEntries[i];
            confFeatures.add(featureEntry.getFeatureIdentifier());
            ++i;
        }
        return confFeatures;
    }

    private static void enableFeatures(Set<String> featureIds) throws IOException {
        IPlatformConfiguration platformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        IPlatformConfiguration.ISiteEntry[] sites = platformConfiguration.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IPlatformConfiguration.ISiteEntry site = sites[i];
            IPlatformConfiguration.ISitePolicy policy = site.getSitePolicy();
            if (policy.getType() != 2) {
                policy = platformConfiguration.createSitePolicy(2, new String[0]);
                site.setSitePolicy(policy);
            }
            ++i;
        }
        IPlatformConfiguration.IFeatureEntry[] featureEntries = platformConfiguration.getConfiguredFeatureEntries();
        int i2 = 0;
        while (i2 < featureEntries.length) {
            IPlatformConfiguration.IFeatureEntry featureEntry = featureEntries[i2];
            if (!featureIds.contains(featureEntry.getFeatureIdentifier())) {
                platformConfiguration.unconfigureFeatureEntry(featureEntry);
            }
            ++i2;
        }
    }

    private static boolean areSitesManagedOnly() {
        IPlatformConfiguration platformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        IPlatformConfiguration.ISiteEntry[] sites = platformConfiguration.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IPlatformConfiguration.ISiteEntry site = sites[i];
            IPlatformConfiguration.ISitePolicy policy = site.getSitePolicy();
            if (policy.getType() != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static SecurityException hideException(SecurityException e) {
        e.setStackTrace(new StackTraceElement[0]);
        return e;
    }

    private static final class PropertyDoctypeInserterStream
    extends InputStream {
        private static final int DOCTYPE_STATUS_START = 0;
        private static final int DOCTYPE_STATUS_INSERTING = 1;
        private static final int DOCTYPE_STATUS_FINISHED = 2;
        private static final byte[] DOCTYPE_DECLARATION;
        private volatile InputStream in;
        private int doctypeStatus;
        private ByteArrayOutputStream outHead;
        private ByteArrayInputStream inHead;

        static {
            try {
                DOCTYPE_DECLARATION = "<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">".getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        protected PropertyDoctypeInserterStream(InputStream in) {
            this.in = in;
            this.doctypeStatus = 0;
            this.outHead = new ByteArrayOutputStream();
        }

        public int read() throws IOException {
            switch (this.doctypeStatus) {
                case 0: {
                    int b;
                    while ((b = this.in.read()) >= 0) {
                        this.outHead.write(b);
                        if (b != 10 && b != 13) continue;
                        this.outHead.write(DOCTYPE_DECLARATION);
                        this.outHead.write(10);
                        break;
                    }
                    this.inHead = new ByteArrayInputStream(this.outHead.toByteArray());
                    this.outHead = null;
                    this.doctypeStatus = 1;
                }
                case 1: {
                    int b = this.inHead.read();
                    if (b >= 0) {
                        return b;
                    }
                    this.doctypeStatus = 2;
                }
            }
            return this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.doctypeStatus == 2 ? this.in.read(b, off, len) : super.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public long skip(long n) throws IOException {
            return this.doctypeStatus == 2 ? this.in.skip(n) : super.skip(n);
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public void close() throws IOException {
            this.in.close();
            this.doctypeStatus = 2;
        }

        public synchronized void mark(int readlimit) {
            super.mark(readlimit);
        }

        public synchronized void reset() throws IOException {
            super.reset();
        }

        public boolean markSupported() {
            return super.markSupported();
        }
    }

    private static final class PropertyDoctypeRemoverStream
    extends OutputStream {
        private static final String STANDALONE_ATTRIBUTE = " standalone=\"no\"";
        private static final int STANDALONE_ATTRIBUTE_LEN = " standalone=\"no\"".length();
        private static final String DOCTYPE_DECLARATION = "<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">";
        private static final int DOCTYPE_DECLARATION_LEN = "<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">".length();
        private static final int DOCTYPE_STATUS_START = 0;
        private static final int DOCTYPE_STATUS_FINISHED = 1;
        private OutputStream out;
        private int doctypeStatus;
        private StringBuilder outHead;
        private int possibleStandalonePos;
        private int possibleDoctypePos;

        public PropertyDoctypeRemoverStream(OutputStream out) {
            this.out = out;
            this.doctypeStatus = 0;
            this.outHead = new StringBuilder();
            this.possibleStandalonePos = -1;
            this.possibleDoctypePos = -1;
        }

        public void write(int b) throws IOException {
            switch (this.doctypeStatus) {
                case 0: {
                    if (b == 32) {
                        this.possibleStandalonePos = this.outHead.length();
                    } else if (b == 60) {
                        this.possibleDoctypePos = this.outHead.length();
                    }
                    this.outHead.append((char)b);
                    int outHeadLength = this.outHead.length();
                    if (this.possibleStandalonePos >= 0 && outHeadLength - this.possibleStandalonePos == STANDALONE_ATTRIBUTE_LEN) {
                        if (this.outHead.substring(this.possibleStandalonePos, outHeadLength).equals(STANDALONE_ATTRIBUTE)) {
                            this.outHead.delete(this.possibleStandalonePos, outHeadLength);
                        }
                        this.possibleStandalonePos = -1;
                    }
                    if (this.possibleDoctypePos < 0 || outHeadLength - this.possibleDoctypePos != DOCTYPE_DECLARATION_LEN) break;
                    if (this.outHead.substring(this.possibleDoctypePos, outHeadLength).equals(DOCTYPE_DECLARATION)) {
                        this.outHead.delete(this.possibleDoctypePos, outHeadLength);
                        this.doctypeStatus = 1;
                        this.out.write(this.outHead.toString().getBytes("ascii"));
                    }
                    this.possibleDoctypePos = -1;
                    break;
                }
                case 1: {
                    this.out.write(b);
                }
            }
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.doctypeStatus == 1) {
                this.out.write(b, off, len);
            } else {
                if ((off | len | b.length - (len + off) | off + len) < 0) {
                    throw new IndexOutOfBoundsException();
                }
                int i = 0;
                while (i < len) {
                    this.write(b[off + i]);
                    ++i;
                }
            }
        }

        public void flush() throws IOException {
            if (this.doctypeStatus == 0) {
                this.doctypeStatus = 1;
                this.out.write(this.outHead.toString().getBytes("ascii"));
            }
            this.out.flush();
        }

        public void close() throws IOException {
            this.flush();
            this.out.close();
            this.doctypeStatus = 1;
        }
    }
}

