/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.services;

import java.util.HashMap;
import java.util.Map;
import net.jsdai.repo_edit.internal.util.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;

public class WeightedObjectsRegistryService {
    private static volatile WeightedObjectsRegistryService INSTANCE = null;
    private Map<String, WeightedObjectInfo> objectInfoMap = new HashMap<String, WeightedObjectInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WeightedObjectsRegistryService getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<WeightedObjectsRegistryService> clazz = WeightedObjectsRegistryService.class;
        synchronized (WeightedObjectsRegistryService.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new WeightedObjectsRegistryService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void disposeInstance() {
        if (INSTANCE == null) return;
        Class<WeightedObjectsRegistryService> clazz = WeightedObjectsRegistryService.class;
        synchronized (WeightedObjectsRegistryService.class) {
            if (INSTANCE == null) return;
            INSTANCE.dispose();
            INSTANCE = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private WeightedObjectsRegistryService() {
        IConfigurationElement[] weightedObjects;
        IConfigurationElement[] iConfigurationElementArray = weightedObjects = Platform.getExtensionRegistry().getConfigurationElementsFor("net.jsdai.repo_edit", "weightedObjects");
        int n = weightedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (configElement.getName().equals("weightedObject")) {
                try {
                    WeightedObjectInfo info = new WeightedObjectInfo(configElement);
                    WeightedObjectInfo oldInfo = this.objectInfoMap.get(info.getObjectId());
                    if (oldInfo == null || info.getWeight() > oldInfo.getWeight()) {
                        this.objectInfoMap.put(info.getObjectId(), info);
                    }
                }
                catch (NumberFormatException e) {
                    Utils.logWarning("Weighted object (id=" + configElement.getAttribute("id") + ") could not be instantiated.", e);
                }
                catch (InvalidRegistryObjectException e) {
                    Utils.logWarning("Weighted object (id=" + configElement.getAttribute("id") + ") could not be instantiated.", e);
                }
            }
            ++n2;
        }
    }

    public Object getObject(String objectId) {
        WeightedObjectInfo info = this.objectInfoMap.get(objectId);
        return info == null ? null : info.getObject();
    }

    public String getId(String objectId) {
        WeightedObjectInfo info = this.objectInfoMap.get(objectId);
        return info == null ? null : info.getId();
    }

    private void dispose() {
        this.objectInfoMap = null;
    }

    private static class WeightedObjectInfo {
        private final IConfigurationElement configElement;
        private final String id;
        private final String objectId;
        private final float weigth;

        public WeightedObjectInfo(IConfigurationElement configElement) throws NumberFormatException, InvalidRegistryObjectException {
            this.configElement = configElement;
            this.id = configElement.getAttribute("id");
            this.objectId = configElement.getAttribute("objectId");
            float w = 0.5f;
            String weightStr = configElement.getAttribute("weight");
            if (weightStr != null) {
                try {
                    w = Float.valueOf(weightStr).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.weigth = w;
        }

        public String getId() {
            return this.id;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public float getWeight() {
            return this.weigth;
        }

        public Object getObject() {
            Object obj = null;
            try {
                obj = this.configElement.createExecutableExtension("class");
            }
            catch (ClassCastException e) {
                Utils.logWarning("Weighted object (id=" + this.id + ") could not be instantiated.", e);
            }
            catch (CoreException e) {
                Utils.logWarning("Weighted object (id=" + this.id + ") could not be instantiated.", e);
            }
            return obj;
        }
    }
}

