/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.util;

import net.jsdai.repo_edit.util.IThrowingRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemorySafeRunnable<E extends Exception>
implements IThrowingRunnable<E> {
    public static final int DEFAULT_MEMORY_RESERVE_SIZE = 0x100000;
    private final int reservedMemory;
    private final IThrowingRunnable<E> runnable;
    private volatile byte[] buffer;

    public MemorySafeRunnable(IThrowingRunnable<E> runnable) {
        this(runnable, 0x100000);
    }

    public MemorySafeRunnable(IThrowingRunnable<E> runnable, int reservedMemory) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        if (reservedMemory <= 0) {
            throw new IllegalArgumentException();
        }
        this.reservedMemory = reservedMemory;
        this.runnable = runnable;
    }

    public int getReservedMemory() {
        return this.reservedMemory;
    }

    public IThrowingRunnable<E> getCode() {
        return this.runnable;
    }

    @Override
    public void run() throws E {
        this.buffer = new byte[this.reservedMemory];
        try {
            this.runnable.run();
        }
        finally {
            this.buffer = null;
        }
    }
}

