/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.actions;

import net.jsdai.ida_step.Activator;
import net.jsdai.ida_step.ApplicationActionBarAdvisor;
import net.jsdai.ida_step.EditorHistory;
import net.jsdai.ida_step.EditorHistoryItem;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.part.IOpenAction;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class ReopenEditorMenu
extends ContributionItem {
    private static final String RECENT_FILES = "RECENT_FILES";
    private IWorkbenchWindow window;
    private EditorHistory history;
    private boolean showSeparator;
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            ReopenEditorMenu.this.dirty = true;
        }
    };
    private static final int MAX_TEXT_LENGTH = 40;
    private static final int MAX_MNEMONIC_SIZE = 9;

    public ReopenEditorMenu(IWorkbenchWindow window, String id, boolean showSeparator) {
        super(id);
        this.window = window;
        this.showSeparator = showSeparator;
        this.history = Activator.getDefault().getEditorHistory();
    }

    private String calcText(int index, EditorHistoryItem item) {
        Path path;
        StringBuffer sb = new StringBuffer();
        int mnemonic = index + 1;
        sb.append(mnemonic);
        if (mnemonic <= 9) {
            sb.insert(sb.length() - String.valueOf(mnemonic).length(), '&');
        }
        sb.append(" ");
        String fileName = item.getName();
        String pathName = item.getToolTipText();
        if (pathName.equals(fileName)) {
            pathName = "";
        }
        if ((path = new Path(pathName)).segmentCount() > 1 && path.segment(path.segmentCount() - 1).equals(fileName)) {
            path = path.removeLastSegments(1);
            pathName = path.toString();
        }
        if (fileName.length() + pathName.length() <= 36) {
            sb.append(fileName);
            if (pathName.length() > 0) {
                sb.append("  [");
                sb.append(pathName);
                sb.append("]");
            }
        } else {
            int length = fileName.length();
            if (length > 40) {
                sb.append(fileName.substring(0, 37));
                sb.append("...");
            } else if (length > 33) {
                sb.append(fileName);
            } else {
                sb.append(fileName);
                int segmentCount = path.segmentCount();
                if (segmentCount > 0) {
                    int i;
                    String segment;
                    length += 7;
                    sb.append("  [");
                    for (i = 0; i < segmentCount && length < 40; length += segment.length() + 1, ++i) {
                        segment = path.segment(i);
                        if (length + segment.length() < 40) {
                            sb.append(segment);
                            sb.append('/');
                            continue;
                        }
                        if (i != 0) break;
                        sb.append(segment.substring(0, 40 - length));
                        length = 40;
                        break;
                    }
                    sb.append("...");
                    i = segmentCount - 1;
                    while (i > 0 && length < 40) {
                        segment = path.segment(i);
                        if (length + segment.length() >= 40) break;
                        sb.append('/');
                        sb.append(segment);
                        length += segment.length() + 1;
                        --i;
                    }
                    sb.append("]");
                }
            }
        }
        return TextProcessor.process((String)sb.toString(), (String)(String.valueOf(TextProcessor.getDefaultDelimiters()) + "[]"));
    }

    public void fill(final Menu menu, int startIndex) {
        int index = startIndex;
        if (this.window.getActivePage() == null || this.window.getActivePage().getPerspective() == null) {
            return;
        }
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        int itemsToShow = 4;
        Bundle workbenchUiBundle = Platform.getBundle((String)"org.eclipse.ui.workbench");
        if (workbenchUiBundle instanceof AbstractUIPlugin) {
            itemsToShow = ((AbstractUIPlugin)workbenchUiBundle).getPreferenceStore().getInt(RECENT_FILES);
        }
        if (itemsToShow == 0) {
            return;
        }
        EditorHistoryItem[] historyItems = this.history.getItems();
        int n = Math.min(itemsToShow, historyItems.length);
        if (n <= 0) {
            return;
        }
        if (this.showSeparator) {
            new MenuItem(menu, 2, index);
        }
        final int[] menuIndex = new int[]{++index};
        int i = 0;
        while (i < n) {
            final EditorHistoryItem item = historyItems[i];
            final int historyIndex = i++;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    String text = ReopenEditorMenu.this.calcText(historyIndex, item);
                    MenuItem mi = new MenuItem(menu, 8, menuIndex[0]);
                    menuIndex[0] = menuIndex[0] + 1;
                    mi.setText(text);
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ReopenEditorMenu.this.open(item);
                        }
                    });
                }

                public void handleException(Throwable e) {
                }
            });
        }
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    private void open(EditorHistoryItem item) {
        if (!item.isRestored()) {
            item.restoreState();
        }
        IEditorInput input = item.getInput();
        IEditorDescriptor desc = item.getDescriptor();
        if (input == null || desc == null) {
            String title = IdaStepMessages.ReopenEditorMenu_msgDialog_title;
            String msg = NLS.bind((String)IdaStepMessages.ReopenEditorMenu_msgDialog_message, (Object)item.getName());
            MessageDialog.openWarning((Shell)this.window.getShell(), (String)title, (String)msg);
            this.history.remove(item);
        } else {
            ActionFactory.IWorkbenchAction openAction = ApplicationActionBarAdvisor.getWeightedAction(this.window, "net.jsdai.product.openAction");
            if (openAction instanceof IOpenAction) {
                try {
                    ((IOpenAction)openAction).open(desc, input);
                }
                catch (PartInitException e) {
                    String title = IdaStepMessages.ReopenEditorMenu_msgDialog_title;
                    MessageDialog.openWarning((Shell)this.window.getShell(), (String)title, (String)e.getMessage());
                    this.history.remove(item);
                }
            }
        }
    }
}

