/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.jsdai.ida_step.Activator;
import net.jsdai.ida_step.installation.LicenseProperties;
import net.jsdai.repo_edit.services.LicenseeInfo;
import net.jsdai.repo_edit.services.LicensingService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

class HttpUtil {
    private static final String IDA_STEP_NET_SUBJECT = "CN=*.ida-step.net,O=ida-step.net,C=DE";
    private static final byte[] IDA_STEP_NET_CERTIFICATE;
    private static final SSLSocketFactory IDA_STEP_NET_SSL_SOCK_FACTORY;
    private static final String HTTP_CONNECTION_BASE_URL = "https://services.ida-step.net/";
    private static final String PRODUCT_VERSION_STRING;

    static {
        byte[] byArray = new byte[501];
        byArray[0] = 48;
        byArray[1] = -126;
        byArray[2] = 1;
        byArray[3] = -15;
        byArray[4] = 48;
        byArray[5] = -126;
        byArray[6] = 1;
        byArray[7] = 90;
        byArray[8] = 2;
        byArray[9] = 9;
        byArray[11] = -122;
        byArray[12] = -23;
        byArray[13] = -32;
        byArray[14] = 92;
        byArray[15] = -109;
        byArray[16] = -56;
        byArray[17] = -61;
        byArray[18] = -17;
        byArray[19] = 48;
        byArray[20] = 13;
        byArray[21] = 6;
        byArray[22] = 9;
        byArray[23] = 42;
        byArray[24] = -122;
        byArray[25] = 72;
        byArray[26] = -122;
        byArray[27] = -9;
        byArray[28] = 13;
        byArray[29] = 1;
        byArray[30] = 1;
        byArray[31] = 4;
        byArray[32] = 5;
        byArray[34] = 48;
        byArray[35] = 61;
        byArray[36] = 49;
        byArray[37] = 11;
        byArray[38] = 48;
        byArray[39] = 9;
        byArray[40] = 6;
        byArray[41] = 3;
        byArray[42] = 85;
        byArray[43] = 4;
        byArray[44] = 6;
        byArray[45] = 19;
        byArray[46] = 2;
        byArray[47] = 68;
        byArray[48] = 69;
        byArray[49] = 49;
        byArray[50] = 21;
        byArray[51] = 48;
        byArray[52] = 19;
        byArray[53] = 6;
        byArray[54] = 3;
        byArray[55] = 85;
        byArray[56] = 4;
        byArray[57] = 10;
        byArray[58] = 19;
        byArray[59] = 12;
        byArray[60] = 105;
        byArray[61] = 100;
        byArray[62] = 97;
        byArray[63] = 45;
        byArray[64] = 115;
        byArray[65] = 116;
        byArray[66] = 101;
        byArray[67] = 112;
        byArray[68] = 46;
        byArray[69] = 110;
        byArray[70] = 101;
        byArray[71] = 116;
        byArray[72] = 49;
        byArray[73] = 23;
        byArray[74] = 48;
        byArray[75] = 21;
        byArray[76] = 6;
        byArray[77] = 3;
        byArray[78] = 85;
        byArray[79] = 4;
        byArray[80] = 3;
        byArray[81] = 20;
        byArray[82] = 14;
        byArray[83] = 42;
        byArray[84] = 46;
        byArray[85] = 105;
        byArray[86] = 100;
        byArray[87] = 97;
        byArray[88] = 45;
        byArray[89] = 115;
        byArray[90] = 116;
        byArray[91] = 101;
        byArray[92] = 112;
        byArray[93] = 46;
        byArray[94] = 110;
        byArray[95] = 101;
        byArray[96] = 116;
        byArray[97] = 48;
        byArray[98] = 30;
        byArray[99] = 23;
        byArray[100] = 13;
        byArray[101] = 48;
        byArray[102] = 55;
        byArray[103] = 48;
        byArray[104] = 53;
        byArray[105] = 50;
        byArray[106] = 53;
        byArray[107] = 48;
        byArray[108] = 57;
        byArray[109] = 48;
        byArray[110] = 55;
        byArray[111] = 50;
        byArray[112] = 48;
        byArray[113] = 90;
        byArray[114] = 23;
        byArray[115] = 13;
        byArray[116] = 51;
        byArray[117] = 55;
        byArray[118] = 48;
        byArray[119] = 53;
        byArray[120] = 50;
        byArray[121] = 53;
        byArray[122] = 48;
        byArray[123] = 57;
        byArray[124] = 48;
        byArray[125] = 55;
        byArray[126] = 50;
        byArray[127] = 48;
        byArray[128] = 90;
        byArray[129] = 48;
        byArray[130] = 61;
        byArray[131] = 49;
        byArray[132] = 11;
        byArray[133] = 48;
        byArray[134] = 9;
        byArray[135] = 6;
        byArray[136] = 3;
        byArray[137] = 85;
        byArray[138] = 4;
        byArray[139] = 6;
        byArray[140] = 19;
        byArray[141] = 2;
        byArray[142] = 68;
        byArray[143] = 69;
        byArray[144] = 49;
        byArray[145] = 21;
        byArray[146] = 48;
        byArray[147] = 19;
        byArray[148] = 6;
        byArray[149] = 3;
        byArray[150] = 85;
        byArray[151] = 4;
        byArray[152] = 10;
        byArray[153] = 19;
        byArray[154] = 12;
        byArray[155] = 105;
        byArray[156] = 100;
        byArray[157] = 97;
        byArray[158] = 45;
        byArray[159] = 115;
        byArray[160] = 116;
        byArray[161] = 101;
        byArray[162] = 112;
        byArray[163] = 46;
        byArray[164] = 110;
        byArray[165] = 101;
        byArray[166] = 116;
        byArray[167] = 49;
        byArray[168] = 23;
        byArray[169] = 48;
        byArray[170] = 21;
        byArray[171] = 6;
        byArray[172] = 3;
        byArray[173] = 85;
        byArray[174] = 4;
        byArray[175] = 3;
        byArray[176] = 20;
        byArray[177] = 14;
        byArray[178] = 42;
        byArray[179] = 46;
        byArray[180] = 105;
        byArray[181] = 100;
        byArray[182] = 97;
        byArray[183] = 45;
        byArray[184] = 115;
        byArray[185] = 116;
        byArray[186] = 101;
        byArray[187] = 112;
        byArray[188] = 46;
        byArray[189] = 110;
        byArray[190] = 101;
        byArray[191] = 116;
        byArray[192] = 48;
        byArray[193] = -127;
        byArray[194] = -97;
        byArray[195] = 48;
        byArray[196] = 13;
        byArray[197] = 6;
        byArray[198] = 9;
        byArray[199] = 42;
        byArray[200] = -122;
        byArray[201] = 72;
        byArray[202] = -122;
        byArray[203] = -9;
        byArray[204] = 13;
        byArray[205] = 1;
        byArray[206] = 1;
        byArray[207] = 1;
        byArray[208] = 5;
        byArray[210] = 3;
        byArray[211] = -127;
        byArray[212] = -115;
        byArray[214] = 48;
        byArray[215] = -127;
        byArray[216] = -119;
        byArray[217] = 2;
        byArray[218] = -127;
        byArray[219] = -127;
        byArray[221] = -33;
        byArray[222] = 36;
        byArray[223] = 45;
        byArray[224] = -56;
        byArray[225] = 123;
        byArray[226] = -74;
        byArray[227] = 93;
        byArray[228] = -34;
        byArray[229] = -28;
        byArray[230] = -71;
        byArray[231] = -88;
        byArray[232] = -62;
        byArray[233] = 105;
        byArray[234] = 38;
        byArray[235] = 28;
        byArray[236] = 19;
        byArray[237] = 52;
        byArray[238] = -14;
        byArray[239] = -92;
        byArray[240] = 11;
        byArray[241] = 54;
        byArray[242] = -103;
        byArray[243] = 116;
        byArray[244] = -100;
        byArray[245] = -66;
        byArray[246] = -83;
        byArray[247] = -76;
        byArray[248] = 17;
        byArray[249] = 74;
        byArray[250] = 96;
        byArray[251] = 94;
        byArray[252] = -12;
        byArray[253] = -74;
        byArray[254] = -44;
        byArray[255] = 89;
        byArray[256] = -118;
        byArray[257] = 120;
        byArray[258] = -103;
        byArray[259] = 26;
        byArray[260] = -125;
        byArray[261] = 14;
        byArray[262] = 105;
        byArray[263] = 104;
        byArray[264] = 113;
        byArray[265] = -61;
        byArray[266] = -100;
        byArray[267] = 7;
        byArray[268] = 105;
        byArray[269] = -43;
        byArray[270] = -64;
        byArray[271] = -72;
        byArray[272] = 86;
        byArray[273] = 105;
        byArray[274] = -110;
        byArray[275] = -91;
        byArray[276] = 31;
        byArray[277] = 40;
        byArray[278] = -62;
        byArray[279] = 125;
        byArray[280] = 77;
        byArray[281] = 72;
        byArray[282] = 2;
        byArray[283] = 92;
        byArray[284] = 56;
        byArray[285] = -78;
        byArray[286] = -2;
        byArray[287] = 72;
        byArray[288] = 104;
        byArray[289] = 99;
        byArray[290] = 123;
        byArray[291] = -61;
        byArray[292] = -10;
        byArray[293] = -99;
        byArray[294] = 112;
        byArray[295] = -90;
        byArray[296] = 22;
        byArray[297] = 88;
        byArray[298] = -80;
        byArray[299] = -82;
        byArray[300] = 5;
        byArray[301] = -122;
        byArray[302] = 117;
        byArray[303] = -54;
        byArray[304] = -75;
        byArray[305] = 92;
        byArray[306] = 111;
        byArray[307] = -27;
        byArray[308] = -75;
        byArray[309] = 53;
        byArray[310] = -30;
        byArray[311] = -120;
        byArray[312] = 70;
        byArray[313] = 52;
        byArray[314] = -95;
        byArray[315] = 121;
        byArray[316] = 38;
        byArray[317] = 39;
        byArray[318] = 40;
        byArray[319] = 25;
        byArray[320] = 107;
        byArray[321] = 77;
        byArray[322] = 90;
        byArray[323] = 92;
        byArray[324] = -126;
        byArray[325] = 75;
        byArray[326] = -51;
        byArray[327] = -99;
        byArray[328] = -43;
        byArray[329] = 19;
        byArray[330] = -72;
        byArray[331] = -83;
        byArray[332] = -32;
        byArray[333] = -51;
        byArray[334] = 96;
        byArray[335] = 12;
        byArray[336] = 7;
        byArray[337] = -44;
        byArray[338] = 95;
        byArray[339] = 27;
        byArray[340] = 39;
        byArray[341] = -70;
        byArray[342] = 73;
        byArray[343] = -101;
        byArray[344] = -5;
        byArray[345] = 22;
        byArray[346] = -72;
        byArray[347] = 105;
        byArray[348] = 105;
        byArray[349] = 2;
        byArray[350] = 3;
        byArray[351] = 1;
        byArray[353] = 1;
        byArray[354] = 48;
        byArray[355] = 13;
        byArray[356] = 6;
        byArray[357] = 9;
        byArray[358] = 42;
        byArray[359] = -122;
        byArray[360] = 72;
        byArray[361] = -122;
        byArray[362] = -9;
        byArray[363] = 13;
        byArray[364] = 1;
        byArray[365] = 1;
        byArray[366] = 4;
        byArray[367] = 5;
        byArray[369] = 3;
        byArray[370] = -127;
        byArray[371] = -127;
        byArray[373] = 54;
        byArray[374] = -8;
        byArray[375] = 63;
        byArray[376] = -83;
        byArray[377] = 97;
        byArray[378] = 95;
        byArray[379] = 51;
        byArray[380] = 47;
        byArray[381] = -37;
        byArray[382] = 84;
        byArray[383] = 60;
        byArray[384] = -60;
        byArray[385] = 18;
        byArray[386] = -47;
        byArray[387] = 39;
        byArray[388] = 108;
        byArray[389] = -108;
        byArray[390] = 108;
        byArray[391] = -116;
        byArray[392] = -43;
        byArray[393] = -71;
        byArray[394] = -95;
        byArray[395] = 118;
        byArray[396] = 34;
        byArray[397] = -103;
        byArray[398] = -21;
        byArray[399] = 24;
        byArray[400] = 42;
        byArray[401] = 69;
        byArray[402] = 124;
        byArray[403] = -82;
        byArray[404] = 9;
        byArray[405] = -93;
        byArray[406] = -14;
        byArray[407] = 95;
        byArray[408] = -26;
        byArray[409] = 93;
        byArray[410] = 113;
        byArray[411] = -20;
        byArray[412] = -14;
        byArray[413] = 20;
        byArray[414] = -9;
        byArray[415] = -48;
        byArray[416] = -84;
        byArray[417] = -110;
        byArray[418] = -75;
        byArray[419] = 61;
        byArray[420] = -85;
        byArray[421] = -100;
        byArray[422] = -115;
        byArray[423] = -108;
        byArray[424] = 35;
        byArray[425] = -22;
        byArray[426] = 118;
        byArray[427] = 117;
        byArray[428] = 82;
        byArray[429] = -51;
        byArray[430] = 31;
        byArray[431] = -116;
        byArray[432] = 73;
        byArray[433] = 50;
        byArray[434] = -52;
        byArray[435] = -39;
        byArray[436] = -8;
        byArray[437] = 100;
        byArray[438] = -50;
        byArray[439] = 93;
        byArray[440] = -52;
        byArray[441] = 50;
        byArray[442] = 122;
        byArray[443] = 96;
        byArray[444] = -42;
        byArray[445] = -90;
        byArray[446] = -9;
        byArray[447] = 73;
        byArray[448] = -98;
        byArray[449] = 28;
        byArray[450] = -104;
        byArray[451] = 41;
        byArray[452] = 12;
        byArray[453] = 58;
        byArray[454] = 42;
        byArray[455] = 120;
        byArray[456] = -16;
        byArray[457] = 8;
        byArray[458] = 102;
        byArray[459] = 120;
        byArray[460] = -6;
        byArray[461] = 113;
        byArray[462] = 113;
        byArray[463] = -125;
        byArray[464] = 59;
        byArray[465] = -7;
        byArray[466] = 26;
        byArray[467] = 79;
        byArray[468] = -3;
        byArray[469] = 46;
        byArray[470] = -51;
        byArray[471] = -59;
        byArray[472] = -110;
        byArray[473] = -73;
        byArray[474] = 118;
        byArray[475] = -75;
        byArray[476] = 60;
        byArray[477] = 101;
        byArray[478] = -45;
        byArray[479] = 54;
        byArray[480] = -53;
        byArray[481] = 19;
        byArray[482] = -82;
        byArray[483] = -120;
        byArray[484] = -115;
        byArray[485] = -113;
        byArray[486] = 49;
        byArray[487] = 66;
        byArray[488] = 48;
        byArray[489] = 78;
        byArray[490] = 60;
        byArray[491] = -61;
        byArray[492] = -72;
        byArray[493] = -88;
        byArray[494] = -43;
        byArray[495] = -19;
        byArray[496] = -10;
        byArray[497] = -86;
        byArray[498] = -27;
        byArray[499] = 2;
        byArray[500] = 64;
        IDA_STEP_NET_CERTIFICATE = byArray;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            X509TrustManager defaulTrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new IdaStepNetTrustManager(defaulTrustManager)}, null);
            IDA_STEP_NET_SSL_SOCK_FACTORY = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        Bundle productBundle = Platform.getProduct().getDefiningBundle();
        PRODUCT_VERSION_STRING = (String)productBundle.getHeaders().get("Bundle-Version");
    }

    private HttpUtil() {
    }

    static void configureConnection() {
        try {
            Bundle orgEclipseCoreNetBundle = Platform.getBundle((String)"org.eclipse.core.net");
            if (orgEclipseCoreNetBundle != null) {
                orgEclipseCoreNetBundle.start();
            }
        }
        catch (BundleException e) {
            Activator.logError("Failed starting org.eclipse.core.net bundle", e);
        }
        try {
            Bundle orgEclipseUpdateCoreBundle = Platform.getBundle((String)"org.eclipse.update.core");
            if (orgEclipseUpdateCoreBundle != null) {
                orgEclipseUpdateCoreBundle.start();
            }
        }
        catch (BundleException e) {
            Activator.logError("Failed starting org.eclipse.update.core", e);
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(IDA_STEP_NET_SSL_SOCK_FACTORY);
        Authenticator.setDefault(new IdaStepAuthenticator());
        String httpProxyHost = System.getProperty("http.proxyHost");
        if (httpProxyHost != null) {
            System.setProperty("https.proxyHost", httpProxyHost);
        } else {
            System.getProperties().remove("https.proxyHost");
        }
        String httpProxyPort = System.getProperty("http.proxyPort");
        if (httpProxyPort != null) {
            System.setProperty("https.proxyPort", httpProxyPort);
        } else {
            System.getProperties().remove("https.proxyPort");
        }
    }

    static HttpURLConnection doRequest(String licenseNum, String actionSegment, IProgressMonitor monitor) throws IOException, InterruptedException {
        LicenseeInfo licenseeInfo = LicensingService.getInstance().getLicenseeInfoBytes(PRODUCT_VERSION_STRING, licenseNum);
        byte[] licenseeInfoBytes = licenseeInfo.getInfoBytes();
        monitor.worked(1);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (licenseeInfo.getHostId() == null) {
            throw new IOException("hostid.exception");
        }
        String hostIdStr = licenseeInfo.getHostId().toString();
        URL connectionUrl = new URL(HTTP_CONNECTION_BASE_URL + actionSegment + hostIdStr);
        HttpsURLConnection connection = (HttpsURLConnection)connectionUrl.openConnection();
        connection.setAllowUserInteraction(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/vnd.lksoft.licensee-info");
        connection.setRequestProperty("Content-Length", Integer.toString(licenseeInfoBytes.length));
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        monitor.worked(1);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        OutputStream connectionOut = connection.getOutputStream();
        connectionOut.write(licenseeInfoBytes);
        connectionOut.close();
        return connection;
    }

    static InputStream getCertificateStream() {
        return new ByteArrayInputStream(IDA_STEP_NET_CERTIFICATE);
    }

    static /* synthetic */ byte[] access$0() {
        return IDA_STEP_NET_CERTIFICATE;
    }

    private static class IdaStepAuthenticator
    extends Authenticator {
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() == Authenticator.RequestorType.SERVER) {
                if ("services.ida-step.net".equals(this.getRequestingHost())) {
                    try {
                        LicenseProperties licenseProperties = LicenseProperties.load();
                        return new PasswordAuthentication(licenseProperties.getHostId(), licenseProperties.getAccessPassword().toCharArray());
                    }
                    catch (IOException licenseProperties) {
                    }
                    catch (GeneralSecurityException licenseProperties) {}
                }
            } else {
                String user = System.getProperty("http.proxyUser");
                String password = System.getProperty("http.proxyPassword");
                if (user != null && password != null) {
                    return new PasswordAuthentication(user, password.toCharArray());
                }
            }
            return super.getPasswordAuthentication();
        }
    }

    private static class IdaStepNetTrustManager
    implements X509TrustManager {
        private final X509TrustManager defaulTrustManager;

        public IdaStepNetTrustManager(X509TrustManager defaulTrustManager) {
            this.defaulTrustManager = defaulTrustManager;
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.defaulTrustManager.checkClientTrusted(chain, authType);
        }

        /*
         * Unable to fully structure code
         */
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            block6: {
                if (chain.length == 1 && chain[0].getSubjectX500Principal().getName().equals("CN=*.ida-step.net,O=ida-step.net,C=DE")) {
                    serverCertificate = chain[0].getEncoded();
                    if (Arrays.equals(HttpUtil.access$0(), serverCertificate)) {
                        return;
                    }
                }
                try {
                    this.defaulTrustManager.checkServerTrusted(chain, authType);
                    break block6;
                }
                catch (CertificateException e) {
                    chainNames = new StringBuilder();
                    chainNames.append(e.getMessage());
                    chainNames.append("\nThe chain of certificates: ");
                    first = true;
                    i = 0;
                    ** while (i < chain.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (!first) {
                        chainNames.append(" -> ");
                    }
                    chainNames.append(chain[i].getSubjectX500Principal().getName());
                    first = false;
                    ++i;
                    continue;
                }
lbl25:
                // 1 sources

                throw new CertificateException(chainNames.toString(), e);
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.defaulTrustManager.getAcceptedIssuers();
        }
    }
}

