/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import net.jsdai.ida_step.installation.HttpUtil;
import org.eclipse.osgi.service.security.TrustEngine;

public class IdaStepTrustEngine
extends TrustEngine {
    private volatile Certificate certificate;

    protected String doAddTrustAnchor(Certificate anchor, String alias) throws IOException, GeneralSecurityException {
        throw new UnsupportedOperationException();
    }

    protected void doRemoveTrustAnchor(Certificate anchor) throws IOException, GeneralSecurityException {
        throw new UnsupportedOperationException();
    }

    protected void doRemoveTrustAnchor(String alias) throws IOException, GeneralSecurityException {
        throw new UnsupportedOperationException();
    }

    public Certificate findTrustAnchor(Certificate[] chain) throws IOException {
        try {
            if (chain != null && chain.length == 1 && chain[0].equals(this.getCertificate())) {
                return this.getCertificate();
            }
            return null;
        }
        catch (CertificateException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public String[] getAliases() throws IOException, GeneralSecurityException {
        return new String[]{"ida-step.net"};
    }

    public String getName() {
        return "ida-step.trust.engine";
    }

    public Certificate getTrustAnchor(String alias) throws IOException, GeneralSecurityException {
        if ("ida-step.net".equals(alias)) {
            return this.getCertificate();
        }
        return null;
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate getCertificate() throws IOException, CertificateException {
        if (this.certificate == null) {
            IdaStepTrustEngine idaStepTrustEngine = this;
            synchronized (idaStepTrustEngine) {
                if (this.certificate == null) {
                    InputStream certificateIn = HttpUtil.getCertificateStream();
                    try {
                        this.certificate = CertificateFactory.getInstance("X509").generateCertificate(certificateIn);
                    }
                    finally {
                        certificateIn.close();
                    }
                }
            }
        }
        return this.certificate;
    }
}

