/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.part.FileInputField;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class OfflineRegInFilesPage
extends WizardPage {
    private static final String REGISTRATION_PAGE_CONTEXT_ID = "net.jsdai.ida_step.registration_page_context_4_page";
    private FileInputField installationFileIn;
    private FileInputField licFileIn;
    private Label offline1stStepMessage;
    private Group offline1stStepMsgGroup;

    public OfflineRegInFilesPage() {
        super("offlineRegInFilesPage");
        this.setTitle(IdaStepMessages.OfflineRegInFilesPage_title);
        this.setDescription(IdaStepMessages.OfflineRegInFilesPage_description);
    }

    public void createControl(Composite parent) {
        try {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            this.createSteps2and3Group(composite);
            this.updateFileInputState();
            this.setControl((Control)composite);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createSteps2and3Group(Composite composite) throws IOException {
        Composite regMethodComposite = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        regMethodComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        regMethodComposite.setLayout((Layout)layout);
        int prefControlWidth = this.getPrefControlWidth();
        int labelWidth = prefControlWidth - 30;
        this.offline1stStepMsgGroup = new Group(regMethodComposite, 0);
        this.offline1stStepMsgGroup.setText(IdaStepMessages.OfflineRegInFilesPage_1stStepGroup_text);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.offline1stStepMsgGroup.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.offline1stStepMsgGroup.setLayoutData((Object)gridData);
        Label messageImage = new Label((Composite)this.offline1stStepMsgGroup, 0);
        messageImage.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
        gridData = new GridData();
        messageImage.setLayoutData((Object)gridData);
        this.offline1stStepMessage = new Label((Composite)this.offline1stStepMsgGroup, 64);
        this.offline1stStepMessage.setText("\n");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = labelWidth;
        this.offline1stStepMessage.setLayoutData((Object)gridData);
        Group offline2ndStepGrp = new Group(regMethodComposite, 0);
        offline2ndStepGrp.setText(IdaStepMessages.OfflineRegInFilesPage_2ndStepGroup_text);
        layout = new GridLayout();
        layout.numColumns = 1;
        offline2ndStepGrp.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = labelWidth;
        gridData.horizontalIndent = 0;
        offline2ndStepGrp.setLayoutData((Object)gridData);
        Label offline2ndStepRegLabel2 = new Label((Composite)offline2ndStepGrp, 64);
        offline2ndStepRegLabel2.setText(IdaStepMessages.OfflineRegInFilesPage_2ndStepRegLabel_text);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = labelWidth;
        offline2ndStepRegLabel2.setLayoutData((Object)gridData);
        Group offline3rdStepGrp = new Group(regMethodComposite, 0);
        offline3rdStepGrp.setText(IdaStepMessages.OfflineRegInFilesPage_3rdStepGroup_text);
        layout = new GridLayout();
        layout.numColumns = 1;
        offline3rdStepGrp.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = labelWidth;
        offline3rdStepGrp.setLayoutData((Object)gridData);
        Label offline3rdStepRegLabel = new Label((Composite)offline3rdStepGrp, 64);
        offline3rdStepRegLabel.setText(String.valueOf(IdaStepMessages.OfflineRegInFilesPage_offline3rdStepRegLabel_text) + "(IDA-STEP_xxxxx-xxxxx-xxxxx-xxxxx-xxxxx.lic).");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = labelWidth;
        offline3rdStepRegLabel.setLayoutData((Object)gridData);
        this.licFileIn = this.createFileInputField((Composite)offline3rdStepGrp, IdaStepMessages.OfflineRegInFilesPage_licFileIn_title, 4096, "*.lic", "License Files (*.lic)");
        gridData = (GridData)this.licFileIn.getControl().getLayoutData();
        Label offlineInstallationLabel = new Label((Composite)offline3rdStepGrp, 64);
        offlineInstallationLabel.setText(String.valueOf(IdaStepMessages.OfflineRegInFilesPage_offlineInstallationLabel_text) + "(IDA-STEP_xxxxx-xxxxx-xxxxx-xxxxx-xxxxx_install_vYYYYMMDD.zip).");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = labelWidth;
        offlineInstallationLabel.setLayoutData((Object)gridData);
        this.installationFileIn = this.createFileInputField((Composite)offline3rdStepGrp, IdaStepMessages.OfflineRegInFilesPage_installationFileIn_title, 4096, "*.zip", "ZIP Files (*.zip)");
        gridData = (GridData)this.installationFileIn.getControl().getLayoutData();
        gridData = (GridData)regMethodComposite.getLayoutData();
        gridData.heightHint = regMethodComposite.computeSize((int)prefControlWidth, (int)-1).y;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, REGISTRATION_PAGE_CONTEXT_ID);
    }

    File getOfflineLicenseFile() {
        return this.licFileIn != null ? this.licFileIn.getFileForSave() : null;
    }

    File getOfflineInstallationFile() {
        return this.installationFileIn != null ? this.installationFileIn.getFileForSave() : null;
    }

    void set1stStepMessage(String message) {
        GridData gridData = (GridData)this.offline1stStepMsgGroup.getLayoutData();
        if (message != null) {
            this.offline1stStepMessage.setText(message);
            gridData.exclude = false;
            this.offline1stStepMsgGroup.setVisible(true);
        } else {
            gridData.exclude = true;
            this.offline1stStepMsgGroup.setVisible(false);
        }
        ((Composite)this.getControl()).layout(true, true);
    }

    private int getPrefControlWidth() {
        Control registrationPageControl;
        IWizardPage registrationPage = this.getWizard().getPage("registrationPage");
        if (registrationPage != null && (registrationPageControl = registrationPage.getControl()) != null) {
            return registrationPageControl.computeSize((int)-1, (int)-1).x;
        }
        return this.convertHorizontalDLUsToPixels(275);
    }

    private FileInputField createFileInputField(Composite parent, String fileInputText, int fileInputDialogStyle, String fileInputExtension, String fileInputExtName) {
        FileInputField fileInputField = new FileInputField(fileInputText, fileInputDialogStyle, new String[]{fileInputExtension}, new String[]{fileInputExtName}, "");
        fileInputField.createControl(parent);
        fileInputField.addListener(new FileInputField.IFileInputFieldListener(){

            public void valueChanged(FileInputField field) {
                OfflineRegInFilesPage.this.updateFileInputState();
                OfflineRegInFilesPage.this.getContainer().updateButtons();
            }
        });
        return fileInputField;
    }

    void updateFileInputState() {
        if (!this.updateFileInputState(this.licFileIn, IdaStepMessages.OfflineRegInFilesPage_licensefileNameMissing_title, IdaStepMessages.OfflineRegInFilesPage_licensefileNameMissing_message, false)) {
            return;
        }
        this.updateFileInputState(this.installationFileIn, IdaStepMessages.OfflineRegInFilesPage_InstallationPackageFileNameMissing_title, IdaStepMessages.OfflineRegInFilesPage_InstallationPackageFileNameMissing_message, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateFileInputState(FileInputField field, String missingMessage, String unreadableMessage, boolean installationFile) {
        String file = field.getFile();
        if (file == null || file.length() == 0) {
            this.setMessage(missingMessage, 3);
            return false;
        }
        if (!new File(file).canRead()) {
            this.setMessage(unreadableMessage, 3);
            return false;
        }
        if (installationFile) {
            try {
                ZipFile zipFile = new ZipFile(field.getFile());
                try {
                    if (zipFile.getEntry("site.xml") == null) {
                        this.setMessage(IdaStepMessages.OfflineRegInFilesPage_zipFileMessage, 3);
                        return false;
                    }
                }
                finally {
                    zipFile.close();
                }
            }
            catch (IOException e) {
                this.setMessage(IdaStepMessages.OfflineRegInFilesPage_invalidOfflineInstallationPackageFileException, 3);
                return false;
            }
        }
        this.setMessage(null);
        return true;
    }
}

