/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.File;
import java.io.IOException;
import net.jsdai.ida_step.installation.RegistrationWizard;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.part.FileInputField;
import net.jsdai.repo_edit.services.LicensingService;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class OfflineRegOutFilesPage
extends WizardPage
implements IPageChangedListener {
    private static final String HTML_FORMAT = "(IDA-STEP_xxxxx-xxxxx-xxxxx-xxxxx-xxxxx.html)";
    private static final String REGISTRATION_PAGE_CONTEXT_ID = "net.jsdai.ida_step.registration_page_context_3_page";
    private Button offline1stStepReg;
    private Button skipOffline1stStep;
    private FileInputField htmlFileInput;
    private String currentLicenseNum;

    public OfflineRegOutFilesPage() {
        super("offlineRegOutFilesPage");
        this.setTitle(IdaStepMessages.OfflineRegInFilesPage_title);
        this.setDescription(IdaStepMessages.OfflineRegInFilesPage_description);
    }

    public void createControl(Composite parent) {
        try {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            this.createStep1Group(composite);
            this.setControl((Control)composite);
            this.currentLicenseNum = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createStep1Group(Composite composite) throws IOException {
        boolean skip1stStepDefault = ((RegistrationWizard)this.getWizard()).registrationStatus.isLicenseValid() || LicensingService.getInstance().loadOfflineLicense() != null;
        Composite regMethodComposite = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        regMethodComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        regMethodComposite.setLayout((Layout)layout);
        this.offline1stStepReg = new Button(regMethodComposite, 16);
        this.offline1stStepReg.setText(IdaStepMessages.OfflineRegOutFilesPage_offline1stStepReg_text);
        gridData = new GridData();
        this.offline1stStepReg.setLayoutData((Object)gridData);
        if (!skip1stStepDefault) {
            this.offline1stStepReg.setSelection(true);
        }
        Button tempButton = new Button(regMethodComposite, 16);
        int indent = tempButton.computeSize((int)-1, (int)-1).x;
        tempButton.dispose();
        int prefControlWidth = this.getPrefControlWidth();
        int labelWidth = prefControlWidth - indent - 20;
        Label offline1stStepRegLabel = new Label(regMethodComposite, 64);
        offline1stStepRegLabel.setText(NLS.bind((String)IdaStepMessages.OfflineRegOutFilesPage_offline1stStepRegLabel_text, (Object)HTML_FORMAT));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = labelWidth;
        gridData.horizontalIndent = indent;
        offline1stStepRegLabel.setLayoutData((Object)gridData);
        this.offline1stStepReg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.widget).getSelection();
                OfflineRegOutFilesPage.setEnabled(OfflineRegOutFilesPage.this.htmlFileInput, selected);
                if (selected) {
                    OfflineRegOutFilesPage.this.updateFileInputState(OfflineRegOutFilesPage.this.htmlFileInput);
                } else {
                    OfflineRegOutFilesPage.this.setMessage(null);
                }
                OfflineRegOutFilesPage.this.getContainer().updateButtons();
            }
        });
        this.htmlFileInput = this.createFileInputField(regMethodComposite, IdaStepMessages.OfflineRegOutFilesPage_htmlFileInput_text, 8192, "*.html", "HTML Files (*.html)");
        gridData = (GridData)this.htmlFileInput.getControl().getLayoutData();
        gridData.horizontalIndent = indent;
        this.skipOffline1stStep = new Button(regMethodComposite, 16);
        this.skipOffline1stStep.setText(IdaStepMessages.OfflineRegOutFilesPage_skipOffline1stStep_text);
        gridData = new GridData();
        this.skipOffline1stStep.setLayoutData((Object)gridData);
        if (skip1stStepDefault) {
            this.skipOffline1stStep.setSelection(true);
            OfflineRegOutFilesPage.setEnabled(this.htmlFileInput, false);
        }
        gridData = (GridData)regMethodComposite.getLayoutData();
        gridData.heightHint = regMethodComposite.computeSize((int)prefControlWidth, (int)-1).y;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, REGISTRATION_PAGE_CONTEXT_ID);
    }

    public void pageChanged(PageChangedEvent event) {
        if (event.getSelectedPage() == this) {
            this.updateFileInput();
        }
    }

    boolean isOffline1stStepReg() {
        return this.offline1stStepReg != null ? this.offline1stStepReg.getSelection() : true;
    }

    File getOffline1stStepRegFile() {
        return this.htmlFileInput != null ? this.htmlFileInput.getFileForSave() : null;
    }

    private int getPrefControlWidth() {
        Control registrationPageControl;
        IWizardPage registrationPage = this.getWizard().getPage("registrationPage");
        if (registrationPage != null && (registrationPageControl = registrationPage.getControl()) != null) {
            return registrationPageControl.computeSize((int)-1, (int)-1).x;
        }
        return this.convertHorizontalDLUsToPixels(275);
    }

    private FileInputField createFileInputField(Composite parent, String fileInputText, int fileInputDialogStyle, String fileInputExtension, String fileInputExtName) {
        FileInputField fileInputField = new FileInputField(fileInputText, fileInputDialogStyle, new String[]{fileInputExtension}, new String[]{fileInputExtName}, "");
        fileInputField.createControl(parent);
        fileInputField.addListener(new FileInputField.IFileInputFieldListener(){

            public void valueChanged(FileInputField field) {
                OfflineRegOutFilesPage.this.updateFileInputState(field);
                OfflineRegOutFilesPage.this.getContainer().updateButtons();
            }
        });
        this.updateFileInputState(fileInputField);
        return fileInputField;
    }

    private static void setEnabled(FileInputField inputField, boolean enabled) {
        Control[] children = ((Composite)inputField.getControl()).getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            control.setEnabled(enabled);
            ++i;
        }
    }

    void updateFileInputState(FileInputField field) {
        String file = field.getFile();
        if (file == null || file.length() == 0) {
            this.setMessage(IdaStepMessages.OfflineRegOutFilesPage_fileNameMissing_message, 3);
            return;
        }
        if (field.getFileForSave() == null) {
            this.setMessage(IdaStepMessages.OfflineRegOutFilesPage_fileCanNotBeSaved_message, 3);
            return;
        }
        this.setMessage(null);
    }

    private void updateFileInput() {
        RegistrationWizard registrationWizard = (RegistrationWizard)this.getWizard();
        String newLicenseNum = registrationWizard.getLicenseNum();
        if (newLicenseNum == null && newLicenseNum != this.currentLicenseNum || newLicenseNum != null && !newLicenseNum.equals(this.currentLicenseNum)) {
            this.currentLicenseNum = newLicenseNum;
            if (this.currentLicenseNum != null) {
                this.htmlFileInput.setFile(new File(System.getProperty("user.home"), "IDA-STEP_" + this.currentLicenseNum + ".html").getAbsolutePath());
            } else {
                this.htmlFileInput.setFile("");
            }
            if (this.isOffline1stStepReg()) {
                this.updateFileInputState(this.htmlFileInput);
            } else {
                this.setMessage(null);
            }
            this.getContainer().updateButtons();
        }
    }
}

