/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;
import net.jsdai.ida_step.installation.ActivationRunnable;
import net.jsdai.ida_step.installation.IUpdateManagerUI2;
import net.jsdai.ida_step.installation.LicenseProperties;
import net.jsdai.ida_step.installation.OfflineInstallationRunnable;
import net.jsdai.ida_step.installation.OfflineRegInFilesPage;
import net.jsdai.ida_step.installation.OfflineRegOutFilesPage;
import net.jsdai.ida_step.installation.RegistrationMethodPage;
import net.jsdai.ida_step.installation.RegistrationPage;
import net.jsdai.ida_step.installation.RegistrationStatus;
import net.jsdai.ida_step.l10n.CommonStringsMessages;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.services.LicenseeInfo;
import net.jsdai.repo_edit.services.LicensingService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.search.UpdateSearchRequest;
import org.osgi.framework.Bundle;

public class RegistrationWizard
extends Wizard
implements IPageChangingListener {
    private static final String PRODUCT_VERSION_STRING;
    private static final Set<String> VISIBLE_LIC_INFO_PROPS;
    final RegistrationStatus registrationStatus;
    private final IUpdateManagerUI2 updateManagerUI2;
    private UpdateSearchRequest searchRequest;
    private RegistrationPage registrationPage;
    private RegistrationMethodPage registrationMethodPage;
    private OfflineRegOutFilesPage offlineRegOutFilesPage;
    private OfflineRegInFilesPage offlineRegInFilesPage;

    static {
        Bundle productBundle = Platform.getProduct().getDefiningBundle();
        PRODUCT_VERSION_STRING = (String)productBundle.getHeaders().get("Bundle-Version");
        LinkedHashSet<String> visibleLicInfoProps = new LinkedHashSet<String>();
        visibleLicInfoProps.add("user-name");
        visibleLicInfoProps.add("os-name");
        visibleLicInfoProps.add("os-arch");
        visibleLicInfoProps.add("os-version");
        visibleLicInfoProps.add("license-num");
        VISIBLE_LIC_INFO_PROPS = Collections.unmodifiableSet(visibleLicInfoProps);
    }

    public RegistrationWizard(RegistrationStatus registrationStatus) {
        try {
            this.updateManagerUI2 = (IUpdateManagerUI2)Platform.getAdapterManager().loadAdapter(IUpdateManagerUI2.class, "org.eclipse.update.ui.accessor.UpdateManagerUI2");
            this.searchRequest = this.updateManagerUI2.newSearchRequest();
            this.setWindowTitle(CommonStringsMessages.register);
            this.registrationPage = new RegistrationPage();
            this.registrationMethodPage = new RegistrationMethodPage();
            this.offlineRegOutFilesPage = new OfflineRegOutFilesPage();
            this.offlineRegInFilesPage = new OfflineRegInFilesPage();
            if (registrationStatus == null) {
                registrationStatus = new RegistrationStatus();
                registrationStatus.updateStatus();
            }
            this.registrationStatus = registrationStatus;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose() {
        this.removePageChangeListeners();
        super.dispose();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.registrationPage);
        this.addPage((IWizardPage)this.registrationMethodPage);
        this.addPage((IWizardPage)this.offlineRegOutFilesPage);
        this.addPage((IWizardPage)this.offlineRegInFilesPage);
    }

    public void setContainer(IWizardContainer wizardContainer) {
        this.removePageChangeListeners();
        super.setContainer(wizardContainer);
        this.addPageChangeListeners();
    }

    public boolean performFinish() {
        IRunnableWithProgress finishRunnable = null;
        boolean offline = this.registrationMethodPage.isOfflineMethod();
        if (offline) {
            finishRunnable = new IRunnableWithProgress(){
                private File licFile;
                {
                    this.licFile = RegistrationWizard.this.offlineRegInFilesPage.getOfflineLicenseFile();
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        RegistrationWizard.this.doOffline2ndStepReg(monitor, this.licFile);
                        RegistrationWizard.this.getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                RegistrationWizard.this.updateManagerUI2.runInstallWizardOperation(RegistrationWizard.this.searchRequest, new OfflineInstallationRunnable(RegistrationWizard.this.offlineRegInFilesPage.getOfflineInstallationFile()));
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (GeneralSecurityException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            return this.run(finishRunnable);
        }
        ActivationRunnable activationRunnable = new ActivationRunnable((Shell)this.getShell().getParent(), this.registrationPage.isNewLicense(), false, this.registrationPage.getLicenseNum());
        this.updateManagerUI2.runInstallWizardOperation(this.searchRequest, activationRunnable);
        return true;
    }

    public boolean canFinish() {
        if (this.getLicenseNum() == null) {
            return this.registrationPage.isPageComplete();
        }
        boolean canFinish = super.canFinish();
        if (canFinish) {
            canFinish = this.areRegistrationPagesComplete();
        }
        return canFinish;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handlePageChanging(PageChangingEvent event) {
        if (event.getTargetPage() != this.offlineRegInFilesPage) return;
        if (event.getCurrentPage() == this.offlineRegOutFilesPage && this.offlineRegOutFilesPage.isOffline1stStepReg()) {
            final File regFile = this.offlineRegOutFilesPage.getOffline1stStepRegFile();
            event.doit = false;
            try {
                if (!this.run(new IRunnableWithProgress(){
                    private String licenseNum;
                    {
                        this.licenseNum = RegistrationWizard.this.getLicenseNum();
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            RegistrationWizard.this.doOffline1stStepReg(monitor, this.licenseNum, regFile);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                })) return;
                event.doit = true;
                this.offlineRegInFilesPage.set1stStepMessage(NLS.bind((String)IdaStepMessages.RegistrationWizard_Successful1stStepMessage, (Object)regFile.getAbsolutePath()));
                return;
            }
            finally {
                if (!event.doit) {
                    this.offlineRegOutFilesPage.setMessage(NLS.bind((String)IdaStepMessages.RegistrationWizard_offlineRegOutFilesPage_message, (Object)regFile.getAbsolutePath()), 3);
                }
            }
        } else {
            this.offlineRegInFilesPage.set1stStepMessage(null);
        }
    }

    String getLicenseNum() {
        return this.registrationPage.isNewLicense() ? this.registrationPage.getLicenseNum() : this.registrationPage.getCurrentLicenseNum();
    }

    boolean areRegistrationPagesComplete() {
        boolean offline = this.registrationMethodPage.isOfflineMethod();
        if (offline) {
            boolean bl;
            File file;
            if (this.offlineRegOutFilesPage.isOffline1stStepReg() && ((file = this.offlineRegOutFilesPage.getOffline1stStepRegFile()) == null || file.isDirectory())) {
                return false;
            }
            file = this.offlineRegInFilesPage.getOfflineLicenseFile();
            if (file == null || !file.isFile() || !file.canRead()) {
                return false;
            }
            file = this.offlineRegInFilesPage.getOfflineInstallationFile();
            if (file == null || !file.isFile() || !file.canRead()) {
                return false;
            }
            ZipFile zipFile = new ZipFile(file);
            try {
                bl = zipFile.getEntry("site.xml") != null;
            }
            catch (Throwable throwable) {
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            zipFile.close();
            return bl;
        }
        return true;
    }

    private void addPageChangeListeners() {
        IWizardContainer container = this.getContainer();
        if (container instanceof IPageChangeProvider) {
            IPageChangeProvider pageChangeProvider = (IPageChangeProvider)container;
            pageChangeProvider.addPageChangedListener((IPageChangedListener)this.offlineRegOutFilesPage);
        }
        if (container instanceof WizardDialog) {
            ((WizardDialog)container).addPageChangingListener((IPageChangingListener)this);
        }
    }

    private void removePageChangeListeners() {
        IWizardContainer container = this.getContainer();
        if (container instanceof IPageChangeProvider) {
            IPageChangeProvider pageChangeProvider = (IPageChangeProvider)container;
            pageChangeProvider.removePageChangedListener((IPageChangedListener)this.offlineRegOutFilesPage);
        }
        if (container instanceof WizardDialog) {
            ((WizardDialog)container).removePageChangingListener((IPageChangingListener)this);
        }
    }

    private boolean run(IRunnableWithProgress finishRunnable) {
        this.setNeedsProgressMonitor(true);
        try {
            this.getContainer().run(true, false, finishRunnable);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new RuntimeException(targetException);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    void doOffline1stStepReg(IProgressMonitor monitor, String licenseNum, File regFile) throws IOException {
        monitor.beginTask(IdaStepMessages.RegistrationWizard_monitorBeginTask, 2);
        try {
            monitor.subTask(IdaStepMessages.RegistrationWizard_monitorSubTask);
            InputStream regTemplateIn = ((Object)((Object)this)).getClass().getResourceAsStream("register.html");
            if (regTemplateIn == null) {
                throw new IOException(IdaStepMessages.RegistrationWizard_regTemplateInNullException);
            }
            ByteArrayOutputStream regTemplateOut = new ByteArrayOutputStream();
            try {
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    regTemplateOut.write(buffer, 0, count);
                } while ((count = regTemplateIn.read(buffer, 0, buffer.length)) != -1);
            }
            finally {
                regTemplateIn.close();
                regTemplateOut.close();
            }
            String regTemplate = regTemplateOut.toString("UTF-8");
            monitor.worked(1);
            monitor.subTask(IdaStepMessages.RegistrationWizard_monitorBeginTask);
            LicensingService licensingService = LicensingService.getInstance();
            LicenseeInfo licenseeInfo = licensingService.getLicenseeInfoBytes(PRODUCT_VERSION_STRING, licenseNum);
            if (licenseeInfo.getHostId() == null) {
                throw new IOException(IdaStepMessages.RegistrationWizard_installationIsCorrupt);
            }
            Properties licenseeInfoProps = licenseeInfo.getInfoProperties();
            licenseeInfoProps.setProperty("host-id", licenseeInfo.getHostId().toString());
            Object[] regFileArgs = new Object[VISIBLE_LIC_INFO_PROPS.size() + 1];
            int i = 0;
            for (String property : VISIBLE_LIC_INFO_PROPS) {
                regFileArgs[i++] = licenseeInfoProps.getProperty(property, "");
            }
            StringBuilder hiddenParamString = new StringBuilder();
            Formatter hiddenParamFormatter = new Formatter(hiddenParamString);
            for (Map.Entry<Object, Object> propEntry : licenseeInfoProps.entrySet()) {
                String property = (String)propEntry.getKey();
                if (VISIBLE_LIC_INFO_PROPS.contains(property)) continue;
                hiddenParamFormatter.format("<input type=\"hidden\" name=\"%s\" value=\"%s\">%n", property, propEntry.getValue());
            }
            regFileArgs[i] = hiddenParamString;
            Formatter regFileFormatter = new Formatter(regFile, "UTF-8");
            try {
                regFileFormatter.format(regTemplate, regFileArgs);
            }
            finally {
                regFileFormatter.close();
            }
            licensingService.storeOfflineLicense(licenseNum);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    void doOffline2ndStepReg(IProgressMonitor monitor, File licFile) throws IOException, GeneralSecurityException, InterruptedException {
        monitor.beginTask(IdaStepMessages.RegistrationWizard_monitorTask_activatingOfflineLicense, -1);
        try {
            LicensingService licensingService = LicensingService.getInstance();
            FileInputStream licensePropertiesIn = new FileInputStream(licFile);
            boolean success = false;
            try {
                licensingService.storeLicenseProperties((InputStream)licensePropertiesIn);
                success = !LicenseProperties.load().isEmpty();
            }
            finally {
                ((InputStream)licensePropertiesIn).close();
                if (!success) {
                    licensingService.revertLicenseProperties();
                    throw new InterruptedException();
                }
                licensingService.deleteOfflineLicense();
            }
        }
        finally {
            monitor.done();
        }
    }
}

