/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import net.jsdai.ida_step.Activator;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.ida_step.preferences.MemoryTesterMain;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class MemoryPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREFERENCES_PAGE_CONTEXT_ID = "net.jsdai.ida_step.preferences_virtual_machine_memory";
    private static final String LAUNCHER_INI = "ida-step.ini";
    private static final String P_MAXIMUM_SIZE = "maximumSizePreference";
    private static final String P_CURRENT_MAXIMUM_SIZE = "currentMaximumSizePreference";
    private static final String ECLISE_PROP_EXITDATA = "eclipse.exitdata";
    private static final int MBYTE = 0x100000;
    private static final int MBYTE_ROUND_OFFSET = 524288;
    private static final int KBYTE = 1024;
    private static final int KBYTE_ROUND_OFFSET = 512;
    private static final int GBYTE = 1024;
    private static final int MAX_MEM_SAFEGUARD = 56;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String LAUNCHER_PROPERTY = "eclipse.launcher";
    private static final String LAUNCHER_EXECUTABLE = Platform.getOS().equals("win32") ? "ida-step.exe" : "ida-step";
    private static final ISchedulingRule CHECK_MAX_MEM_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private String launcherPath;
    private String memoryTesterJarPath;

    public MemoryPreferencePage() {
        super(1);
        this.setDescription(IdaStepMessages.MemoryPreferencePage_description);
        this.setPreferenceStore((IPreferenceStore)new PreferenceStore(){

            public void save() throws IOException {
                this.save(new OutputStream(){

                    public void write(int b) throws IOException {
                    }

                    public void write(byte[] b) throws IOException {
                    }

                    public void write(byte[] b, int off, int len) throws IOException {
                    }
                }, null);
            }
        });
        this.createMemoryTesterJar();
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.addField(new InformationField(P_CURRENT_MAXIMUM_SIZE, IdaStepMessages.MemoryPreferencePage_P_CURRENT_MAXIMUM_SIZE, parent));
        this.addField((FieldEditor)new JavaMaxHeapField(P_MAXIMUM_SIZE, IdaStepMessages.MemoryPreferencePage_P_MAXIMUM_SIZE, parent, 4));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), PREFERENCES_PAGE_CONTEXT_ID);
    }

    public void init(IWorkbench workbench) {
        IPersistentPreferenceStore preferenceStore = (IPersistentPreferenceStore)this.getPreferenceStore();
        int currentJavaHeapMaximumSize = MemoryPreferencePage.currentJavaHeapMaximumSize();
        preferenceStore.setValue(P_MAXIMUM_SIZE, MemoryPreferencePage.javaHeapMaximumSize());
        preferenceStore.setDefault(P_MAXIMUM_SIZE, 1024);
        preferenceStore.setValue(P_CURRENT_MAXIMUM_SIZE, currentJavaHeapMaximumSize);
        preferenceStore.setDefault(P_CURRENT_MAXIMUM_SIZE, currentJavaHeapMaximumSize);
        try {
            preferenceStore.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean performOk() {
        super.performOk();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        int prevMaxMemMb = MemoryPreferencePage.javaHeapMaximumSize();
        int maxMemMb = preferenceStore.getInt(P_MAXIMUM_SIZE);
        StringBuilder launcherIniContents = null;
        if (preferenceStore.needsSaving()) {
            try {
                TitleAreaDialog launcherIniDlg;
                final File launcherIniFile = new File(MemoryPreferencePage.getLauncherDir(), LAUNCHER_INI);
                launcherIniContents = new StringBuilder();
                boolean optVmargs = false;
                boolean optXmx = false;
                if (launcherIniFile.canRead()) {
                    BufferedReader iniReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(launcherIniFile), "iso-8859-1"));
                    try {
                        String iniLine;
                        while ((iniLine = iniReader.readLine()) != null) {
                            if ("-vmargs".equals(iniLine)) {
                                optVmargs = true;
                            }
                            if (optVmargs && iniLine.startsWith("-Xmx")) {
                                iniLine = "-Xmx" + maxMemMb + "m";
                                optXmx = true;
                            }
                            launcherIniContents.append(iniLine).append(LINE_SEPARATOR);
                        }
                    }
                    finally {
                        iniReader.close();
                    }
                }
                if (!optVmargs) {
                    launcherIniContents.append("-vmargs").append(LINE_SEPARATOR);
                }
                if (!optXmx) {
                    launcherIniContents.append("-Xmx").append(maxMemMb).append('m').append(LINE_SEPARATOR);
                }
                try {
                    launcherIniFile.createNewFile();
                }
                catch (IOException iniReader) {
                    // empty catch block
                }
                boolean writeSucceeded = false;
                final String launcherIniString = launcherIniContents.toString();
                if (launcherIniFile.canWrite()) {
                    try {
                        OutputStreamWriter iniWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(launcherIniFile), "iso-8859-1");
                        try {
                            iniWriter.write(launcherIniString);
                        }
                        finally {
                            ((Writer)iniWriter).close();
                        }
                        writeSucceeded = true;
                    }
                    catch (FileNotFoundException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "net.jsdai.ida_step", e.getMessage(), (Throwable)e));
                    }
                }
                if (!writeSucceeded && (launcherIniDlg = new TitleAreaDialog(this.getControl().getShell()){
                    {
                        super($anonymous0);
                        this.setShellStyle(this.getShellStyle() | 0x10);
                    }

                    protected void configureShell(Shell newShell) {
                        super.configureShell(newShell);
                        newShell.setText(IdaStepMessages.MemoryPreferencePage_msgDialog_OpenQuestion_title);
                    }

                    protected Control createDialogArea(Composite parent) {
                        Composite compositeParent = (Composite)super.createDialogArea(parent);
                        this.setTitleImage(MemoryPreferencePage.this.getControl().getDisplay().getSystemImage(1));
                        this.setTitle(IdaStepMessages.MemoryPreferencePage_dialogArea_title);
                        this.setMessage(NLS.bind((String)IdaStepMessages.MemoryPreferencePage_dialogArea_title_message, (Object)MemoryPreferencePage.LAUNCHER_INI), 2);
                        Composite dialogArea = new Composite(compositeParent, 0);
                        dialogArea.setLayoutData((Object)new GridData(4, 4, true, true));
                        dialogArea.setLayout((Layout)new GridLayout());
                        Text infoMessageText = new Text(dialogArea, 72);
                        infoMessageText.setText(NLS.bind((String)IdaStepMessages.MemoryPreferencePage_infoMessageText_text, (Object)launcherIniFile));
                        infoMessageText.setBackground(dialogArea.getBackground());
                        infoMessageText.setLayoutData((Object)new GridData(4, 0, true, false));
                        Text launcherIniText = new Text(dialogArea, 2826);
                        launcherIniText.setText(launcherIniString);
                        launcherIniText.setLayoutData((Object)new GridData(4, 4, true, true));
                        launcherIniText.setFocus();
                        parent.getShell().setMinimumSize(this.convertHorizontalDLUsToPixels(165), this.convertVerticalDLUsToPixels(120));
                        return compositeParent;
                    }

                    protected Point getInitialSize() {
                        return new Point(this.convertHorizontalDLUsToPixels(300), this.convertVerticalDLUsToPixels(200));
                    }
                }).open() != 0) {
                    return false;
                }
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "net.jsdai.ida_step", e.getMessage(), (Throwable)e));
                this.setErrorMessage("Failed writing file ida-step.ini");
                return false;
            }
        }
        if (maxMemMb != MemoryPreferencePage.javaHeapMaximumSize()) {
            this.setErrorMessage(String.valueOf(IdaStepMessages.MemoryPreferencePage_errMessage) + LAUNCHER_INI);
            return false;
        }
        if (maxMemMb != prevMaxMemMb && MessageDialog.openQuestion((Shell)this.getControl().getShell(), (String)IdaStepMessages.MemoryPreferencePage_msgDialog_OpenQuestion_title, (String)IdaStepMessages.MemoryPreferencePage_msgDialog_OpenQuestion_message)) {
            System.setProperty(ECLISE_PROP_EXITDATA, this.launcherPath != null ? this.launcherPath : LAUNCHER_EXECUTABLE);
            this.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PlatformUI.getWorkbench().restart();
                }
            });
        }
        return true;
    }

    private void createMemoryTesterJar() {
        try {
            this.launcherPath = null;
            String outDir = Activator.getDefault().getStateLocation().toOSString();
            File memoryTesterFile = new File(outDir, "memory-tester.jar");
            FileOutputStream memoryTesterOut = new FileOutputStream(memoryTesterFile);
            try {
                Manifest jarManifest = new Manifest();
                String className = MemoryTesterMain.class.getName();
                Attributes jarManifestAttrs = jarManifest.getMainAttributes();
                jarManifestAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                jarManifestAttrs.put(Attributes.Name.MAIN_CLASS, className);
                JarOutputStream jarOut = new JarOutputStream((OutputStream)memoryTesterOut, jarManifest);
                jarOut.setLevel(0);
                ZipEntry classEntry = new ZipEntry(String.valueOf(className.replace('.', '/')) + ".class");
                jarOut.putNextEntry(classEntry);
                InputStream testerClassIn = MemoryTesterMain.class.getResourceAsStream(String.valueOf(MemoryTesterMain.class.getSimpleName()) + ".class");
                try {
                    MemoryPreferencePage.copyFile(testerClassIn, jarOut);
                }
                finally {
                    testerClassIn.close();
                }
                jarOut.closeEntry();
                jarOut.close();
                this.launcherPath = System.getProperty(LAUNCHER_PROPERTY);
                if (this.launcherPath == null || !new File(this.launcherPath).isFile()) {
                    this.launcherPath = new File(MemoryPreferencePage.getLauncherDir(), LAUNCHER_EXECUTABLE).getAbsolutePath();
                }
                this.memoryTesterJarPath = memoryTesterFile.getAbsolutePath();
            }
            finally {
                ((OutputStream)memoryTesterOut).close();
            }
        }
        catch (IOException e) {
            Activator.logError("Unable to create memory-tester.jar", e);
        }
    }

    private static void copyFile(InputStream in, OutputStream to) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            to.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }

    private static String getLauncherDir() throws IOException {
        Location installLocation = Platform.getInstallLocation();
        URL instLocationUrl = installLocation.getURL();
        if ("file".equalsIgnoreCase(instLocationUrl.getProtocol())) {
            return instLocationUrl.getPath();
        }
        throw new IOException("Unsupported protocol: " + instLocationUrl.getProtocol());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int javaHeapMaximumSize() {
        try {
            int maxSize = MemoryPreferencePage.currentJavaHeapMaximumSize();
            boolean vmargs = false;
            BufferedReader iniReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(MemoryPreferencePage.getLauncherDir(), LAUNCHER_INI)), "iso-8859-1"));
            try {
                while (true) {
                    String iniLine;
                    if ((iniLine = iniReader.readLine()) == null) {
                        return maxSize;
                    }
                    if ("-vmargs".equals(iniLine)) {
                        vmargs = true;
                    }
                    if (!vmargs || !iniLine.startsWith("-Xmx")) continue;
                    try {
                        int iniLineLen = iniLine.length();
                        char lastCh = Character.toLowerCase(iniLine.charAt(iniLineLen - 1));
                        if (Character.isDigit(lastCh)) {
                            maxSize = (int)((Long.parseLong(iniLine.substring(4)) + 524288L) / 0x100000L);
                            continue;
                        }
                        if (lastCh == 'k') {
                            maxSize = (Integer.parseInt(iniLine.substring(4, iniLineLen - 1)) + 512) / 1024;
                            continue;
                        }
                        if (lastCh == 'm') {
                            maxSize = Integer.parseInt(iniLine.substring(4, iniLineLen - 1));
                            continue;
                        }
                        if (lastCh != 'g') continue;
                        maxSize = Integer.parseInt(iniLine.substring(4, iniLineLen - 1)) * 1024;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            finally {
                iniReader.close();
            }
        }
        catch (IOException e) {
            return MemoryPreferencePage.currentJavaHeapMaximumSize();
        }
    }

    private static int currentJavaHeapMaximumSize() {
        return (int)((Runtime.getRuntime().maxMemory() + 524288L) / 0x100000L);
    }

    private static final class InformationField
    extends FieldEditor {
        private Text textField;

        private InformationField(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        public int getNumberOfControls() {
            return 2;
        }

        protected void doStore() {
        }

        protected void doLoadDefault() {
            this.doLoad();
        }

        protected void doLoad() {
            if (this.textField != null) {
                String value = this.getPreferenceStore().getString(this.getPreferenceName());
                this.textField.setText(value);
            }
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.getLabelControl(parent);
            if (this.textField == null) {
                this.textField = new Text(parent, 8);
                this.textField.setBackground(parent.getBackground());
            } else {
                this.checkParent((Control)this.textField, parent);
            }
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns - 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.textField.setLayoutData((Object)gd);
        }

        protected void adjustForNumColumns(int numColumns) {
            GridData gd = (GridData)this.textField.getLayoutData();
            gd.horizontalSpan = numColumns - 1;
            gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
        }
    }

    final class JavaMaxHeapField
    extends IntegerFieldEditor {
        private int prevNumber;
        private boolean prevState;
        private int nextMaxMemMbToCheck;
        private int lastMaxMemMbChecked;

        private JavaMaxHeapField(String name, String labelText, Composite parent, int textLimit) {
            super(name, labelText, parent, textLimit);
            this.prevNumber = -1;
            this.prevState = true;
        }

        private JavaMaxHeapField(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.prevNumber = -1;
            this.prevState = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean checkState() {
            boolean state = super.checkState();
            if (state) {
                String numberString = this.getTextControl().getText();
                int number = Integer.parseInt(numberString);
                if (number != this.prevNumber) {
                    JavaMaxHeapField javaMaxHeapField = this;
                    synchronized (javaMaxHeapField) {
                        this.nextMaxMemMbToCheck = number;
                    }
                    Job maxMemCheckJob = new Job(IdaStepMessages.MemoryPreferencePage_maxMemCheckJob){
                        Display display;
                        {
                            this.display = MemoryPreferencePage.this.getFieldEditorParent().getShell().getDisplay();
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            JavaMaxHeapField.this.checkMaxMem(this.display);
                            return Status.OK_STATUS;
                        }
                    };
                    maxMemCheckJob.setSystem(true);
                    maxMemCheckJob.setRule(CHECK_MAX_MEM_RULE);
                    maxMemCheckJob.schedule();
                    state = false;
                    this.prevNumber = number;
                } else {
                    state = this.prevState;
                }
                if (!this.prevState) {
                    this.showErrorMessage(IdaStepMessages.MemoryPreferencePage_showErrorMessage);
                }
            }
            return state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkMaxMem(Display display) {
            int maxMemMb;
            JavaMaxHeapField javaMaxHeapField = this;
            synchronized (javaMaxHeapField) {
                maxMemMb = this.nextMaxMemMbToCheck;
                if (maxMemMb == this.lastMaxMemMbChecked) {
                    return;
                }
            }
            if (MemoryPreferencePage.this.launcherPath == null) {
                return;
            }
            try {
                boolean state;
                ProcessBuilder launcherProcessBuilder = new ProcessBuilder(MemoryPreferencePage.this.launcherPath, "--launcher.suppressErrors", "-startup", MemoryPreferencePage.this.memoryTesterJarPath, "-vmargs", "-Xmx" + (maxMemMb + 56) + "m");
                launcherProcessBuilder.redirectErrorStream(true);
                final Process launcherProcess = launcherProcessBuilder.start();
                Job ioJob = new Job(IdaStepMessages.MemoryPreferencePage_job){

                    protected IStatus run(IProgressMonitor monitor) {
                        InputStream in = launcherProcess.getInputStream();
                        byte[] buff = new byte[8192];
                        try {
                            while (in.read(buff) >= 0) {
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return Status.OK_STATUS;
                    }
                };
                ioJob.setSystem(true);
                ioJob.schedule();
                while (true) {
                    try {
                        state = launcherProcess.waitFor() == 0;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                JavaMaxHeapField javaMaxHeapField2 = this;
                synchronized (javaMaxHeapField2) {
                    this.lastMaxMemMbChecked = maxMemMb;
                }
                final boolean finalState = state;
                display.asyncExec(new Runnable(){

                    public void run() {
                        JavaMaxHeapField.this.prevState = finalState;
                        JavaMaxHeapField.this.valueChanged();
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

