/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.wizards.DuplicateConflictsDialog;
import org.eclipse.update.internal.ui.wizards.InstallWizard2;
import org.eclipse.update.internal.ui.wizards.ReviewPage;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.search.UpdateSearchRequest;

public class InstallWizard3
extends InstallWizard2 {
    private final IInstallFeatureOperation[] jobsAsArray;

    public InstallWizard3(UpdateSearchRequest searchRequest, IInstallFeatureOperation[] jobs, boolean isUpdate) {
        super(searchRequest, jobs, isUpdate);
        this.jobsAsArray = jobs;
    }

    public boolean performFinish() {
        boolean proceed;
        DuplicateConflictsDialog dialog;
        ReviewPage reviewPage = new ReviewPage(this.isUpdate, this.searchRequest, this.jobs){

            public IInstallFeatureOperation[] getSelectedJobs() {
                return InstallWizard3.this.jobsAsArray;
            }
        };
        this.addPage((IWizardPage)reviewPage);
        Control reviewPageControl = reviewPage.createContents((Composite)UpdateUI.getActiveWorkbenchShell());
        reviewPageControl.setVisible(false);
        try {
            reviewPage.getWizard().getContainer().showPage((IWizardPage)reviewPage);
            reviewPage.validateSelection((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            reviewPageControl.dispose();
        }
        if (!reviewPage.isPageComplete()) {
            reviewPage.showStatus();
            return false;
        }
        this.targetPage.setJobs(this.jobsAsArray);
        this.targetPage.initializeDefaultTargetSites();
        ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts((IInstallFeatureOperation[])this.jobsAsArray, (IInstallConfiguration)this.config);
        if (conflicts != null && (dialog = new DuplicateConflictsDialog(this.getShell(), conflicts)).open() != 0) {
            return false;
        }
        if (Job.getJobManager().find(jobFamily).length > 0 && !(proceed = MessageDialog.openQuestion((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUIMessages.InstallWizard_anotherJobTitle, (String)UpdateUIMessages.InstallWizard_anotherJob))) {
            return false;
        }
        this.installOperation = this.getBatchInstallOperation(this.jobsAsArray);
        if (this.installOperation != null) {
            this.launchInBackground();
        }
        return true;
    }

    public IWizardContainer getContainer() {
        return new IWizardContainer(){
            private IWizardPage page;

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }

            public void updateWindowTitle() {
            }

            public void updateTitleBar() {
            }

            public void updateMessage() {
            }

            public void updateButtons() {
            }

            public void showPage(IWizardPage page) {
                this.page = page;
            }

            public Shell getShell() {
                return UpdateUI.getActiveWorkbenchShell();
            }

            public IWizardPage getCurrentPage() {
                return this.page;
            }
        };
    }

    public void addPage(IWizardPage page) {
        page.setWizard((IWizard)this);
    }

    protected boolean install(IProgressMonitor monitor) {
        try {
            try {
                this.installOperation.execute(monitor, (IOperationListener)this);
                this.needsRestart = true;
                if (this.isRestartNeeded()) {
                    UpdateUI.getStandardDisplay().asyncExec(new Runnable(){

                        public void run() {
                            IWorkbenchWindow[] windows;
                            boolean unconditional = true;
                            IWorkbenchWindow[] iWorkbenchWindowArray = windows = UpdateUI.getDefault().getWorkbench().getWorkbenchWindows();
                            int n = windows.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IWorkbenchPage[] pages;
                                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                                IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                                int n3 = pages.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                                    if (page.getEditorReferences().length > 0) {
                                        unconditional = false;
                                        break;
                                    }
                                    ++n4;
                                }
                                ++n2;
                            }
                            if (unconditional) {
                                IProduct product = Platform.getProduct();
                                String productName = product != null && product.getName() != null ? product.getName() : UpdateUIMessages.ApplicationInRestartDialog;
                                MessageDialog.openInformation((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUIMessages.RestartTitle, (String)NLS.bind((String)"The {0} needs to be restarted for the changes to take effect.", (Object)productName));
                                PlatformUI.getWorkbench().restart();
                            } else {
                                UpdateUI.requestRestart((boolean)true);
                            }
                        }
                    });
                }
            }
            catch (InvocationTargetException e) {
                final Throwable targetException = e.getTargetException();
                if (!(targetException instanceof InstallAbortedException)) {
                    UpdateUI.getStandardDisplay().syncExec(new Runnable(){

                        public void run() {
                            UpdateUI.logException((Throwable)targetException);
                        }
                    });
                }
                isRunning = false;
                return false;
            }
            catch (CoreException coreException) {
                isRunning = false;
                return false;
            }
        }
        finally {
            isRunning = false;
        }
        return true;
    }
}

