/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui.accessor;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.CertificateException;
import java.util.Observable;
import java.util.Observer;
import javax.net.ssl.SSLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.core.InternalSiteManager;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.wizards.InstallWizardOperation;
import org.eclipse.update.internal.ui.wizards.InstallWizardOperation2;
import org.eclipse.update.internal.ui.wizards.ModeSelectionPage;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.IUpdateSearchCategory;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.ui.UpdateJob;

public class UpdateManagerUI2
implements InvocationHandler {
    private InstallWizardOperation operation;

    public UpdateSearchRequest newSearchRequest() {
        UpdateSearchRequest searchRequest = new UpdateSearchRequest((IUpdateSearchCategory)new SiteSearchCategory(true), new UpdateSearchScope());
        searchRequest.addFilter((IUpdateSearchFilter)new BackLevelFilter());
        return searchRequest;
    }

    public IWizardPage newModeSelectionPage(UpdateSearchRequest searchRequest) {
        return new ModeSelectionPage(searchRequest){

            public boolean canFlipToNextPage() {
                return false;
            }
        };
    }

    public boolean isUpdateMode(IWizardPage modeSelectionPage) {
        if (modeSelectionPage instanceof ModeSelectionPage) {
            return ((ModeSelectionPage)modeSelectionPage).isUpdateMode();
        }
        return false;
    }

    public void runInstallWizardOperation(UpdateSearchRequest searchRequest, IRunnableWithProgress preRunnable) {
        PreRunnableUpdateJob job = searchRequest == null ? new PreRunnableUpdateJob(UpdateUIMessages.InstallWizard_jobName, false, false) : new PreRunnableUpdateJob(UpdateUIMessages.InstallWizard_jobName, searchRequest);
        job.setPreRunnable(preRunnable);
        job.setUser(true);
        job.setPriority(10);
        this.getOperation().run(UpdateUI.getActiveWorkbenchShell(), (UpdateJob)job);
    }

    private InstallWizardOperation getOperation() {
        if (this.operation == null) {
            boolean advancedUi = Boolean.getBoolean("org.eclipse.update.ui.advanced");
            this.operation = advancedUi ? new InstallWizardOperation() : new InstallWizardOperation2();
        }
        return this.operation;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method methodToInvoke = UpdateManagerUI2.class.getMethod(method.getName(), method.getParameterTypes());
        if (methodToInvoke != UpdateManagerUI2.class.getMethod("invoke", Object.class, Method.class, Object[].class)) {
            return methodToInvoke.invoke((Object)this, args);
        }
        throw new IllegalAccessException(methodToInvoke + " can not be called recursively");
    }

    private static class PreRunnableUpdateJob
    extends UpdateJob {
        private IStatus pretendStatus = null;
        private IRunnableWithProgress preRunnable;

        public PreRunnableUpdateJob(String name, boolean isAutomatic, boolean download) {
            super(name, isAutomatic, download);
        }

        public PreRunnableUpdateJob(String name, UpdateSearchRequest searchRequest) {
            super(name, searchRequest);
        }

        public void setPreRunnable(IRunnableWithProgress preRunnable) {
            this.preRunnable = preRunnable;
            if (preRunnable instanceof Observer) {
                ((Observer)preRunnable).update(new Observable(), (Object)this);
            }
        }

        public IStatus run(IProgressMonitor monitor) {
            this.pretendStatus = Status.CANCEL_STATUS;
            InternalSiteManager.globalUseCache = false;
            if (this.preRunnable != null) {
                monitor.beginTask("", 20);
                try {
                    this.preRunnable.run((IProgressMonitor)new SubProgressMonitor(monitor, 10, 4));
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    PreRunnableUpdateJob.reportStatus((IStatus)new Status(4, "org.eclipse.update.ui", 0, String.valueOf(targetException.getClass().getName()) + ": " + targetException.getLocalizedMessage(), targetException));
                    return Status.OK_STATUS;
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
                super.run((IProgressMonitor)new SubProgressMonitor(monitor, 10, 4));
            } else {
                super.run(monitor);
            }
            InternalSiteManager.globalUseCache = true;
            IStatus status = this.getRealStatus();
            if (this.getUpdates() != null && this.getUpdates().length != 0) {
                this.pretendStatus = null;
            } else {
                boolean skipNoUpdatesNotification;
                Boolean requestRestartBoolean = (Boolean)this.getProperty(new QualifiedName("org.eclipse.update.ui", "request.restart"));
                boolean requestRestart = requestRestartBoolean != null ? requestRestartBoolean : false;
                Boolean skipNoUpdatesNotificationBoolean = (Boolean)this.getProperty(new QualifiedName("org.eclipse.update.ui", "skip.no.updates.notification"));
                boolean bl = skipNoUpdatesNotification = skipNoUpdatesNotificationBoolean != null ? skipNoUpdatesNotificationBoolean : false;
                if (requestRestart) {
                    UpdateUI.getStandardDisplay().asyncExec(new Runnable(){

                        public void run() {
                            UpdateUI.requestRestart((boolean)true);
                        }
                    });
                } else if (!skipNoUpdatesNotification && status == Status.OK_STATUS) {
                    status = new Status(1, "org.eclipse.update.ui", "No new features or updates are available");
                }
            }
            PreRunnableUpdateJob.reportStatus(status);
            return Status.OK_STATUS;
        }

        public IStatus getStatus() {
            return this.pretendStatus != null ? this.pretendStatus : super.getStatus();
        }

        private IStatus getRealStatus() {
            return super.getStatus();
        }

        private static void reportStatus(IStatus status) {
            if (status != Status.OK_STATUS && status != Status.CANCEL_STATUS) {
                String message;
                Throwable statusException = status.getException();
                if (statusException != null && (message = PreRunnableUpdateJob.getStatusMessage(status)) != null) {
                    MultiStatus multiStatus = new MultiStatus(status.getPlugin(), status.getCode(), message, null);
                    multiStatus.merge(status);
                    status = multiStatus;
                }
                final IStatus logStatus = status;
                UpdateUI.log((IStatus)logStatus, (boolean)false);
                UpdateUI.getStandardDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)UpdateUI.getActiveWorkbenchShell(), (String)JFaceResources.getString((String)"Problem_Occurred"), (String)logStatus.getMessage());
                    }
                });
            }
        }

        private static String getStatusMessage(IStatus status) {
            boolean usingProxy;
            Throwable statusException = status.getException();
            boolean bl = usingProxy = System.getProperty("https.proxyHost") != null;
            if (statusException instanceof SSLException) {
                if (statusException.getCause() instanceof CertificateException) {
                    if (usingProxy) {
                        return "Failed to connect to https://services.ida-step.net/ through the Internet.\n\nYour proxy possibly re-encoded data using it's own certificate\nwhich is not supported by IDA-STEP.\n\nGo to Help->About IDA-STEP->Configuration Details->View Error Log\nfor detail information";
                    }
                    return "Failed to connect to https://services.ida-step.net/ through the Internet.\n\nPossible reason is forged certificate by some kind of man in middle attack.\n\nGo to Help->About IDA-STEP->Configuration Details->View Error Log\nfor detail information";
                }
                if (usingProxy) {
                    return "Failed to connect to https://services.ida-step.net/ through the Internet.\n\nThe failure was caused by HTTPS communication problem with the proxy.\n\nGo to Help->About IDA-STEP->Configuration Details->View Error Log\nfor detail information";
                }
                return "Failed to connect to https://services.ida-step.net/ through the Internet.\n\nThe failure was caused by HTTPS communication problem.\n\nGo to Help->About IDA-STEP->Configuration Details->View Error Log\nfor detail information";
            }
            if (statusException instanceof IOException) {
                String message = statusException.getMessage();
                if ("hostid.exception".equals(message)) {
                    return "IDA-STEP installation is corrupted.\n\nPossible solutions are:\n  \u25cf  Try running IDA-STEP as administrator.\n  \u25cf  Try reinstalling IDA-STEP.\nGo to Help->About IDA-STEP->Configuration Details->View Error Log\nfor detail information";
                }
                if (usingProxy) {
                    return "Failed to connect to https://services.ida-step.net/ through the Internet.\n\nPossible reasons are:\n  \u25cf  Your computer is not connected to the Internet.\n  \u25cf  IDA-STEP is protected from accessing the Internet\n       through a firewall of the operating system.\n  \u25cf  The proxy requires authentication therefore user name and\n       password have to be entered. Select Window->Preferences\n       and then go to General->Network Connections.\n\nGo to Help->About IDA-STEP->Configuration Details->View Error Log\nfor detail information";
                }
                return "Failed to connect to https://services.ida-step.net/ through the Internet.\n\nPossible reasons are:\n  \u25cf  Your computer is not connected to the Internet.\n  \u25cf  IDA-STEP is protected from accessing the Internet\n       through a firewall of the operating system.\n  \u25cf  The proxy has to be set up for Internet access. Select\n       Window->Preferences and then go to General->Network Connections.\n\nGo to Help->About IDA-STEP->Configuration Details->View Error Log\nfor detail information";
            }
            if (statusException != null) {
                return "Internal error:\n" + status.getMessage() + "\n\n" + "Go to Help->About IDA-STEP->Configuration Details->View Error Log\n" + "for detail information";
            }
            return null;
        }
    }
}

