/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step;

import net.jsdai.ida_step.actions.CloseAction;
import net.jsdai.ida_step.actions.PreferencesAction;
import net.jsdai.ida_step.actions.RegisterAndInstallAction;
import net.jsdai.ida_step.actions.ReopenEditorMenu;
import net.jsdai.ida_step.l10n.CommonStringsMessages;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.part.IWorkbenchActionProvider;
import net.jsdai.repo_edit.services.WeightedObjectsRegistryService;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.menus.IMenuService;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static final String ENABLE_SAVE_ACTION_OBJECT_ID = "net.jsdai.product.enableSaveAction";
    public static final String OPEN_ACTION_OBJECT_ID = "net.jsdai.product.openAction";
    public static final String NEW_ACTION_OBJECT_ID = "net.jsdai.product.newAction";
    public static final String PRINT_VIEWS_ACTION_OBJECT_ID = "net.jsdai.printing.printViewsAction";
    private final IWorkbenchWindow window;
    private ActionFactory.IWorkbenchAction newAction;
    private ActionFactory.IWorkbenchAction openAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private IAction closeAction;
    private ActionFactory.IWorkbenchAction printAction;
    private ActionFactory.IWorkbenchAction printViewsAction;
    private ActionFactory.IWorkbenchAction importAction;
    private ActionFactory.IWorkbenchAction exportAction;
    private IContributionItem recentFileList;
    private ActionFactory.IWorkbenchAction quitAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private ActionFactory.IWorkbenchAction findAction;
    private ActionFactory.IWorkbenchAction preferencesAction;
    private IContributionItem showViewShortlist;
    private ActionFactory.IWorkbenchAction registerAndInstallAction;
    private IContributionItem perspectivesShortlist;
    private ActionFactory.IWorkbenchAction helpContentsAction;
    private ActionFactory.IWorkbenchAction helpSearchAction;
    private ActionFactory.IWorkbenchAction dynamicHelpAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction lockToolBarAction;
    private ActionFactory.IWorkbenchAction editActionSetAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
        this.window = configurer.getWindowConfigurer().getWindow();
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.newAction = ApplicationActionBarAdvisor.getWeightedAction(window, NEW_ACTION_OBJECT_ID);
        if (this.newAction != null) {
            this.register((IAction)this.newAction);
        }
        this.openAction = ApplicationActionBarAdvisor.getWeightedAction(window, OPEN_ACTION_OBJECT_ID);
        if (this.openAction != null) {
            this.register((IAction)this.openAction);
        }
        if (WeightedObjectsRegistryService.getInstance().getId(ENABLE_SAVE_ACTION_OBJECT_ID) != null) {
            this.saveAction = ActionFactory.SAVE.create(window);
            this.register((IAction)this.saveAction);
            this.saveAsAction = ActionFactory.SAVE_AS.create(window);
            this.register((IAction)this.saveAsAction);
        }
        this.closeAction = new CloseAction(window);
        this.printAction = ActionFactory.PRINT.create(window);
        this.register((IAction)this.printAction);
        this.printViewsAction = ApplicationActionBarAdvisor.getWeightedAction(window, PRINT_VIEWS_ACTION_OBJECT_ID);
        if (this.printViewsAction != null) {
            this.register((IAction)this.printViewsAction);
        }
        this.importAction = ActionFactory.IMPORT.create(window);
        this.importAction.setEnabled(true);
        this.register((IAction)this.importAction);
        this.exportAction = ActionFactory.EXPORT.create(window);
        this.exportAction.setEnabled(true);
        this.register((IAction)this.exportAction);
        this.recentFileList = new ReopenEditorMenu(window, "reopenEditors", true);
        this.quitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.quitAction);
        this.undoAction = ActionFactory.UNDO.create(window);
        this.register((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(window);
        this.register((IAction)this.redoAction);
        this.cutAction = ActionFactory.CUT.create(window);
        this.register((IAction)this.cutAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.register((IAction)this.copyAction);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.register((IAction)this.pasteAction);
        this.deleteAction = ActionFactory.DELETE.create(window);
        this.register((IAction)this.deleteAction);
        this.findAction = ActionFactory.FIND.create(window);
        this.findAction.setText(NLS.bind((String)"&{0}...", (Object)CommonStringsMessages.find));
        this.findAction.setToolTipText(CommonStringsMessages.find);
        this.register((IAction)this.findAction);
        this.preferencesAction = new PreferencesAction(window);
        this.register((IAction)this.preferencesAction);
        this.registerAndInstallAction = new RegisterAndInstallAction(window);
        this.register((IAction)this.registerAndInstallAction);
        this.helpContentsAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.helpContentsAction);
        this.helpSearchAction = ActionFactory.HELP_SEARCH.create(window);
        this.register((IAction)this.helpSearchAction);
        this.dynamicHelpAction = ActionFactory.DYNAMIC_HELP.create(window);
        this.register((IAction)this.dynamicHelpAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.aboutAction);
        this.perspectivesShortlist = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
        this.showViewShortlist = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        this.lockToolBarAction = ActionFactory.LOCK_TOOL_BAR.create(window);
        this.register((IAction)this.lockToolBarAction);
        this.editActionSetAction = ActionFactory.EDIT_ACTION_SETS.create(window);
        this.register((IAction)this.editActionSetAction);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager menu = new MenuManager(CommonStringsMessages.file, "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        if (this.newAction != null) {
            menu.add((IAction)this.newAction);
        }
        menu.add((IContributionItem)new GroupMarker("new.ext"));
        if (this.openAction != null) {
            menu.add((IAction)this.openAction);
        }
        menu.add((IContributionItem)new GroupMarker("open.ext"));
        menu.add(this.closeAction);
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        if (this.saveAction != null) {
            menu.add((IAction)this.saveAction);
        }
        if (this.saveAsAction != null) {
            menu.add((IAction)this.saveAsAction);
        }
        menu.add((IContributionItem)new GroupMarker("save.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.printAction);
        menu.add((IContributionItem)new GroupMarker("print.ext"));
        if (this.printViewsAction != null) {
            menu.add((IAction)this.printViewsAction);
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.importAction);
        menu.add((IAction)this.exportAction);
        menu.add((IContributionItem)new GroupMarker("import.ext"));
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new GroupMarker("mru"));
        menu.add(this.recentFileList);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.quitAction);
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        menuBar.add((IContributionItem)menu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menu = new MenuManager(CommonStringsMessages.edit, "edit");
        menu.add((IAction)this.undoAction);
        menu.add((IAction)this.redoAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.cutAction);
        menu.add((IAction)this.copyAction);
        menu.add((IAction)this.pasteAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.deleteAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.findAction);
        menuBar.add((IContributionItem)menu);
        menu = new MenuManager(CommonStringsMessages.insert, "insert");
        menu.add((IContributionItem)new GroupMarker("gps"));
        menu.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)menu);
        menu = new MenuManager(CommonStringsMessages.window, "window");
        MenuManager openPerspMenuMgr = new MenuManager(IdaStepMessages.ApplicationActionBarAdvisor_openPerspectiveMenuText, "openPerspective");
        openPerspMenuMgr.add(this.perspectivesShortlist);
        menu.add((IContributionItem)openPerspMenuMgr);
        MenuManager showViewMenuMgr = new MenuManager(IdaStepMessages.ApplicationActionBarAdvisor_showViewMenuText, "showView");
        showViewMenuMgr.add(this.showViewShortlist);
        menu.add((IContributionItem)showViewMenuMgr);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.preferencesAction);
        menuBar.add((IContributionItem)menu);
        menu = new MenuManager(CommonStringsMessages.help, "help");
        menu.add((IAction)this.helpContentsAction);
        menu.add((IAction)this.helpSearchAction);
        menu.add((IAction)this.dynamicHelpAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.registerAndInstallAction);
        menu.add((IAction)this.aboutAction);
        menuBar.add((IContributionItem)menu);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        MenuManager popUpMenu = new MenuManager();
        popUpMenu.add((IContributionItem)new ActionContributionItem((IAction)this.lockToolBarAction));
        popUpMenu.add((IContributionItem)new ActionContributionItem((IAction)this.editActionSetAction));
        coolBar.setContextMenuManager((IMenuManager)popUpMenu);
        IMenuService menuService = (IMenuService)this.window.getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)popUpMenu, "popup:windowCoolbarContextMenu");
        IToolBarManager toolbar = ((IActionBarConfigurer2)this.getActionBarConfigurer()).createToolBarManager();
        coolBar.add((IContributionItem)new ToolBarContributionItem(toolbar, "org.eclipse.ui.workbench.file"));
        if (this.newAction != null) {
            toolbar.add((IAction)this.newAction);
        }
        if (this.openAction != null) {
            toolbar.add((IAction)this.openAction);
        }
        if (this.saveAction != null) {
            toolbar.add((IAction)this.saveAction);
        }
        if (this.closeAction != null) {
            toolbar.add(this.closeAction);
        }
        coolBar.add((IContributionItem)new GroupMarker("additions"));
    }

    public static ActionFactory.IWorkbenchAction getWeightedAction(IWorkbenchWindow window, String objectId) {
        ActionFactory.IWorkbenchAction action = null;
        Object obj = WeightedObjectsRegistryService.getInstance().getObject(objectId);
        if (obj instanceof IWorkbenchActionProvider) {
            IWorkbenchActionProvider provider = (IWorkbenchActionProvider)obj;
            action = provider.getAction(window);
        }
        return action;
    }
}

