/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.actions;

import net.jsdai.ida_step.Activator;
import net.jsdai.ida_step.l10n.CommonStringsMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public final class CloseAction
extends Action {
    private final IWorkbenchWindow window;
    private final IPartListener partListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                CloseAction.this.setEnabled(true);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                CloseAction.this.setEnabled();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    };
    private final IPageListener pageListener = new IPageListener(){

        public void pageOpened(IWorkbenchPage page) {
            page.addPartListener(CloseAction.this.partListener);
        }

        public void pageClosed(IWorkbenchPage page) {
            page.removePartListener(CloseAction.this.partListener);
        }

        public void pageActivated(IWorkbenchPage page) {
        }
    };

    public CloseAction(IWorkbenchWindow window) {
        super(CommonStringsMessages.close);
        this.setToolTipText(CommonStringsMessages.close);
        this.setId("close");
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"net.jsdai.ida_step", (String)"icons/close.gif"));
        this.setDisabledImageDescriptor(Activator.imageDescriptorFromPlugin((String)"net.jsdai.ida_step", (String)"icons/close_disabled.gif"));
        if (window == null) {
            throw new NullPointerException();
        }
        this.window = window;
        window.addPageListener(this.pageListener);
        this.setEnabled();
    }

    public void run() {
        IWorkbenchPage activePage = this.window.getActivePage();
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor != null) {
            activePage.closeEditor(activeEditor, true);
            if (activePage.getEditorReferences().length == 0 && this.window.getWorkbench().getWorkbenchWindowCount() > 1) {
                this.window.close();
            }
        }
    }

    private void setEnabled() {
        boolean enable = false;
        IWorkbenchPage activePage = this.window.getActivePage();
        if (activePage != null) {
            IEditorPart activeEditor = activePage.getActiveEditor();
            enable = activeEditor != null;
        }
        this.setEnabled(enable);
    }
}

