/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Observable;
import java.util.Observer;
import net.jsdai.ida_step.Application;
import net.jsdai.ida_step.installation.HtmlMessageDialog;
import net.jsdai.ida_step.installation.HttpUtil;
import net.jsdai.ida_step.installation.LicenseProperties;
import net.jsdai.ida_step.l10n.CommonStringsMessages;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.services.LicensingService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.ui.UpdateJob;

public class ActivationRunnable
implements IRunnableWithProgress,
Observer {
    private static final String IDA_STEP_UPDATE_SITE_BASE = "https://services.ida-step.net/update/";
    private final Shell parentShell;
    private final boolean newLicense;
    private final boolean updateMode;
    private final String licenseNum;
    private UpdateJob updateJob;

    public ActivationRunnable(Shell parentShell, boolean newLicense, boolean updateMode, String licenseNum) {
        this.parentShell = parentShell;
        this.newLicense = newLicense;
        this.updateMode = updateMode;
        this.licenseNum = licenseNum;
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof UpdateJob) {
            this.updateJob = (UpdateJob)arg;
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(NLS.bind((String)CommonStringsMessages.activating, (Object)":"), 4);
        try {
            monitor.subTask("");
            HttpUtil.configureConnection();
            LicensingService licensingService = LicensingService.getInstance();
            HttpURLConnection activationConnection = HttpUtil.doRequest(this.newLicense ? this.licenseNum : LicenseProperties.load().getLicenseNumber(), "activate/", monitor);
            int respCode = activationConnection.getResponseCode();
            String contType = activationConnection.getContentType();
            if (respCode != 200 || !contType.toLowerCase().equals("application/vnd.lksoft.license")) {
                InputStream messageStream;
                InputStream inputStream = messageStream = respCode == 200 ? activationConnection.getInputStream() : activationConnection.getErrorStream();
                if (messageStream == null) {
                    messageStream = new ByteArrayInputStream((String.valueOf(respCode) + " " + activationConnection.getResponseMessage()).getBytes("UTF-8"));
                }
                final String title = respCode == 200 ? CommonStringsMessages.activation : IdaStepMessages.ActivationRunnable_title_activationFailed;
                final String message = HtmlMessageDialog.httpStreamToString(messageStream, contType);
                this.parentShell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        String displayMsg = message;
                        if (message == null || message.length() == 0) {
                            displayMsg = IdaStepMessages.ActivationRunnable_message_htmlError;
                        }
                        HtmlMessageDialog.open(ActivationRunnable.this.parentShell, title, displayMsg, 1);
                    }
                });
                throw new InterruptedException();
            }
            InputStream activationConnectionIn = activationConnection.getInputStream();
            licensingService.storeLicenseProperties(activationConnectionIn);
            activationConnectionIn.close();
            licensingService.deleteOfflineLicense();
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            if (this.updateJob != null) {
                String hostIdStr = LicenseProperties.load().getHostId();
                if (this.updateMode) {
                    this.updateJob.getSearchRequest().getScope().setUpdateMapURL(new URL("ida-step:update-policy.xml#" + hostIdStr));
                } else {
                    this.updateJob.getSearchRequest().getScope().addSearchSite("IDA-STEP", new URL(IDA_STEP_UPDATE_SITE_BASE + hostIdStr), new String[0]);
                }
                boolean featuresChanged = Application.getInstance().configureFeatures();
                this.updateJob.setProperty(new QualifiedName("org.eclipse.update.ui", "request.restart"), (Object)featuresChanged);
                this.updateJob.setProperty(new QualifiedName("org.eclipse.update.ui", "skip.no.updates.notification"), (Object)this.newLicense);
            }
            monitor.done();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (GeneralSecurityException e) {
            throw new InvocationTargetException(e);
        }
    }
}

