/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import java.util.List;
import net.jsdai.repo_edit.jface.viewers.CellSelection;
import net.jsdai.repo_edit.jface.viewers.ICellSelectionProvider;
import net.jsdai.repo_edit.jface.viewers.IFindCriterion;
import net.jsdai.repo_edit.jface.viewers.IFindTarget;
import net.jsdai.repo_edit.jface.viewers.IRowSelection;
import net.jsdai.repo_edit.jface.viewers.RowSelection;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColumnViewerFindTarget
implements IFindTarget {
    private final ColumnViewer viewer;
    private final ICellSelectionProvider selectionProvider;

    protected ColumnViewerFindTarget(ColumnViewer viewer, ICellSelectionProvider selectionProvider) {
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        this.viewer = viewer;
        if (selectionProvider == null) {
            throw new IllegalArgumentException();
        }
        this.selectionProvider = selectionProvider;
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public ICellSelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    @Override
    public boolean canPerformFind() {
        return true;
    }

    protected abstract List<? extends Item> getItems();

    protected abstract int getColumnCount();

    protected abstract String getText(Item var1, int var2);

    @Override
    public boolean findAndSelect(IFindCriterion criterion, boolean searchForward) {
        int startAtColumn;
        int startAtItem;
        IRowSelection currentSelection;
        List<? extends Item> itemsList = this.getItems();
        int currenSelectionItem = this.getItemFromSelection(itemsList, currentSelection = this.selectionProvider.getRowSelection());
        if (currenSelectionItem >= 0) {
            int currentSelectionColumn = currentSelection.getFirst().getColumns()[0];
            startAtItem = currenSelectionItem;
            startAtColumn = searchForward ? currentSelectionColumn + 1 : currentSelectionColumn - 1;
        } else if (searchForward) {
            startAtItem = 0;
            startAtColumn = 0;
        } else {
            startAtItem = itemsList.size() - 1;
            startAtColumn = this.getColumnCount() - 1;
        }
        IRowSelection newSelection = searchForward ? this.findNext(criterion, itemsList, startAtItem, startAtColumn) : this.findPrevious(criterion, itemsList, startAtItem, startAtColumn);
        if (newSelection != null) {
            this.selectionProvider.setSelection((ISelection)newSelection);
            return true;
        }
        return false;
    }

    private IRowSelection findNext(IFindCriterion criterion, List<? extends Item> itemsList, int startAtItem, int startAtColumn) {
        int columnCount = this.getColumnCount();
        int i = startAtItem;
        int n = itemsList.size();
        while (i < n) {
            Item item = itemsList.get(i);
            int j = startAtColumn;
            while (j < columnCount) {
                if (criterion.matches(this.getText(item, j))) {
                    RowSelection rowSelection = new RowSelection();
                    rowSelection.addRow(new CellSelection(item.getData(), new int[]{j}));
                    return rowSelection;
                }
                ++j;
            }
            startAtColumn = 0;
            ++i;
        }
        return null;
    }

    private IRowSelection findPrevious(IFindCriterion criterion, List<? extends Item> itemsList, int startAtItem, int startAtColumn) {
        int columnCount = this.getColumnCount();
        int i = startAtItem;
        while (i >= 0) {
            Item item = itemsList.get(i);
            int j = startAtColumn;
            while (j >= 0) {
                if (criterion.matches(this.getText(item, j))) {
                    RowSelection rowSelection = new RowSelection();
                    rowSelection.addRow(new CellSelection(item.getData(), new int[]{j}));
                    return rowSelection;
                }
                --j;
            }
            startAtColumn = columnCount - 1;
            --i;
        }
        return null;
    }

    private int getItemFromSelection(List<? extends Item> itemsList, IRowSelection lastFind) {
        if (lastFind != null && !lastFind.isEmpty()) {
            int i = 0;
            int n = itemsList.size();
            while (i < n) {
                if (itemsList.get(i).getData().equals(lastFind.getFirstElement())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

