/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.repo_edit.base.Activator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class CustomColumnViewerToolTip
extends ToolTip {
    private static final int DEFAULT_SHIFT_X = 10;
    private static final int DEFAULT_SHIFT_Y = 0;
    private final ColumnViewer viewer;
    private IToolTipCreator toolTipCreator;

    public CustomColumnViewerToolTip(ColumnViewer viewer) {
        super(viewer.getControl());
        this.viewer = viewer;
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        if (this.toolTipCreator == null) {
            Activator.logError("toolTipCreator is null", new Exception());
            return null;
        }
        Composite composite = this.toolTipCreator.createToolTipContentArea(parent);
        this.toolTipCreator = null;
        return composite;
    }

    protected boolean shouldCreateToolTip(Event event) {
        if (!super.shouldCreateToolTip(event)) {
            return false;
        }
        this.viewer.getControl().setToolTipText(null);
        ViewerCell cell = this.viewer.getCell(new Point(event.x, event.y));
        if (cell != null) {
            this.toolTipCreator = this.getToolTipCreator(cell);
            if (this.toolTipCreator != null) {
                this.setPopupDelay(this.toolTipCreator.getToolTipDisplayDelayTime());
                this.setHideDelay(this.toolTipCreator.getToolTipTimeDisplayed());
                Point shift = this.toolTipCreator.getToolTipShift();
                if (shift == null) {
                    this.setShift(new Point(10, 0));
                } else {
                    this.setShift(new Point(shift.x, shift.y));
                }
                return true;
            }
        }
        return false;
    }

    private IToolTipCreator getToolTipCreator(ViewerCell cell) {
        CellLabelProvider labelProvider = this.viewer.getLabelProvider(cell.getColumnIndex());
        if (labelProvider instanceof IToolTipCreatorProvider) {
            IToolTipCreatorProvider toolTipCreatorProvider = (IToolTipCreatorProvider)labelProvider;
            return toolTipCreatorProvider.getCreator(cell.getElement());
        }
        return this.getDefaultToolTipCreator(cell);
    }

    protected IToolTipCreator getDefaultToolTipCreator(ViewerCell cell) {
        CellLabelProvider labelProvider = this.viewer.getLabelProvider(cell.getColumnIndex());
        if (labelProvider == null) {
            return null;
        }
        Object element = cell.getElement();
        String text = labelProvider.getToolTipText(element);
        if (text != null && text.length() > 0) {
            return new DefaultToolTipCreator(element, text, labelProvider);
        }
        return null;
    }

    protected void afterHideToolTip(Event event) {
        super.afterHideToolTip(event);
        if (event != null && event.widget != this.viewer.getControl()) {
            this.viewer.getControl().setFocus();
        }
    }

    public static abstract class AbstractToolTipCreator
    implements IToolTipCreator {
        public int getToolTipDisplayDelayTime() {
            return 0;
        }

        public int getToolTipTimeDisplayed() {
            return 0;
        }

        public Point getToolTipShift() {
            return null;
        }
    }

    private static class DefaultToolTipCreator
    extends AbstractToolTipCreator {
        private final Object element;
        private final String toolTipText;
        private final CellLabelProvider labelProvider;

        public DefaultToolTipCreator(Object element, String toolTipText, CellLabelProvider labelProvider) {
            if (labelProvider == null) {
                throw new NullPointerException();
            }
            if (toolTipText == null) {
                throw new NullPointerException();
            }
            this.element = element;
            this.toolTipText = toolTipText;
            this.labelProvider = labelProvider;
        }

        public Composite createToolTipContentArea(Composite parent) {
            Color bgColor;
            Color fgColor = this.labelProvider.getToolTipForegroundColor(this.element);
            if (fgColor == null) {
                fgColor = parent.getDisplay().getSystemColor(28);
            }
            if ((bgColor = this.labelProvider.getToolTipBackgroundColor(this.element)) == null) {
                bgColor = parent.getDisplay().getSystemColor(29);
            }
            Font font = this.labelProvider.getToolTipFont(this.element);
            Image image = this.labelProvider.getToolTipImage(this.element);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 1;
            composite.setLayout((Layout)layout);
            CLabel label = new CLabel(composite, 0);
            label.setText(this.toolTipText);
            if (image != null) {
                label.setImage(image);
            }
            if (font != null) {
                label.setFont(font);
            }
            label.setForeground(fgColor);
            label.setBackground(bgColor);
            label.setLayoutData((Object)new GridData(4, 1, false, false));
            return composite;
        }

        public int getToolTipDisplayDelayTime() {
            return this.labelProvider.getToolTipDisplayDelayTime(this.element);
        }

        public int getToolTipTimeDisplayed() {
            return this.labelProvider.getToolTipTimeDisplayed(this.element);
        }

        public Point getToolTipShift() {
            return this.labelProvider.getToolTipShift(this.element);
        }
    }

    public static interface IToolTipCreator {
        public Composite createToolTipContentArea(Composite var1);

        public int getToolTipDisplayDelayTime();

        public int getToolTipTimeDisplayed();

        public Point getToolTipShift();
    }

    public static interface IToolTipCreatorProvider {
        public IToolTipCreator getCreator(Object var1);
    }
}

