/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.jsdai.repo_edit.jface.viewers.ICellSelection;
import net.jsdai.repo_edit.jface.viewers.IRowSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowSelection
implements IRowSelection {
    private LinkedList<ICellSelection> rows = new LinkedList();

    public void addRow(ICellSelection row) {
        this.rows.add(row);
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public List<ICellSelection> getRows() {
        return this.rows;
    }

    @Override
    public ICellSelection getFirst() {
        if (this.rows.isEmpty()) {
            return null;
        }
        return this.rows.getFirst();
    }

    @Override
    public ICellSelection getLast() {
        if (this.rows.isEmpty()) {
            return null;
        }
        return this.rows.getLast();
    }

    @Override
    public boolean isSelected(Object itemData) {
        return this.getSelected(itemData) != null;
    }

    @Override
    public ICellSelection getSelected(Object itemData) {
        for (ICellSelection row : this.rows) {
            Object data = row.getData();
            if (!data.equals(itemData)) continue;
            return row;
        }
        return null;
    }

    public Object getFirstElement() {
        ICellSelection cellSel = this.getFirst();
        if (cellSel == null) {
            return null;
        }
        return cellSel.getData();
    }

    public Iterator iterator() {
        List dataList = this.toDataList();
        return dataList.iterator();
    }

    public int size() {
        return this.rows.size();
    }

    public Object[] toArray() {
        List dataList = this.toDataList();
        return dataList.toArray();
    }

    public List toList() {
        List dataList = this.toDataList();
        return dataList;
    }

    private List toDataList() {
        LinkedList<Object> dataList = new LinkedList<Object>();
        for (ICellSelection row : this.rows) {
            dataList.add(row.getData());
        }
        return dataList;
    }
}

