/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.l10n.CommonStringsMessages;
import net.jsdai.l10n.RepoEditBaseMessages;
import net.jsdai.repo_edit.jface.viewers.CellInputValidator;
import net.jsdai.repo_edit.jface.viewers.ITextCellEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextDialogCellEditor
extends DialogCellEditor
implements ITextCellEditor {
    private IInputValidator validator;
    private Text defaultText;
    private Button button;
    private String columnName;
    private boolean isSelection = false;

    public TextDialogCellEditor(String cn) {
        this.validator = new CellInputValidator();
        this.columnName = cn;
    }

    public TextDialogCellEditor(Composite parent, String cn) {
        this(parent, cn, new CellInputValidator());
    }

    public TextDialogCellEditor(Composite table, String cn, IInputValidator valid) {
        super(table);
        this.validator = valid;
        this.columnName = cn;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        LongCellDialog dlg = new LongCellDialog(Display.getCurrent().getActiveShell(), NLS.bind((String)RepoEditBaseMessages.TextDialogCellEditor_Title, (Object)this.columnName), NLS.bind((String)RepoEditBaseMessages.TextDialogCellEditor_Message, (Object)this.columnName), this.defaultText.getText(), this.validator);
        if (dlg.open() == 0) {
            return dlg.getValue();
        }
        return this.defaultText.getText();
    }

    protected Control createContents(Composite cell) {
        final Composite parentControl = cell.getParent();
        this.defaultText = new Text(cell, 16388);
        this.defaultText.setFont(cell.getFont());
        this.defaultText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    return;
                }
                TextDialogCellEditor.this.keyReleaseOccured(e);
                TextDialogCellEditor.this.checkSelection();
            }
        });
        this.defaultText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TextDialogCellEditor.this.checkSelection();
            }
        });
        this.defaultText.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (!(e.detail != 16 && e.detail != 8 || parentControl == null || parentControl.isDisposed())) {
                    TextDialogCellEditor.this.fireApplyEditorValue();
                    TextDialogCellEditor.this.deactivate();
                    parentControl.notifyListeners(31, e);
                    e.doit = false;
                }
            }
        });
        this.defaultText.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    TextDialogCellEditor.this.fireApplyEditorValue();
                    TextDialogCellEditor.this.deactivate();
                    e.doit = true;
                    parentControl.notifyListeners(1, e);
                    e.doit = false;
                }
            }
        });
        this.defaultText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TextDialogCellEditor.this.defaultText.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!TextDialogCellEditor.this.button.isDisposed() && !TextDialogCellEditor.this.button.isFocusControl()) {
                            TextDialogCellEditor.this.focusLost();
                        }
                    }
                });
            }
        });
        return this.defaultText;
    }

    protected Button createButton(Composite parent) {
        this.button = super.createButton(parent);
        return this.button;
    }

    protected void doSetFocus() {
        if (this.defaultText != null) {
            this.defaultText.selectAll();
            this.defaultText.setFocus();
            this.checkSelection();
        }
    }

    public void addFocusListener(FocusListener listener) {
        this.defaultText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.defaultText.removeFocusListener(listener);
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.defaultText.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected void updateContents(Object value) {
        if (this.defaultText == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.defaultText.setText(text);
    }

    protected Object doGetValue() {
        return this.defaultText.getText();
    }

    public boolean isCopyEnabled() {
        if (this.defaultText == null || this.defaultText.isDisposed()) {
            return false;
        }
        return this.defaultText.getSelectionCount() > 0;
    }

    public void performCopy() {
        this.defaultText.copy();
    }

    public boolean isCutEnabled() {
        if (this.defaultText == null || this.defaultText.isDisposed()) {
            return false;
        }
        return this.defaultText.getSelectionCount() > 0;
    }

    public void performCut() {
        this.defaultText.cut();
        this.checkSelection();
    }

    public boolean isPasteEnabled() {
        return this.defaultText != null && !this.defaultText.isDisposed();
    }

    public void performPaste() {
        this.defaultText.paste();
        this.checkSelection();
    }

    private static class LongCellDialog
    extends Dialog {
        private String title;
        private String message;
        private String value = "";
        private IInputValidator validator;
        private Button okButton;
        private StyledText text;
        private Text errorMessageText;
        private String errorMessage;

        public LongCellDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell);
            this.title = dialogTitle;
            this.message = dialogMessage;
            this.value = initialValue == null ? "" : initialValue;
            this.validator = validator;
        }

        protected void buttonPressed(int buttonId) {
            this.value = buttonId == 0 ? this.text.getText() : null;
            super.buttonPressed(buttonId);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (this.title != null) {
                shell.setText(this.title);
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.text.setFocus();
            if (this.value != null) {
                this.text.setText(this.value);
                this.text.selectAll();
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            if (this.message != null) {
                Label label = new Label(composite, 64);
                label.setText(this.message);
                GridData data = new GridData(1796);
                data.widthHint = this.convertHorizontalDLUsToPixels(300);
                label.setLayoutData((Object)data);
                label.setFont(parent.getFont());
            }
            this.text = new StyledText(composite, 2624);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            data.heightHint = 100;
            data.widthHint = 200;
            this.text.setLayoutData((Object)data);
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LongCellDialog.this.validateInput();
                }
            });
            Menu popupMenu = new Menu((Control)this.text);
            MenuItem cutItem = new MenuItem(popupMenu, 8);
            cutItem.setText(CommonStringsMessages.cut);
            cutItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    LongCellDialog.this.text.cut();
                }
            });
            MenuItem copyItem = new MenuItem(popupMenu, 8);
            copyItem.setText(CommonStringsMessages.copy);
            copyItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    LongCellDialog.this.text.copy();
                }
            });
            MenuItem pasteItem = new MenuItem(popupMenu, 8);
            pasteItem.setText(CommonStringsMessages.paste);
            pasteItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    LongCellDialog.this.text.paste();
                }
            });
            this.text.setMenu(popupMenu);
            this.text.addVerifyKeyListener(new VerifyKeyListener(){

                public void verifyKey(VerifyEvent event) {
                    if (event.character == '\r') {
                        event.doit = false;
                        LongCellDialog.this.buttonPressed(0);
                    }
                }
            });
            this.errorMessageText = new Text(composite, 8);
            this.errorMessageText.setLayoutData((Object)new GridData(768));
            this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
            this.setErrorMessage(this.errorMessage);
            LongCellDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected Label getErrorMessageLabel() {
            return null;
        }

        protected Button getOkButton() {
            return this.okButton;
        }

        protected StyledText getText() {
            return this.text;
        }

        protected IInputValidator getValidator() {
            return this.validator;
        }

        public String getValue() {
            return this.value;
        }

        protected void validateInput() {
            String errorMessage = null;
            if (this.validator != null) {
                errorMessage = this.validator.isValid(this.text.getText());
            }
            this.setErrorMessage(errorMessage);
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
                this.errorMessageText.setText(errorMessage == null ? "" : errorMessage);
                this.errorMessageText.getParent().update();
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(errorMessage == null);
                }
            }
        }
    }
}

