/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.part;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import net.jsdai.l10n.CommonStringsMessages;
import net.jsdai.l10n.RepoEditBaseMessages;
import net.jsdai.repo_edit.part.AbstractInputField;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileInputField
extends AbstractInputField {
    private final Collection<IFileInputFieldListener> listeners = new ArrayList<IFileInputFieldListener>();
    final String[] names;
    final String[] extensions;

    public static File getFirstExistingParent(File file) {
        File parent = file;
        while ((parent = parent.getParentFile()) != null && !parent.exists()) {
        }
        return parent == null ? new File(".") : parent;
    }

    private static boolean createParentIfNeeded(Shell shell, File file) {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            if (MessageDialog.openQuestion((Shell)shell, (String)CommonStringsMessages.question, (String)RepoEditBaseMessages.FileInputField_CreateParentQuestion)) {
                if (!parent.mkdirs()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public FileInputField(String text, int dialogStyle, String[] extensions, String[] names) {
        super(text, dialogStyle, String.format("%s:", CommonStringsMessages.file));
        if (extensions == null) {
            throw new NullPointerException();
        }
        if (names == null) {
            throw new NullPointerException();
        }
        if (names.length != extensions.length) {
            throw new IllegalArgumentException();
        }
        this.extensions = new String[extensions.length];
        System.arraycopy(extensions, 0, this.extensions, 0, extensions.length);
        this.names = new String[names.length];
        System.arraycopy(names, 0, this.names, 0, names.length);
    }

    public FileInputField(String text, int dialogStyle, String[] extensions, String[] names, String label) {
        super(text, dialogStyle, label);
        if (extensions == null) {
            throw new NullPointerException();
        }
        if (names == null) {
            throw new NullPointerException();
        }
        if (names.length != extensions.length) {
            throw new IllegalArgumentException();
        }
        this.extensions = new String[extensions.length];
        System.arraycopy(extensions, 0, this.extensions, 0, extensions.length);
        this.names = new String[names.length];
        System.arraycopy(names, 0, this.names, 0, names.length);
    }

    public String getFile() {
        return super.getInputValue();
    }

    public void setFile(String text) {
        super.setInputValue(text);
    }

    public File getFileForSave() {
        String filePath = this.getFile();
        File file = new File(filePath);
        if (!FileInputField.createParentIfNeeded(this.inputText.getShell(), file)) {
            MessageDialog.openError((Shell)this.inputText.getShell(), (String)CommonStringsMessages.error, (String)RepoEditBaseMessages.FileInputField_ErrorInCreateParent);
            return null;
        }
        return file.getAbsoluteFile();
    }

    protected Control createButton(final Composite fileBrowseComposite) {
        Button browseButton = new Button(fileBrowseComposite, 8);
        browseButton.setText(String.format("%s...", CommonStringsMessages.browse));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(fileBrowseComposite.getParent().getShell(), FileInputField.this.dialogStyle);
                dialog.setText(FileInputField.this.text);
                dialog.setFilterExtensions(FileInputField.this.extensions);
                dialog.setFilterNames(FileInputField.this.names);
                String inputValue = FileInputField.this.getInputValue();
                if (inputValue.length() == 0 && FileInputField.this.getInitialBrowseFolder() != null) {
                    dialog.setFilterPath(FileInputField.this.getInitialBrowseFolder());
                } else {
                    File parentFile = new File(inputValue).getParentFile();
                    if (parentFile != null) {
                        dialog.setFilterPath(parentFile.getAbsolutePath());
                    }
                    dialog.setFileName(new File(inputValue).getName());
                }
                String exportFileName = dialog.open();
                if (exportFileName != null) {
                    FileInputField.this.inputText.setText(exportFileName);
                }
            }
        });
        return browseButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IFileInputFieldListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Collection<IFileInputFieldListener> collection = this.listeners;
        synchronized (collection) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IFileInputFieldListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Collection<IFileInputFieldListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    protected void fireValueChanged() {
        for (IFileInputFieldListener l : this.listeners) {
            l.valueChanged(this);
        }
    }

    public static interface IFileInputFieldListener {
        public void valueChanged(FileInputField var1);
    }
}

