/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.jsdai.repo_edit.base.Activator;
import net.jsdai.repo_edit.services.IEventListener;
import net.jsdai.repo_edit.services.WeightedRetainKey;

public final class EventService {
    private Collection<IEventListener> listeners = Collections.synchronizedList(new ArrayList());
    private Map<WeightedRetainKey, Object> retainedEventsMap = new TreeMap<WeightedRetainKey, Object>();
    private volatile int fireingEvents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IEventListener listener) {
        ArrayList<Object> localRetainedEvents;
        this.assertNotDisposed();
        if (listener == null) {
            throw new NullPointerException();
        }
        Collection<IEventListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
        Map<WeightedRetainKey, Object> map = this.retainedEventsMap;
        synchronized (map) {
            localRetainedEvents = new ArrayList<Object>(this.retainedEventsMap.values());
        }
        ++this.fireingEvents;
        for (Object e : localRetainedEvents) {
            listener.eventRecieved(e);
        }
        --this.fireingEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IEventListener listener) {
        this.assertNotDisposed();
        if (listener == null) {
            throw new NullPointerException();
        }
        Collection<IEventListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsListener(IEventListener listener) {
        this.assertNotDisposed();
        if (listener == null) {
            throw new NullPointerException();
        }
        Collection<IEventListener> collection = this.listeners;
        synchronized (collection) {
            return this.listeners.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(Object event, WeightedRetainKey retainmentKey) {
        this.assertNotDisposed();
        Map<WeightedRetainKey, Object> map = this.retainedEventsMap;
        synchronized (map) {
            WeightWrapper wr = new WeightWrapper(retainmentKey);
            this.cleanupDependentEvents(wr);
            this.retainedEventsMap.put(wr, event);
        }
        this.fireEvent(event);
    }

    private void cleanupDependentEvents(WeightWrapper wr) {
        if (this.retainedEventsMap.containsKey(wr)) {
            ArrayList<WeightedRetainKey> keys2remove = new ArrayList<WeightedRetainKey>(2);
            for (Map.Entry<WeightedRetainKey, Object> entry : this.retainedEventsMap.entrySet()) {
                WeightedRetainKey crntKey = entry.getKey();
                if (crntKey.getDependsOn() == null) continue;
                Object actualKey = WeightWrapper.getDataForEquals(wr);
                if (crntKey.getDependsOn() != actualKey) continue;
                keys2remove.add(crntKey);
            }
            for (Map.Entry<WeightedRetainKey, Object> entry : keys2remove) {
                this.retainedEventsMap.remove(entry);
            }
        }
    }

    public boolean isFiringEvent() {
        return this.fireingEvents > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(Object event) {
        ArrayList<IEventListener> localListeners;
        this.assertNotDisposed();
        if (Activator.isTracing()) {
            Activator.logInfo("Fire event: " + event, new Exception());
        }
        Collection<IEventListener> collection = this.listeners;
        synchronized (collection) {
            localListeners = new ArrayList<IEventListener>(this.listeners);
        }
        ++this.fireingEvents;
        for (IEventListener listener : localListeners) {
            try {
                listener.eventRecieved(event);
            }
            catch (Exception e) {
                Activator.logError("Failed to send event to listener: " + listener, e);
            }
        }
        --this.fireingEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(Object event, Object retainmentKey) {
        this.assertNotDisposed();
        Map<WeightedRetainKey, Object> map = this.retainedEventsMap;
        synchronized (map) {
            WeightWrapper wr = new WeightWrapper(retainmentKey);
            this.cleanupDependentEvents(wr);
            this.retainedEventsMap.put(wr, event);
        }
        this.fireEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRetainedEvent(Object retainmentKey) {
        this.assertNotDisposed();
        Map<WeightedRetainKey, Object> map = this.retainedEventsMap;
        synchronized (map) {
            this.retainedEventsMap.remove(new WeightWrapper(retainmentKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Collection<IEventListener> collection = this.listeners;
        synchronized (collection) {
            return this.listeners == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Collection<IEventListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners = null;
            this.retainedEventsMap = null;
        }
    }

    private void assertNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Already disposed");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeightWrapper
    implements Comparable<WeightedRetainKey>,
    WeightedRetainKey {
        private WeightedRetainKey key;
        private Object anonymousKey;

        public WeightWrapper(WeightedRetainKey key) {
            this.key = key;
        }

        public WeightWrapper(Object key) {
            if (key instanceof WeightedRetainKey) {
                this.key = (WeightedRetainKey)key;
            } else {
                this.anonymousKey = key;
            }
        }

        @Override
        public int compareTo(WeightedRetainKey otherKey) {
            double hisWt;
            double myWt = this.getAbsoluteWeight();
            if (myWt > (hisWt = otherKey.getAbsoluteWeight())) {
                return 1;
            }
            if (myWt < hisWt) {
                return -1;
            }
            return 0;
        }

        @Override
        public double getAbsoluteWeight() {
            if (this.key != null) {
                return this.key.getAbsoluteWeight();
            }
            return 0.0;
        }

        public int hashCode() {
            if (this.key != null) {
                return this.key.hashCode();
            }
            if (this.anonymousKey != null) {
                return this.anonymousKey.hashCode();
            }
            return 0;
        }

        public boolean equals(Object o) {
            Object hisData;
            WeightWrapper other = (WeightWrapper)o;
            Object myData = WeightWrapper.getDataForEquals(this);
            return myData == (hisData = WeightWrapper.getDataForEquals(other));
        }

        private static Object getDataForEquals(WeightWrapper w) {
            Object myData = null;
            if (w.key != null) {
                myData = w.key;
            } else if (w.anonymousKey != null) {
                myData = w.anonymousKey;
            }
            return myData;
        }

        @Override
        public Object getDependsOn() {
            if (this.key != null) {
                return this.key.getDependsOn();
            }
            return null;
        }
    }
}

